/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.hunterprey;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.examples.hunterprey.Location;
import jadex.examples.hunterprey.WorldObject;
import java.io.Serializable;
import nuggets.ICruncher;
import nuggets.INugget;

public abstract class CreatureData
extends WorldObject
implements INugget,
Serializable {
    protected int age;
    protected int points;
    protected String name;
    protected transient AgentIdentifier aid;
    protected int visionrange;
    protected int worldwidth;
    protected int worldheight;
    protected int leaseticks;

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AgentIdentifier getAID() {
        return this.aid;
    }

    public void setAID(AgentIdentifier aid) {
        this.aid = aid;
    }

    public int getVisionRange() {
        return this.visionrange;
    }

    public void setVisionRange(int visionrange) {
        this.visionrange = visionrange;
    }

    public int getWorldWidth() {
        return this.worldwidth;
    }

    public void setWorldWidth(int worldwidth) {
        this.worldwidth = worldwidth;
    }

    public int getWorldHeight() {
        return this.worldheight;
    }

    public void setWorldHeight(int worldheight) {
        this.worldheight = worldheight;
    }

    public int getLeaseticks() {
        return this.leaseticks;
    }

    public void setLeaseticks(int leaseticks) {
        this.leaseticks = leaseticks;
    }

    public String toString() {
        return "Creature(aid=" + this.getAID() + ", location=" + this.getLocation() + ", name=" + this.getName() + ")";
    }

    public void _persist(ICruncher c) {
        int idAID = c.declare((Object)this.aid);
        int idLocation = c.declare((Object)this.location);
        c.startConcept((Object)this);
        if (this.age != 0) {
            c.put("Age", String.valueOf(this.age));
        }
        if (idAID > 0) {
            c.put("AID", idAID);
        }
        if (this.leaseticks != 0) {
            c.put("Leaseticks", String.valueOf(this.leaseticks));
        }
        if (idLocation > 0) {
            c.put("Location", idLocation);
        }
        if (this.name != null) {
            c.put("Name", this.name);
        }
        if (this.points != 0) {
            c.put("Points", String.valueOf(this.points));
        }
        if (this.visionrange != 0) {
            c.put("VisionRange", String.valueOf(this.visionrange));
        }
        if (this.worldheight != 0) {
            c.put("WorldHeight", String.valueOf(this.worldheight));
        }
        if (this.worldwidth != 0) {
            c.put("WorldWidth", String.valueOf(this.worldwidth));
        }
    }

    public void _set(String a, Object v) {
        switch (CreatureData.hash(a)) {
            case 0: {
                this.aid = (AgentIdentifier)v;
                return;
            }
            case 1: {
                this.visionrange = Integer.parseInt((String)v);
                return;
            }
            case 2: {
                this.leaseticks = Integer.parseInt((String)v);
                return;
            }
            case 3: {
                this.age = Integer.parseInt((String)v);
                return;
            }
            case 4: {
                this.points = Integer.parseInt((String)v);
                return;
            }
            case 5: {
                this.name = (String)v;
                return;
            }
            case 6: {
                this.location = (Location)v;
                return;
            }
            case 7: {
                this.worldwidth = Integer.parseInt((String)v);
                return;
            }
            case 8: {
                this.worldheight = Integer.parseInt((String)v);
                return;
            }
        }
    }

    private static final int hash(String name) {
        int h = 0;
        int c = name.length();
        h += 1970117235 * name.charAt(2);
        if (c <= 5) {
            return (h >>> 15) % 9;
        }
        return ((h += 741244220 * name.charAt(5)) >>> 15) % 9;
    }
}

