/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.hunterprey;

import jadex.examples.hunterprey.CreatureData;
import jadex.examples.hunterprey.Location;
import jadex.examples.hunterprey.Obstacle;
import jadex.examples.hunterprey.RequestMove;
import jadex.examples.hunterprey.WorldObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public abstract class Creature
extends CreatureData {
    public static final String[] alldirs = new String[]{RequestMove.DIRECTION_UP, RequestMove.DIRECTION_RIGHT, RequestMove.DIRECTION_DOWN, RequestMove.DIRECTION_LEFT};

    public boolean equals(Object o) {
        return o instanceof Creature && ((Creature)o).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public Object clone() {
        Creature ret = null;
        try {
            ret = (Creature)this.getClass().newInstance();
            ret.setName(this.getName());
            ret.setAge(this.getAge());
            ret.setPoints(this.getPoints());
            ret.setAID(this.getAID());
            ret.setLocation(this.getLocation());
            ret.setLeaseticks(this.getLeaseticks());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public Location createLocation(String dir) {
        return this.createLocation(this.getLocation(), dir);
    }

    public Location createLocation(Location loc, String dir) {
        int x = loc.getX();
        int y = loc.getY();
        int width = this.getWorldWidth();
        int height = this.getWorldHeight();
        if (RequestMove.DIRECTION_UP.equals(dir)) {
            y = (height + y - 1) % height;
        } else if (RequestMove.DIRECTION_DOWN.equals(dir)) {
            y = (y + 1) % height;
        } else if (RequestMove.DIRECTION_LEFT.equals(dir)) {
            x = (width + x - 1) % width;
        } else if (RequestMove.DIRECTION_RIGHT.equals(dir)) {
            x = (x + 1) % width;
        }
        return new Location(x, y);
    }

    public int getDistance(WorldObject a) {
        return this.getDistance(this.getLocation(), a.getLocation());
    }

    public int getDistance(WorldObject a, WorldObject b) {
        return this.getDistance(a.getLocation(), b.getLocation());
    }

    public int getDistance(Location a, Location b) {
        int dx = Math.abs(a.getX() - b.getX());
        int dy = Math.abs(a.getY() - b.getY());
        if (dx > this.getWorldWidth() / 2) {
            dx = this.getWorldWidth() - dx;
        }
        if (dy > this.getWorldHeight() / 2) {
            dy = this.getWorldHeight() - dy;
        }
        return dx + dy;
    }

    public boolean isNear(Location a, Location b, int range) {
        int dx = Math.abs(a.getX() - b.getX());
        int dy = Math.abs(a.getY() - b.getY());
        if (dx > this.getWorldWidth() / 2) {
            dx = this.getWorldWidth() - dx;
        }
        if (dy > this.getWorldHeight() / 2) {
            dy = this.getWorldHeight() - dy;
        }
        return dx <= range && dy <= range;
    }

    public boolean isInVisionRange(Location a) {
        int dx = Math.abs(a.getX() - this.getLocation().getX());
        int dy = Math.abs(a.getY() - this.getLocation().getY());
        if (dx > this.getWorldWidth() / 2) {
            dx = this.getWorldWidth() - dx;
        }
        if (dy > this.getWorldHeight() / 2) {
            dy = this.getWorldHeight() - dy;
        }
        return dx <= this.getVisionRange() && dy <= this.getVisionRange();
    }

    public String[] getDirections(WorldObject a) {
        return this.getDirections(this.getLocation(), a.getLocation());
    }

    public String[] getDirections(WorldObject a, WorldObject b) {
        return this.getDirections(a.getLocation(), b.getLocation());
    }

    public String[] getDirections(Location a, Location b) {
        int distance = this.getDistance(a, b);
        ArrayList<String> directions = new ArrayList<String>();
        directions.add(RequestMove.DIRECTION_UP);
        directions.add(RequestMove.DIRECTION_DOWN);
        directions.add(RequestMove.DIRECTION_LEFT);
        directions.add(RequestMove.DIRECTION_RIGHT);
        Iterator i = directions.iterator();
        while (i.hasNext()) {
            if (this.getDistance(this.createLocation(a, (String)i.next()), b) < distance) continue;
            i.remove();
        }
        return directions.toArray(new String[directions.size()]);
    }

    public void sortByDistance(WorldObject[] objects) {
        this.sortByDistance(objects, this.getLocation());
    }

    public void sortByDistance(WorldObject[] objects, final Location loc) {
        Arrays.sort(objects, new Comparator(){

            public int compare(Object o1, Object o2) {
                return Creature.this.getDistance(loc, ((WorldObject)o1).getLocation()) - Creature.this.getDistance(loc, ((WorldObject)o2).getLocation());
            }
        });
    }

    public WorldObject getObject(Location loc, WorldObject[] objects) {
        WorldObject ret = null;
        for (int i = 0; i < objects.length; ++i) {
            if (!objects[i].getLocation().equals(loc)) continue;
            ret = objects[i];
        }
        return ret;
    }

    public String[] getPossibleDirections(WorldObject[] objects) {
        ArrayList<String> posdirs = new ArrayList<String>();
        for (int i = 0; i < alldirs.length; ++i) {
            if (this.getObject(this.createLocation(alldirs[i]), objects) instanceof Obstacle) continue;
            posdirs.add(alldirs[i]);
        }
        return posdirs.toArray(new String[posdirs.size()]);
    }
}

