/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.garbagecollector;

import jadex.examples.garbagecollector.Environment;
import jadex.examples.garbagecollector.Position;
import jadex.examples.garbagecollector.WorldObject;
import jadex.util.SGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;

public class MapPanel
extends JPanel {
    public static UIDefaults icons = new UIDefaults(new Object[]{"burner", SGUI.makeIcon((Class)MapPanel.class, (String)"/jadex/examples/garbagecollector/images/burner.png"), "collector", SGUI.makeIcon((Class)MapPanel.class, (String)"/jadex/examples/garbagecollector/images/collector.png"), "garbage", SGUI.makeIcon((Class)MapPanel.class, (String)"/jadex/examples/garbagecollector/images/garbage.png")});
    protected JLabel burner;
    protected JLabel collector;
    protected JLabel garbage;
    protected Image burner_image;
    protected Image collector_image;
    protected Image garbage_image;
    protected Environment env;
    protected boolean rescale;

    public MapPanel(Environment env) {
        this.env = env;
        this.burner_image = ((ImageIcon)icons.getIcon("burner")).getImage();
        this.collector_image = ((ImageIcon)icons.getIcon("collector")).getImage();
        this.garbage_image = ((ImageIcon)icons.getIcon("garbage")).getImage();
        this.burner = new JLabel(new ImageIcon(this.burner_image), 0);
        this.collector = new JLabel(new ImageIcon(this.collector_image), 0);
        this.garbage = new JLabel(new ImageIcon(this.garbage_image), 0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ce) {
                MapPanel.this.rescale = true;
            }
        });
        env.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MapPanel.this.invalidate();
                MapPanel.this.repaint();
            }
        });
    }

    protected void paintComponent(Graphics g) {
        Rectangle bounds = this.getBounds();
        g.setColor(this.getBackground());
        g.fillRect((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        double cellw = bounds.getWidth() / (double)this.env.getGridSize();
        double cellh = bounds.getHeight() / (double)this.env.getGridSize();
        if (this.rescale) {
            ((ImageIcon)this.burner.getIcon()).setImage(this.burner_image.getScaledInstance((int)cellw, (int)cellh, 1));
            ((ImageIcon)this.collector.getIcon()).setImage(this.collector_image.getScaledInstance((int)cellw, (int)cellh, 1));
            ((ImageIcon)this.garbage.getIcon()).setImage(this.garbage_image.getScaledInstance((int)cellw, (int)cellh, 1));
            this.rescale = false;
        }
        WorldObject[] wos = this.env.getWorldObjects();
        for (int i = 0; i < wos.length; ++i) {
            this.renderObject(g, wos[i], cellw, cellh);
        }
        g.setColor(Color.black);
        g.drawRect(0, 0, bounds.width - 1, bounds.height - 1);
        for (double x = 0.0; x < (double)bounds.width; x += cellw) {
            g.drawLine((int)x, 0, (int)x, bounds.height - 1);
        }
        for (double y = 0.0; y < (double)bounds.height; y += cellh) {
            g.drawLine(0, (int)y, bounds.width - 1, (int)y);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void renderObject(Graphics g, WorldObject wo, double cellw, double cellh) {
        void var8_6;
        JLabel comp;
        Position loc = wo.getPosition();
        if (wo.getType().equals("GarbageBurner")) {
            comp = this.burner;
        } else if (wo.getType().equals("GarbageCollector")) {
            comp = this.collector;
        } else if (wo.getType().equals("Garbage")) {
            comp = this.garbage;
        } else {
            throw new RuntimeException("Unknown type of object: " + wo);
        }
        SGUI.renderObject((Graphics)g, (Component)var8_6, (double)cellw, (double)cellh, (int)loc.getX(), (int)loc.getY(), (int)1);
    }
}

