/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.garbagecollector;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.examples.garbagecollector.Environment;
import jadex.examples.garbagecollector.MapPanel;
import jadex.examples.garbagecollector.WorldObject;
import jadex.runtime.AgentEvent;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IAgentListener;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoal;
import jadex.util.SGUI;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class EnvironmentGui
extends JFrame {
    public EnvironmentGui(final IExternalAccess agent) {
        super("Garbage Collector Environment");
        MapPanel map = new MapPanel((Environment)agent.getBeliefbase().getBelief("env").getFact());
        this.getContentPane().add("Center", map);
        this.setSize(400, 400);
        this.setLocation(SGUI.calculateMiddlePosition((Window)this));
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Environment env = (Environment)agent.getBeliefbase().getBelief("env").getFact();
                WorldObject[] wobs = env.getWorldObjects();
                for (int i = 0; i < wobs.length; ++i) {
                    if (!wobs[i].getType().equals("GarbageBurner") && !wobs[i].getType().equals("GarbageCollector")) continue;
                    try {
                        IGoal kill = agent.createGoal("ams_destroy_agent");
                        kill.getParameter("agentidentifier").setValue((Object)new AgentIdentifier(wobs[i].getName(), true));
                        agent.dispatchTopLevelGoalAndWait(kill);
                        continue;
                    }
                    catch (GoalFailureException gfe) {
                        // empty catch block
                    }
                }
                agent.killAgent();
            }
        });
        agent.addAgentListener(new IAgentListener(){

            public void agentTerminating(AgentEvent ae) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        2.access$000(this.this$1).dispose();
                    }
                });
            }

            static /* synthetic */ EnvironmentGui access$000(2 x0) {
                return x0.EnvironmentGui.this;
            }
        }, false);
    }
}

