/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.garbagecollector;

import jadex.examples.garbagecollector.Position;
import jadex.examples.garbagecollector.WorldObject;
import jadex.util.SimplePropertyChangeSupport;
import jadex.util.collection.MultiCollection;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;

public class Environment {
    public static final String UP = "up";
    public static final String DOWN = "down";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String BURNER = "GarbageBurner";
    public static final String COLLECTOR = "GarbageCollector";
    public static final String GARBAGE = "Garbage";
    protected int size;
    protected HashMap name_objects;
    protected MultiCollection pos_objects;
    protected Random randgen;
    public SimplePropertyChangeSupport pcs;
    protected static Environment instance;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Environment(int size) {
        this.size = size;
        this.name_objects = new HashMap();
        this.pos_objects = new MultiCollection();
        this.randgen = new Random();
        this.pcs = new SimplePropertyChangeSupport((Object)this);
    }

    public static Environment getInstance(String type, String name) {
        if (instance == null) {
            instance = new Environment(10);
        }
        if (type != null && name != null) {
            instance.addWorldObject(type, name, null);
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorldObject(String type, String name, Position pos) {
        WorldObject wo;
        Environment environment = this;
        synchronized (environment) {
            Position newpos;
            Position position = newpos = pos != null ? pos : this.getFreePosition();
            if (newpos == null) {
                newpos = this.getRandomPosition();
            }
            wo = new WorldObject(name, type, newpos);
            this.name_objects.put(name, wo);
            this.pos_objects.put((Object)wo.getPosition(), (Object)wo);
        }
        this.pcs.firePropertyChange("new_world_object", null, (Object)wo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go(String name, String dir) {
        Position newpos;
        Position pos;
        Environment environment = this;
        synchronized (environment) {
            if (!($assertionsDisabled || dir.equals(UP) || dir.equals(DOWN) || dir.equals(LEFT) || dir.equals(RIGHT))) {
                throw new AssertionError();
            }
            pos = this.getPosition(name);
            newpos = null;
            int px = pos.getX();
            int py = pos.getY();
            if (UP.equals(dir)) {
                newpos = new Position(px, (py - 1 + this.size) % this.size);
            } else if (DOWN.equals(dir)) {
                newpos = new Position(px, (py + 1) % this.size);
            } else if (LEFT.equals(dir)) {
                newpos = new Position((px - 1 + this.size) % this.size, py);
            } else if (RIGHT.equals(dir)) {
                newpos = new Position((px + 1) % this.size, py);
            }
            if (!$assertionsDisabled && newpos == null) {
                throw new AssertionError();
            }
            if (!($assertionsDisabled || newpos.getX() >= 0 && newpos.getX() < this.size)) {
                throw new AssertionError();
            }
            if (!($assertionsDisabled || newpos.getY() >= 0 && newpos.getY() < this.size)) {
                throw new AssertionError();
            }
            WorldObject wo = this.getWorldObject(name);
            this.pos_objects.remove((Object)wo.getPosition(), (Object)wo);
            this.getWorldObject(name).setPosition(newpos);
            this.pos_objects.put((Object)wo.getPosition(), (Object)wo);
        }
        this.pcs.firePropertyChange("agent_moved", (Object)pos, (Object)newpos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(String name) {
        WorldObject garb;
        Environment environment = this;
        synchronized (environment) {
            if (!$assertionsDisabled && this.getWorldObject(name).getProperty(GARBAGE) == null) {
                throw new AssertionError();
            }
            WorldObject robot = this.getWorldObject(name);
            garb = (WorldObject)robot.getProperty(GARBAGE);
            garb.setPosition(robot.getPosition());
            this.pos_objects.put((Object)garb.getPosition(), (Object)garb);
            this.name_objects.put(garb.getName(), garb);
            robot.setProperty(GARBAGE, null);
        }
        this.pcs.firePropertyChange("new_garbage", null, (Object)garb);
    }

    public synchronized boolean pickup(String name) {
        WorldObject wo = this.getWorldObject(name);
        if (!$assertionsDisabled && wo.getProperty(GARBAGE) != null) {
            throw new AssertionError((Object)name);
        }
        if (!this.isDirty(wo.getPosition())) {
            return false;
        }
        boolean ret = false;
        if (Math.random() > 0.5) {
            Position pos = this.getPosition(name);
            WorldObject[] wos = this.getWorldObjects(pos);
            WorldObject garb = null;
            for (int i = 0; i < wos.length && garb == null; ++i) {
                if (!wos[i].getType().equals(GARBAGE)) continue;
                garb = wos[i];
            }
            if (garb != null) {
                wo.setProperty(GARBAGE, garb);
                this.name_objects.remove(garb.getName());
                this.pos_objects.remove((Object)pos, (Object)garb);
                ret = true;
                this.pcs.firePropertyChange("garbage_pickedup", null, (Object)garb);
            }
        }
        return ret;
    }

    public synchronized void burn(String name) {
        if (!$assertionsDisabled && this.getWorldObject(name).getProperty(GARBAGE) == null) {
            throw new AssertionError();
        }
        this.getWorldObject(name).setProperty(GARBAGE, null);
    }

    public synchronized boolean isDirty(Position pos) {
        boolean dirty = false;
        WorldObject[] wos = this.getWorldObjects(pos);
        for (int i = 0; i < wos.length && !dirty; ++i) {
            if (!wos[i].getType().equals(GARBAGE)) continue;
            dirty = true;
        }
        return dirty;
    }

    public synchronized boolean hasGarbage(String name) {
        boolean hasgarb = false;
        WorldObject wo = this.getWorldObject(name);
        if (wo != null) {
            hasgarb = wo.getProperty(GARBAGE) != null;
        }
        return hasgarb;
    }

    public synchronized Position getPosition(String name) {
        if (!$assertionsDisabled && !this.name_objects.containsKey(name)) {
            throw new AssertionError();
        }
        return ((WorldObject)this.name_objects.get(name)).getPosition();
    }

    public synchronized int getGridSize() {
        return this.size;
    }

    public synchronized Position getBurnerPosition() {
        ArrayList<Position> pospos = new ArrayList<Position>();
        WorldObject[] wos = this.getWorldObjects();
        for (int i = 0; i < wos.length; ++i) {
            if (!wos[i].getType().equals(BURNER)) continue;
            pospos.add(wos[i].getPosition());
        }
        if (!$assertionsDisabled && pospos.size() <= 0) {
            throw new AssertionError();
        }
        return (Position)pospos.get(this.randgen.nextInt(pospos.size()));
    }

    public synchronized boolean isBurnerPresent(Position pos) {
        boolean ret = false;
        WorldObject[] wos = this.getWorldObjects();
        for (int i = 0; i < wos.length && !ret; ++i) {
            if (!wos[i].getType().equals(BURNER) || !wos[i].getPosition().equals(pos)) continue;
            ret = true;
        }
        return ret;
    }

    protected WorldObject getWorldObject(String name) {
        if (!$assertionsDisabled && !this.name_objects.containsKey(name)) {
            throw new AssertionError();
        }
        return (WorldObject)this.name_objects.get(name);
    }

    protected WorldObject getRobot(String name) {
        if (!$assertionsDisabled && this.getWorldObject(name).getType().equals(GARBAGE)) {
            throw new AssertionError();
        }
        return this.getWorldObject(name);
    }

    protected WorldObject[] getWorldObjects(Position pos) {
        Collection col = (Collection)this.pos_objects.get((Object)pos);
        return col.toArray(new WorldObject[col.size()]);
    }

    public String[] getGarbages(Position pos) {
        WorldObject[] wos = this.getWorldObjects(pos);
        ArrayList<String> garbs = new ArrayList<String>();
        for (int i = 0; i < wos.length; ++i) {
            if (!wos[i].getType().equals(GARBAGE)) continue;
            garbs.add(wos[i].getName());
        }
        return garbs.toArray(new String[garbs.size()]);
    }

    protected WorldObject[] getWorldObjects() {
        return this.name_objects.values().toArray(new WorldObject[this.name_objects.size()]);
    }

    protected Position getFreePosition() {
        Position pos;
        int cnt = 0;
        while (!this.isFree(pos = this.getRandomPosition()) && cnt++ < 20) {
        }
        if (!this.isFree(pos)) {
            pos = null;
        }
        return pos;
    }

    protected Position getRandomPosition() {
        int x = this.randgen.nextInt(this.size);
        int y = this.randgen.nextInt(this.size);
        return new Position(x, y);
    }

    protected boolean isFree(Position pos) {
        boolean free = true;
        if (this.pos_objects.get((Object)pos) != null) {
            WorldObject[] wos = this.getWorldObjects(pos);
            for (int i = 0; i < wos.length && free; ++i) {
                if (!wos[i].getPosition().equals(pos)) continue;
                free = false;
            }
        }
        return free;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    static {
        $assertionsDisabled = !Environment.class.desiredAssertionStatus();
    }
}

