/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.cleanerworld.single;

import jadex.examples.cleanerworld.single.Location;
import jadex.runtime.AgentDeathException;
import jadex.runtime.AgentEvent;
import jadex.runtime.IAgentListener;
import jadex.runtime.IExpression;
import jadex.runtime.IExternalAccess;
import jadex.util.SGUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CleanerGui
extends JFrame {
    public CleanerGui(final IExternalAccess agent) {
        super("Cleaner World");
        final JPanel map = new JPanel(){

            protected void paintComponent(Graphics g) {
                try {
                    int i;
                    Location agentloc = (Location)agent.getBeliefbase().getBelief("my_location").getFact();
                    Location[] wastelocs = (Location[])agent.getExternalAccess().getBeliefbase().getBeliefSet("waste_locations").getFacts();
                    Location[] kwastelocs = (Location[])agent.getExternalAccess().getBeliefbase().getBeliefSet("known_waste_locations").getFacts();
                    Location chargeloc = (Location)agent.getExternalAccess().getBeliefbase().getBelief("chargingstation_location").getFact();
                    double vision = (Double)agent.getBeliefbase().getBelief("vision").getFact();
                    double charge = (Double)agent.getBeliefbase().getBelief("chargestate").getFact();
                    boolean waste = (Boolean)agent.getBeliefbase().getBelief("carrieswaste").getFact();
                    boolean daytime = (Boolean)agent.getBeliefbase().getBelief("daytime").getFact();
                    Rectangle bounds = this.getBounds();
                    g.setColor(daytime ? Color.lightGray : Color.darkGray);
                    g.fillRect(0, 0, bounds.width, bounds.height);
                    Point p = CleanerGui.this.onScreenLocation(agentloc, bounds);
                    int w = (int)(vision * (double)bounds.width);
                    int h = (int)(vision * (double)bounds.height);
                    g.setColor(Color.yellow);
                    g.fillOval(p.x - w, p.y - h, w * 2, h * 2);
                    g.setColor(Color.black);
                    g.fillOval(p.x - 3, p.y - 3, 7, 7);
                    g.drawString(agent.getAgentName(), p.x + 5, p.y - 5);
                    g.drawString("battery: " + (int)(charge * 100.0) + "%", p.x + 5, p.y + 5);
                    g.drawString("waste: " + (waste ? "yes" : "no"), p.x + 5, p.y + 15);
                    g.setColor(Color.blue);
                    p = CleanerGui.this.onScreenLocation(chargeloc, bounds);
                    g.drawRect(p.x - 10, p.y - 10, 21, 21);
                    g.setColor(daytime ? Color.black : Color.white);
                    g.drawString("Charge Station", p.x + 14, p.y + 5);
                    Location loci = (Location)agent.getBeliefbase().getBelief("wastebin_location").getFact();
                    g.setColor(Color.red);
                    p = CleanerGui.this.onScreenLocation(loci, bounds);
                    g.drawOval(p.x - 10, p.y - 10, 21, 21);
                    g.setColor(daytime ? Color.black : Color.white);
                    g.drawString("Wastebin", p.x + 14, p.y + 5);
                    for (i = 0; i < wastelocs.length; ++i) {
                        g.setColor(Color.red);
                        p = CleanerGui.this.onScreenLocation(wastelocs[i], bounds);
                        g.fillOval(p.x - 3, p.y - 3, 7, 7);
                    }
                    for (i = 0; i < kwastelocs.length; ++i) {
                        g.setColor(Color.black);
                        p = CleanerGui.this.onScreenLocation(kwastelocs[i], bounds);
                        g.drawLine(p.x, p.y - 5, p.x, p.y + 5);
                        g.drawLine(p.x - 5, p.y, p.x + 5, p.y);
                    }
                }
                catch (AgentDeathException agentDeathException) {
                    // empty catch block
                }
            }
        };
        JPanel options = new JPanel();
        final JCheckBox daytime = new JCheckBox("daytime", (boolean)((Boolean)agent.getBeliefbase().getBelief("daytime").getFact()));
        daytime.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                agent.getBeliefbase().getBelief("daytime").setFact((Object)new Boolean(daytime.isSelected()));
            }
        });
        options.add(daytime);
        this.getContentPane().add("North", options);
        this.getContentPane().add("Center", map);
        this.setSize(600, 600);
        this.setLocation(SGUI.calculateMiddlePosition((Window)this));
        this.setVisible(true);
        map.addMouseListener(new MouseAdapter(){
            IExpression nearest;

            public void mouseClicked(MouseEvent me) {
                Point p = me.getPoint();
                Rectangle bounds = map.getBounds();
                Location mouseloc = new Location((double)p.x / (double)bounds.width, 1.0 - (double)p.y / (double)bounds.height);
                double tol = 7.0 / (double)bounds.height;
                if (this.nearest == null) {
                    this.nearest = agent.getExpressionbase().getExpression("nearest_waste");
                }
                this.nearest.setParameter("$mouseloc", (Object)mouseloc);
                this.nearest.setParameter("$tol", (Object)new Double(tol));
                Location wasteloc = (Location)this.nearest.execute();
                if (wasteloc != null) {
                    agent.getBeliefbase().getBeliefSet("waste_locations").removeFact((Object)wasteloc);
                } else {
                    agent.getBeliefbase().getBeliefSet("waste_locations").addFact((Object)mouseloc);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                agent.killAgent();
            }
        });
        agent.addAgentListener(new IAgentListener(){

            public void agentTerminating(AgentEvent ae) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        5.access$000(this.this$1).dispose();
                    }
                });
            }

            static /* synthetic */ CleanerGui access$000(5 x0) {
                return x0.CleanerGui.this;
            }
        }, false);
        Timer timer = new Timer(50, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                map.invalidate();
                map.repaint();
            }
        });
        timer.start();
    }

    protected Point onScreenLocation(Location loc, Rectangle bounds) {
        return new Point((int)((double)bounds.width * loc.x), (int)((double)bounds.height * (1.0 - loc.y)));
    }
}

