/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.cleanerworld.multi.environment;

import jadex.adapter.fipa.AgentDescription;
import jadex.adapter.fipa.Done;
import jadex.adapter.fipa.ServiceDescription;
import jadex.examples.cleanerworld.multi.Chargingstation;
import jadex.examples.cleanerworld.multi.Cleaner;
import jadex.examples.cleanerworld.multi.Environment;
import jadex.examples.cleanerworld.multi.RequestCompleteVision;
import jadex.examples.cleanerworld.multi.Vision;
import jadex.examples.cleanerworld.multi.Waste;
import jadex.examples.cleanerworld.multi.Wastebin;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;

public class UpdateEnvironmentPlan
extends Plan {
    public UpdateEnvironmentPlan() {
        this.getLogger().info("Created: " + (Object)((Object)this));
    }

    public void body() {
        while (true) {
            if (this.getBeliefbase().getBelief("environmentagent").getFact() == null) {
                this.searchEnvironmentAgent();
            }
            if (this.getBeliefbase().getBelief("environmentagent").getFact() == null) {
                this.waitFor(5000L);
                continue;
            }
            RequestCompleteVision rv = new RequestCompleteVision();
            IGoal rg = this.createGoal("rp_initiate");
            rg.getParameter("receiver").setValue(this.getBeliefbase().getBelief("environmentagent").getFact());
            rg.getParameter("content").setValue((Object)rv);
            rg.getParameter("ontology").setValue((Object)"cleaner_beans");
            try {
                this.dispatchSubgoalAndWait(rg);
                Environment env = (Environment)this.getBeliefbase().getBelief("environment").getFact();
                env.clear();
                Vision vision = ((RequestCompleteVision)((Done)rg.getParameter("result").getValue()).getAction()).getVision();
                Cleaner[] cleaners = vision.getCleaners();
                for (int i = 0; i < cleaners.length; ++i) {
                    env.addCleaner(cleaners[i]);
                }
                Waste[] wastes = vision.getWastes();
                for (int i = 0; i < wastes.length; ++i) {
                    env.addWaste(wastes[i]);
                }
                Wastebin[] wastebins = vision.getWastebins();
                for (int i = 0; i < wastebins.length; ++i) {
                    env.addWastebin(wastebins[i]);
                }
                Chargingstation[] stations = vision.getStations();
                for (int i = 0; i < stations.length; ++i) {
                    env.addChargingStation(stations[i]);
                }
                env.setDaytime(vision.isDaytime());
            }
            catch (GoalFailureException gfe) {
                gfe.printStackTrace();
                this.getLogger().warning("Request vision failed: " + (Object)((Object)gfe));
            }
            this.waitFor(100L);
        }
    }

    protected void searchEnvironmentAgent() {
        ServiceDescription sd = new ServiceDescription();
        sd.setType("dispatch vision");
        AgentDescription dfadesc = new AgentDescription();
        dfadesc.addService(sd);
        IGoal ft = this.createGoal("df_search");
        ft.getParameter("description").setValue((Object)dfadesc);
        if (this.getBeliefbase().getBelief("df").getFact() != null) {
            ft.getParameter("df").setValue(this.getBeliefbase().getBelief("df").getFact());
        }
        try {
            AgentDescription[] tas;
            this.dispatchSubgoalAndWait(ft);
            Object[] result = ft.getParameterSet("result").getValues();
            if (result instanceof AgentDescription[] && (tas = (AgentDescription[])result).length != 0) {
                this.getBeliefbase().getBelief("environmentagent").setFact((Object)tas[0].getName());
                if (tas.length > 1) {
                    System.out.println("WARNING: more than environment agent found.");
                }
            }
        }
        catch (GoalFailureException gfe) {
            this.getLogger().warning("DF search failed: " + (Object)((Object)gfe));
        }
    }
}

