/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.cleanerworld.multi.environment;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.examples.cleanerworld.multi.Chargingstation;
import jadex.examples.cleanerworld.multi.Cleaner;
import jadex.examples.cleanerworld.multi.Environment;
import jadex.examples.cleanerworld.multi.Location;
import jadex.examples.cleanerworld.multi.Waste;
import jadex.examples.cleanerworld.multi.Wastebin;
import jadex.runtime.AgentEvent;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IAgentListener;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoal;
import jadex.util.SGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EnvironmentGui
extends JFrame {
    private static UIDefaults icons = new UIDefaults(new Object[]{"waste", SGUI.makeIcon((Class)EnvironmentGui.class, (String)"/jadex/examples/cleanerworld/images/waste.png"), "wastebin", SGUI.makeIcon((Class)EnvironmentGui.class, (String)"/jadex/examples/cleanerworld/images/wastebin.png"), "wastebin_full", SGUI.makeIcon((Class)EnvironmentGui.class, (String)"/jadex/examples/cleanerworld/images/wastebin_full.png"), "chargingstation", SGUI.makeIcon((Class)EnvironmentGui.class, (String)"/jadex/examples/cleanerworld/images/chargingstation.png"), "cleaner", SGUI.makeIcon((Class)EnvironmentGui.class, (String)"/jadex/examples/cleanerworld/images/cleaner.png"), "background", SGUI.makeIcon((Class)EnvironmentGui.class, (String)"/jadex/examples/cleanerworld/images/background.png"), "background_night", SGUI.makeIcon((Class)EnvironmentGui.class, (String)"/jadex/examples/cleanerworld/images/background_night.png")});

    public EnvironmentGui(final IExternalAccess agent) {
        super(agent.getAgentName());
        final Environment env = (Environment)agent.getBeliefbase().getBelief("environment").getFact();
        JPanel options = new JPanel(new GridBagLayout());
        options.setBorder(new TitledBorder(new EtchedBorder(1), "Environment Control"));
        final JCheckBox daytime = new JCheckBox("", env.getDaytime());
        daytime.setHorizontalTextPosition(2);
        final JLabel wastecnt = new JLabel("0");
        final JComboBox<String> wastebinchoice = new JComboBox<String>();
        Wastebin[] wastebins = env.getWastebins();
        for (int i = 0; i < wastebins.length; ++i) {
            wastebinchoice.addItem(wastebins[i].getName());
        }
        final JComboBox<String> fillstate = new JComboBox<String>(new String[]{"empty", "full"});
        JButton setfillstate = new JButton("Set fill-state");
        Insets insets = new Insets(2, 4, 4, 2);
        options.add((Component)new JLabel("Toggle daytime"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)daytime, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)new JLabel("Waste count:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)wastecnt, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)new JLabel("Wastebin:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        options.add(wastebinchoice, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        options.add(fillstate, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        options.add((Component)setfillstate, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        final Image waste_image = ((ImageIcon)icons.getIcon("waste")).getImage();
        final Image wastebin_image = ((ImageIcon)icons.getIcon("wastebin")).getImage();
        final Image wastebin_full_image = ((ImageIcon)icons.getIcon("wastebin_full")).getImage();
        final Image chargingstation_image = ((ImageIcon)icons.getIcon("chargingstation")).getImage();
        final Image cleaner_image = ((ImageIcon)icons.getIcon("cleaner")).getImage();
        final Image background_image = ((ImageIcon)icons.getIcon("background")).getImage();
        final Image background_night_image = ((ImageIcon)icons.getIcon("background_night")).getImage();
        final JLabel waste = new JLabel(new ImageIcon(waste_image), 0);
        final JLabel wastebin = new JLabel("dummy", new ImageIcon(wastebin_image), 0);
        wastebin.setVerticalTextPosition(3);
        wastebin.setHorizontalTextPosition(0);
        final JLabel wastebin_full = new JLabel("dummy", new ImageIcon(wastebin_full_image), 0);
        wastebin_full.setVerticalTextPosition(3);
        wastebin_full.setHorizontalTextPosition(0);
        final JLabel chargingstation = new JLabel("dummy", new ImageIcon(chargingstation_image), 0);
        chargingstation.setVerticalTextPosition(3);
        chargingstation.setHorizontalTextPosition(0);
        final JLabel cleaner = new JLabel("dummy", new ImageIcon(cleaner_image), 0);
        cleaner.setVerticalTextPosition(0);
        cleaner.setHorizontalTextPosition(4);
        env.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ce) {
                String propertyname = ce.getPropertyName();
                if ("daytime".equals(propertyname)) {
                    if (daytime.isSelected() != ((Boolean)ce.getNewValue()).booleanValue()) {
                        daytime.setSelected((Boolean)ce.getNewValue());
                    }
                } else if ("wastebins".equals(propertyname)) {
                    if (ce.getNewValue() == null) {
                        String name = ((Wastebin)ce.getOldValue()).getName();
                        ((DefaultComboBoxModel)wastebinchoice.getModel()).removeElement(name);
                    } else {
                        String name = ((Wastebin)ce.getNewValue()).getName();
                        int size = wastebinchoice.getModel().getSize();
                        boolean found = false;
                        for (int i = 0; i < size && !found; ++i) {
                            String wbname = (String)wastebinchoice.getModel().getElementAt(i);
                            if (!wbname.equals(name)) continue;
                            found = true;
                        }
                        if (!found) {
                            ((DefaultComboBoxModel)wastebinchoice.getModel()).addElement(name);
                        }
                    }
                } else if ("wastes".equals(propertyname)) {
                    wastecnt.setText("" + env.getWastes().length);
                } else if ("chargingstations".equals(propertyname)) {
                    // empty if block
                }
            }
        });
        final JPanel map = new JPanel(){

            protected void paintComponent(Graphics g) {
                int i;
                boolean daytime = env.getDaytime();
                Rectangle bounds = this.getBounds();
                Image image = daytime ? background_image : background_night_image;
                int w = image.getWidth(this);
                int h = image.getHeight(this);
                if (w > 0 && h > 0) {
                    for (int y = 0; y < bounds.height; y += h) {
                        for (int x = 0; x < bounds.width; x += w) {
                            g.drawImage(image, x, y, this);
                        }
                    }
                }
                Chargingstation[] stations = env.getChargingstations();
                for (int i2 = 0; i2 < stations.length; ++i2) {
                    Point p = EnvironmentGui.this.onScreenLocation(stations[i2].getLocation(), bounds);
                    chargingstation.setText(stations[i2].getName());
                    chargingstation.setForeground(daytime ? Color.black : Color.white);
                    EnvironmentGui.this.render(g, chargingstation, p);
                }
                Wastebin[] wastebins = env.getWastebins();
                for (int i3 = 0; i3 < wastebins.length; ++i3) {
                    Point p = EnvironmentGui.this.onScreenLocation(wastebins[i3].getLocation(), bounds);
                    JLabel renderer = wastebin;
                    if (wastebins[i3].isFull()) {
                        renderer = wastebin_full;
                    }
                    renderer.setText(wastebins[i3].getName() + " (" + wastebins[i3].getWastes().length + "/" + wastebins[i3].getCapacity() + ")");
                    renderer.setForeground(daytime ? Color.black : Color.white);
                    EnvironmentGui.this.render(g, renderer, p);
                }
                Waste[] wastes = env.getWastes();
                for (int i4 = 0; i4 < wastes.length; ++i4) {
                    Point p = EnvironmentGui.this.onScreenLocation(wastes[i4].getLocation(), bounds);
                    waste.setForeground(daytime ? Color.black : Color.white);
                    EnvironmentGui.this.render(g, waste, p);
                }
                wastecnt.setText("" + wastes.length);
                Cleaner[] cleaners = env.getCleaners();
                for (i = 0; i < cleaners.length; ++i) {
                    Point p = EnvironmentGui.this.onScreenLocation(cleaners[i].getLocation(), bounds);
                    w = (int)(cleaners[i].getVisionRange() * (double)bounds.width);
                    h = (int)(cleaners[i].getVisionRange() * (double)bounds.height);
                    g.setColor(new Color(255, 255, 0, Math.max(192 - env.getAge(cleaners[i]) * 4, 0)));
                    g.fillOval(p.x - w, p.y - h, w * 2, h * 2);
                }
                for (i = 0; i < cleaners.length; ++i) {
                    int age = env.getAge(cleaners[i]);
                    Point p = EnvironmentGui.this.onScreenLocation(cleaners[i].getLocation(), bounds);
                    cleaner.setText("<html>" + cleaners[i].getName() + "<br>" + "battery: " + (int)(cleaners[i].getChargestate() * 100.0) + "%<br>" + "waste: " + (cleaners[i].getCarriedWaste() != null ? "yes" : "no") + "</html>");
                    cleaner.setForeground(daytime ? new Color(age * 2, age * 2, age * 2) : new Color(255 - age * 2, 255 - age * 2, 255 - age * 2));
                    EnvironmentGui.this.render(g, cleaner, new Point(p.x + 35, p.y));
                }
            }
        };
        wastebinchoice.setPreferredSize(new Dimension((int)wastebinchoice.getPreferredSize().getWidth() + 10, (int)wastebinchoice.getPreferredSize().getHeight()));
        fillstate.setPreferredSize(new Dimension((int)fillstate.getPreferredSize().getWidth() + 10, (int)fillstate.getPreferredSize().getHeight()));
        daytime.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                env.setDaytime(daytime.isSelected());
            }
        });
        setfillstate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Wastebin wb = env.getWastebin((String)wastebinchoice.getSelectedItem());
                if (fillstate.getSelectedItem().equals("empty")) {
                    wb.empty();
                }
                if (fillstate.getSelectedItem().equals("full")) {
                    wb.fill();
                }
            }
        });
        map.addComponentListener(new ComponentAdapter(){
            protected Rectangle _bounds;

            public void componentResized(ComponentEvent ce) {
                Rectangle bounds = map.getBounds();
                if (this._bounds == null) {
                    this._bounds = bounds;
                }
                double scale = Math.min((double)bounds.width / (double)this._bounds.width, (double)bounds.height / (double)this._bounds.height);
                ((ImageIcon)waste.getIcon()).setImage(waste_image.getScaledInstance((int)((double)waste_image.getWidth(map) * scale), (int)((double)waste_image.getHeight(map) * scale), 1));
                ((ImageIcon)wastebin.getIcon()).setImage(wastebin_image.getScaledInstance((int)((double)wastebin_image.getWidth(map) * scale), (int)((double)wastebin_image.getHeight(map) * scale), 1));
                ((ImageIcon)wastebin_full.getIcon()).setImage(wastebin_full_image.getScaledInstance((int)((double)wastebin_full_image.getWidth(map) * scale), (int)((double)wastebin_full_image.getHeight(map) * scale), 1));
                ((ImageIcon)chargingstation.getIcon()).setImage(chargingstation_image.getScaledInstance((int)((double)chargingstation_image.getWidth(map) * scale), (int)((double)chargingstation_image.getHeight(map) * scale), 1));
                ((ImageIcon)cleaner.getIcon()).setImage(cleaner_image.getScaledInstance((int)((double)cleaner_image.getWidth(map) * scale), (int)((double)cleaner_image.getHeight(map) * scale), 1));
            }
        });
        map.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent me) {
                Point p = me.getPoint();
                Rectangle bounds = map.getBounds();
                Location mouseloc = new Location((double)p.x / (double)bounds.width, 1.0 - (double)p.y / (double)bounds.height);
                double tol = 7.0 / (double)bounds.height;
                Environment env = (Environment)agent.getBeliefbase().getBelief("environment").getFact();
                Waste[] wastes = env.getWastes();
                Waste nearest = null;
                double dist = 0.0;
                for (int i = 0; i < wastes.length; ++i) {
                    if (nearest != null && !(wastes[i].getLocation().getDistance(mouseloc) < dist)) continue;
                    nearest = wastes[i];
                    dist = wastes[i].getLocation().getDistance(mouseloc);
                }
                Waste waste = null;
                if (dist < tol) {
                    waste = nearest;
                }
                if (waste != null) {
                    env.removeWaste(waste);
                } else {
                    env.addWaste(new Waste(mouseloc));
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Environment en = (Environment)agent.getBeliefbase().getBelief("environment").getFact();
                Cleaner[] cleaners = en.getCleaners();
                for (int i = 0; i < cleaners.length; ++i) {
                    try {
                        IGoal kill = agent.createGoal("ams_destroy_agent");
                        kill.getParameter("agentidentifier").setValue((Object)new AgentIdentifier(cleaners[i].getName(), true));
                        agent.dispatchTopLevelGoalAndWait(kill);
                        continue;
                    }
                    catch (GoalFailureException gfe) {
                        // empty catch block
                    }
                }
                agent.killAgent();
            }
        });
        this.getContentPane().add("South", options);
        this.getContentPane().add("Center", map);
        this.setSize(600, 600);
        this.setLocation(SGUI.calculateMiddlePosition((Window)this));
        this.setVisible(true);
        agent.addAgentListener(new IAgentListener(){

            public void agentTerminating(AgentEvent ae) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        8.access$000(this.this$1).dispose();
                    }
                });
            }

            static /* synthetic */ EnvironmentGui access$000(8 x0) {
                return x0.EnvironmentGui.this;
            }
        }, false);
        Timer timer = new Timer(50, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                map.invalidate();
                map.repaint();
            }
        });
        timer.start();
    }

    protected Point onScreenLocation(Location loc, Rectangle bounds) {
        return new Point((int)((double)bounds.width * loc.getX()), (int)((double)bounds.height * (1.0 - loc.getY())));
    }

    protected void render(Graphics g, Component comp, Point p) {
        Dimension d = comp.getPreferredSize();
        Rectangle bounds = new Rectangle(p.x - d.width / 2, p.y - d.height / 2, d.width + 1, d.height);
        comp.setBounds(bounds);
        g.translate(bounds.x, bounds.y);
        comp.paint(g);
        g.translate(-bounds.x, -bounds.y);
    }
}

