/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.cleanerworld.multi.cleanermobile;

import jadex.examples.cleanerworld.multi.Chargingstation;
import jadex.examples.cleanerworld.multi.Cleaner;
import jadex.examples.cleanerworld.multi.Location;
import jadex.examples.cleanerworld.multi.Vision;
import jadex.examples.cleanerworld.multi.Waste;
import jadex.examples.cleanerworld.multi.Wastebin;
import jadex.runtime.IBeliefSet;
import jadex.runtime.IEvent;
import jadex.runtime.IGoal;
import jadex.runtime.IGoalEvent;
import jadex.runtime.IInternalEvent;
import jadex.runtime.MobilePlan;
import jadex.util.SUtil;
import java.util.List;

public class MoveToLocationPlan
extends MobilePlan {
    public MoveToLocationPlan() {
        this.getLogger().info("Created: " + (Object)((Object)this));
    }

    public void action(IEvent event) {
        if (event instanceof IGoalEvent && !((IGoalEvent)event).isInfo() || event instanceof IInternalEvent && event.getType().equals("InternalEvent_timeout")) {
            Location target = (Location)this.getParameter("location").getValue();
            Location myloc = (Location)this.getBeliefbase().getBelief("my_location").getFact();
            if (!myloc.isNear(target)) {
                double speed = (Double)this.getBeliefbase().getBelief("my_speed").getFact();
                double d = myloc.getDistance(target);
                double r = speed * 4.0E-5 * 100.0;
                double dx = target.getX() - myloc.getX();
                double dy = target.getY() - myloc.getY();
                double rx = r < d ? r * dx / d : dx;
                double ry = r < d ? r * dy / d : dy;
                this.getBeliefbase().getBelief("my_location").setFact((Object)new Location(myloc.getX() + rx, myloc.getY() + ry));
                double charge = (Double)this.getBeliefbase().getBelief("my_chargestate").getFact();
                this.getBeliefbase().getBelief("my_chargestate").setFact((Object)new Double(charge -= r * 0.075));
                Cleaner cl = new Cleaner((Location)this.getBeliefbase().getBelief("my_location").getFact(), this.getAgentName(), (Waste)this.getBeliefbase().getBelief("carriedwaste").getFact(), ((Number)this.getBeliefbase().getBelief("my_vision").getFact()).doubleValue(), ((Number)this.getBeliefbase().getBelief("my_chargestate").getFact()).doubleValue());
                IGoal dg = this.createGoal("get_vision_action");
                this.dispatchSubgoalAndWait(dg);
            }
        } else {
            Vision vi = (Vision)((IGoalEvent)event).getGoal().getParameter("vision").getValue();
            this.updateVision(vi);
            this.waitFor(100L);
        }
    }

    protected void updateVision(Vision vi) {
        if (vi != null) {
            IBeliefSet bs;
            int i;
            Cleaner cl = new Cleaner((Location)this.getBeliefbase().getBelief("my_location").getFact(), this.getAgentName(), (Waste)this.getBeliefbase().getBelief("carriedwaste").getFact(), ((Number)this.getBeliefbase().getBelief("my_vision").getFact()).doubleValue(), ((Number)this.getBeliefbase().getBelief("my_chargestate").getFact()).doubleValue());
            this.getBeliefbase().getBelief("daytime").setFact((Object)new Boolean(vi.isDaytime()));
            Waste[] ws = vi.getWastes();
            Wastebin[] wbs = vi.getWastebins();
            Chargingstation[] cs = vi.getStations();
            Cleaner[] cls = vi.getCleaners();
            List known = (List)this.getExpression("query_in_vision_objects").execute();
            for (i = 0; i < known.size(); ++i) {
                List tmp;
                Object object = known.get(i);
                if (object instanceof Waste) {
                    tmp = SUtil.arrayToList((Object)ws);
                    if (tmp.contains(object)) continue;
                    this.getBeliefbase().getBeliefSet("wastes").removeFact(object);
                    continue;
                }
                if (object instanceof Wastebin) {
                    tmp = SUtil.arrayToList((Object)wbs);
                    if (tmp.contains(object)) continue;
                    this.getBeliefbase().getBeliefSet("wastebins").removeFact(object);
                    continue;
                }
                if (object instanceof Chargingstation) {
                    tmp = SUtil.arrayToList((Object)cs);
                    if (tmp.contains(object)) continue;
                    this.getBeliefbase().getBeliefSet("chargingstations").removeFact(object);
                    continue;
                }
                if (!(object instanceof Cleaner) || (tmp = SUtil.arrayToList((Object)cls)).contains(object)) continue;
                this.getBeliefbase().getBeliefSet("cleaners").removeFact(object);
            }
            for (i = 0; i < ws.length; ++i) {
                if (this.getBeliefbase().getBeliefSet("wastes").containsFact((Object)ws[i])) continue;
                this.getBeliefbase().getBeliefSet("wastes").addFact((Object)ws[i]);
            }
            for (i = 0; i < wbs.length; ++i) {
                Waste[] wastes = wbs[i].getWastes();
                for (int j = 0; j < wastes.length; ++j) {
                    if (!this.getBeliefbase().getBeliefSet("wastes").containsFact((Object)wastes[j])) continue;
                    this.getBeliefbase().getBeliefSet("wastes").removeFact((Object)wastes[j]);
                }
                IBeliefSet bs2 = this.getBeliefbase().getBeliefSet("wastebins");
                if (bs2.containsFact((Object)wbs[i])) {
                    bs2.updateFact((Object)wbs[i]);
                    continue;
                }
                bs2.addFact((Object)wbs[i]);
            }
            for (i = 0; i < cs.length; ++i) {
                if (cs[i].getName() == null) {
                    throw new RuntimeException("xxx " + cs[i]);
                }
                bs = this.getBeliefbase().getBeliefSet("chargingstations");
                if (bs.containsFact((Object)cs[i])) {
                    bs.updateFact((Object)cs[i]);
                    continue;
                }
                bs.addFact((Object)cs[i]);
            }
            for (i = 0; i < cls.length; ++i) {
                if (cls[i].equals(cl)) continue;
                bs = this.getBeliefbase().getBeliefSet("cleaners");
                if (bs.containsFact((Object)cls[i])) {
                    bs.updateFact((Object)cls[i]);
                    continue;
                }
                bs.addFact((Object)cls[i]);
            }
        } else {
            System.out.println(this.getAgentName() + " Error when updating vision! ");
        }
    }
}

