/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.cleanerworld.multi.cleaner;

import jadex.examples.cleanerworld.multi.Location;
import jadex.examples.cleanerworld.multi.Waste;
import jadex.examples.cleanerworld.multi.Wastebin;
import jadex.runtime.IBeliefSet;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;
import jadex.runtime.PlanFailureException;

public class DropWastePlan
extends Plan {
    public DropWastePlan() {
        this.getLogger().info("Created: " + (Object)((Object)this));
    }

    public void body() {
        Waste waste = (Waste)this.getBeliefbase().getBelief("carriedwaste").getFact();
        Wastebin wastebin = (Wastebin)this.getParameter("wastebin").getValue();
        if (wastebin == null) {
            throw new PlanFailureException();
        }
        Location location = wastebin.getLocation();
        IGoal moveto = this.createGoal("achievemoveto");
        moveto.getParameter("location").setValue((Object)location);
        this.dispatchSubgoalAndWait(moveto);
        IGoal dg = this.createGoal("drop_waste_action");
        dg.getParameter("waste").setValue((Object)waste);
        dg.getParameter("wastebin").setValue((Object)wastebin);
        this.dispatchSubgoalAndWait(dg);
        this.getLogger().info("Dropping waste to wastebin!");
        wastebin.addWaste(waste);
        this.startAtomic();
        IBeliefSet wbs = this.getBeliefbase().getBeliefSet("wastebins");
        if (wbs.containsFact((Object)wastebin)) {
            wbs.updateFact((Object)wastebin);
        } else {
            wbs.addFact((Object)wastebin);
        }
        this.getBeliefbase().getBelief("carriedwaste").setFact(null);
        this.endAtomic();
    }
}

