/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.cleanerworld.multi.cleaner;

import jadex.examples.cleanerworld.multi.Chargingstation;
import jadex.examples.cleanerworld.multi.Cleaner;
import jadex.examples.cleanerworld.multi.Location;
import jadex.examples.cleanerworld.multi.MapPoint;
import jadex.examples.cleanerworld.multi.Waste;
import jadex.examples.cleanerworld.multi.Wastebin;
import jadex.runtime.AgentDeathException;
import jadex.runtime.AgentEvent;
import jadex.runtime.IAgentListener;
import jadex.runtime.IExpression;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoal;
import jadex.util.SGUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class CleanerGui
extends JFrame {
    static final /* synthetic */ boolean $assertionsDisabled;

    public CleanerGui(final IExternalAccess agent) {
        super(agent.getAgentName());
        final JPanel map = new JPanel(){
            IExpression query_max_quantity;

            protected void paintComponent(Graphics g) {
                try {
                    int y;
                    int h;
                    Point p;
                    int i;
                    boolean daytime = (Boolean)agent.getBeliefbase().getBelief("daytime").getFact();
                    Rectangle bounds = this.getBounds();
                    g.setColor(daytime ? Color.lightGray : Color.darkGray);
                    g.fillRect(0, 0, bounds.width, bounds.height);
                    MapPoint[] mps = (MapPoint[])agent.getBeliefbase().getBeliefSet("visited_positions").getFacts();
                    if (this.query_max_quantity == null) {
                        this.query_max_quantity = agent.getExpressionbase().getExpression("query_max_quantity");
                    }
                    double max = ((MapPoint)this.query_max_quantity.execute()).getQuantity();
                    int xcnt = ((Integer[])agent.getBeliefbase().getBeliefSet("raster").getFacts())[0];
                    int ycnt = ((Integer[])agent.getBeliefbase().getBeliefSet("raster").getFacts())[1];
                    double cellh = 1.0 / (double)ycnt;
                    double cellw = 1.0 / (double)xcnt;
                    for (i = 0; i < mps.length; ++i) {
                        p = CleanerGui.this.onScreenLocation(mps[i].getLocation(), bounds);
                        h = 1;
                        if (max > 0.0) {
                            h = (int)((double)mps[i].getQuantity() * cellh / max * (double)bounds.height);
                        }
                        y = (int)((double)p.y + cellh / 2.0 * (double)bounds.height - (double)h);
                        g.setColor(new Color(54, 10, 114));
                        g.fillRect(p.x + (int)(cellw * 0.3 * (double)bounds.width), y, Math.max(1, (int)(cellw / 10.0 * (double)bounds.width)), h);
                    }
                    for (i = 0; i < mps.length; ++i) {
                        p = CleanerGui.this.onScreenLocation(mps[i].getLocation(), bounds);
                        h = (int)(mps[i].getSeen() * cellh * (double)bounds.height);
                        y = (int)((double)p.y + cellw / 2.0 * (double)bounds.height - (double)h);
                        g.setColor(new Color(10, 150, 150));
                        g.fillRect(p.x + (int)(cellw * 0.4 * (double)bounds.width), y, Math.max(1, (int)(cellw / 10.0 * (double)bounds.width)), h);
                    }
                    Cleaner[] cleaners = (Cleaner[])agent.getBeliefbase().getBeliefSet("cleaners").getFacts();
                    for (int i2 = 0; i2 < cleaners.length; ++i2) {
                        Point p2 = CleanerGui.this.onScreenLocation(cleaners[i2].getLocation(), bounds);
                        int w = (int)(cleaners[i2].getVisionRange() * (double)bounds.width);
                        int h2 = (int)(cleaners[i2].getVisionRange() * (double)bounds.height);
                        g.setColor(new Color(100, 100, 100));
                        g.fillOval(p2.x - w, p2.y - h2, w * 2, h2 * 2);
                        g.setColor(new Color(50, 50, 50, 180));
                        g.fillOval(p2.x - 3, p2.y - 3, 7, 7);
                        g.drawString(cleaners[i2].getName(), p2.x + 5, p2.y - 5);
                        g.drawString("battery: " + (int)(cleaners[i2].getChargestate() * 100.0) + "%", p2.x + 5, p2.y + 5);
                        g.drawString("waste: " + (cleaners[i2].getCarriedWaste() != null ? "yes" : "no"), p2.x + 5, p2.y + 15);
                    }
                    Location agentloc = (Location)agent.getBeliefbase().getBelief("my_location").getFact();
                    double vision = (Double)agent.getBeliefbase().getBelief("my_vision").getFact();
                    double charge = (Double)agent.getBeliefbase().getBelief("my_chargestate").getFact();
                    boolean waste = agent.getBeliefbase().getBelief("carriedwaste").getFact() != null;
                    Point p3 = CleanerGui.this.onScreenLocation(agentloc, bounds);
                    int w = (int)(vision * (double)bounds.width);
                    int h3 = (int)(vision * (double)bounds.height);
                    g.setColor(new Color(255, 255, 64, 180));
                    g.fillOval(p3.x - w, p3.y - h3, w * 2, h3 * 2);
                    g.setColor(Color.black);
                    g.fillOval(p3.x - 3, p3.y - 3, 7, 7);
                    g.drawString(agent.getAgentName(), p3.x + 5, p3.y - 5);
                    g.drawString("battery: " + (int)(charge * 100.0) + "%", p3.x + 5, p3.y + 5);
                    g.drawString("waste: " + (waste ? "yes" : "no"), p3.x + 5, p3.y + 15);
                    Chargingstation[] stations = (Chargingstation[])agent.getBeliefbase().getBeliefSet("chargingstations").getFacts();
                    for (int i3 = 0; i3 < stations.length; ++i3) {
                        g.setColor(Color.blue);
                        p3 = CleanerGui.this.onScreenLocation(stations[i3].getLocation(), bounds);
                        g.drawRect(p3.x - 10, p3.y - 10, 20, 20);
                        g.setColor(daytime ? Color.black : Color.white);
                        g.drawString(stations[i3].getName(), p3.x + 14, p3.y + 5);
                    }
                    Wastebin[] wastebins = (Wastebin[])agent.getBeliefbase().getBeliefSet("wastebins").getFacts();
                    for (int i4 = 0; i4 < wastebins.length; ++i4) {
                        g.setColor(Color.red);
                        p3 = CleanerGui.this.onScreenLocation(wastebins[i4].getLocation(), bounds);
                        g.drawOval(p3.x - 10, p3.y - 10, 20, 20);
                        g.setColor(daytime ? Color.black : Color.white);
                        g.drawString(wastebins[i4].getName() + " (" + wastebins[i4].getWastes().length + "/" + wastebins[i4].getCapacity() + ")", p3.x + 14, p3.y + 5);
                    }
                    Waste[] wastes = (Waste[])agent.getBeliefbase().getBeliefSet("wastes").getFacts();
                    for (int i5 = 0; i5 < wastes.length; ++i5) {
                        g.setColor(Color.red);
                        p3 = CleanerGui.this.onScreenLocation(wastes[i5].getLocation(), bounds);
                        g.fillOval(p3.x - 3, p3.y - 3, 7, 7);
                    }
                    IGoal[] targets = agent.getGoalbase().getGoals("achievemoveto");
                    for (int i6 = 0; i6 < targets.length; ++i6) {
                        g.setColor(Color.black);
                        p3 = CleanerGui.this.onScreenLocation((Location)targets[i6].getParameter("location").getValue(), bounds);
                        g.drawOval(p3.x - 5, p3.y - 5, 10, 10);
                        g.drawLine(p3.x - 7, p3.y, p3.x + 7, p3.y);
                        g.drawLine(p3.x, p3.y - 7, p3.x, p3.y + 7);
                    }
                }
                catch (AgentDeathException agentDeathException) {
                    // empty catch block
                }
            }
        };
        this.getContentPane().add("Center", map);
        this.setSize(300, 300);
        this.setLocation(SGUI.calculateMiddlePosition((Window)this));
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                agent.killAgent();
            }
        });
        agent.addAgentListener(new IAgentListener(){

            public void agentTerminating(AgentEvent ae) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        3.access$000(this.this$1).dispose();
                    }
                });
            }

            static /* synthetic */ CleanerGui access$000(3 x0) {
                return x0.CleanerGui.this;
            }
        }, false);
        Timer timer = new Timer(50, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                map.invalidate();
                map.repaint();
            }
        });
        timer.start();
    }

    protected Point onScreenLocation(Location loc, Rectangle bounds) {
        if (!$assertionsDisabled && loc == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bounds == null) {
            throw new AssertionError();
        }
        return new Point((int)((double)bounds.width * loc.getX()), (int)((double)bounds.height * (1.0 - loc.getY())));
    }

    static {
        $assertionsDisabled = !CleanerGui.class.desiredAssertionStatus();
    }
}

