/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.cleanerworld.multi;

import jadex.examples.cleanerworld.multi.Location;
import jadex.examples.cleanerworld.multi.LocationObject;
import jadex.util.SReflect;

public class MapPoint
extends LocationObject {
    protected int quantity;
    protected double seen;

    public MapPoint(Location location, int quantity, double seen) {
        super(location.toString(), location);
        this.quantity = quantity;
        this.seen = seen;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public double getSeen() {
        return this.seen;
    }

    public void setSeen(double seen) {
        this.seen = seen;
    }

    public String toString() {
        return SReflect.getInnerClassName(this.getClass()) + " loc: " + this.location + " quantity:" + this.quantity + " seen: " + this.seen;
    }

    public static MapPoint[] getMapPointRaster(int numx, int numy, double width, double height) {
        double xwidth = width / (double)numx;
        double xstart = xwidth / 2.0;
        double ywidth = height / (double)numy;
        double ystart = ywidth / 2.0;
        MapPoint[] raster = new MapPoint[numx * numy];
        double yval = ystart;
        for (int y = 0; y < numy; ++y) {
            double xval = xstart;
            for (int x = 0; x < numx; ++x) {
                raster[y * numx + x] = new MapPoint(new Location(xval, yval), 0, 0.0);
                xval += xwidth;
            }
            yval += ywidth;
        }
        return raster;
    }
}

