/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.cleanerworld.multi;

import jadex.examples.cleanerworld.multi.LocationData;

public class Location
extends LocationData
implements Cloneable {
    public static final double DEFAULT_TOLERANCE = 0.001;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Location() {
    }

    public Location(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public double getDistance(Location other) {
        if (!$assertionsDisabled && other == null) {
            throw new AssertionError();
        }
        return Math.sqrt((other.y - this.y) * (other.y - this.y) + (other.x - this.x) * (other.x - this.x));
    }

    public boolean isNear(Location other) {
        return this.isNear(other, 0.001);
    }

    public boolean isNear(Location other, double tolerance) {
        return this.getDistance(other) <= tolerance;
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof Location) {
            Location loc = (Location)o;
            if (loc.x == this.x && loc.y == this.y) {
                ret = true;
            }
        }
        return ret;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException("Clone not supported");
        }
    }

    static {
        $assertionsDisabled = !Location.class.desiredAssertionStatus();
    }
}

