/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.cleanerworld.multi;

import jadex.examples.cleanerworld.multi.Chargingstation;
import jadex.examples.cleanerworld.multi.Cleaner;
import jadex.examples.cleanerworld.multi.IEnvironment;
import jadex.examples.cleanerworld.multi.Location;
import jadex.examples.cleanerworld.multi.LocationObject;
import jadex.examples.cleanerworld.multi.Vision;
import jadex.examples.cleanerworld.multi.Waste;
import jadex.examples.cleanerworld.multi.Wastebin;
import jadex.util.SimplePropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Environment
implements IEnvironment {
    protected static Environment instance;
    protected boolean daytime = true;
    protected List cleaners = new ArrayList();
    protected List wastes = new ArrayList();
    protected List wastebins = new ArrayList();
    protected List stations = new ArrayList();
    protected Map ages = new HashMap();
    public SimplePropertyChangeSupport pcs = new SimplePropertyChangeSupport((Object)this);

    public Environment() {
        this.addWaste(new Waste(new Location(0.1, 0.5)));
        this.addWaste(new Waste(new Location(0.2, 0.5)));
        this.addWaste(new Waste(new Location(0.3, 0.5)));
        this.addWaste(new Waste(new Location(0.9, 0.9)));
        this.addWastebin(new Wastebin(new Location(0.2, 0.2), 20));
        this.addWastebin(new Wastebin(new Location(0.8, 0.1), 20));
        this.addChargingStation(new Chargingstation(new Location(0.8, 0.8)));
        this.addChargingStation(new Chargingstation(new Location(0.2, 0.4)));
    }

    public static Environment getInstance() {
        if (instance == null) {
            instance = new Environment();
        }
        return instance;
    }

    public Vision getVision(Cleaner cleaner) {
        if (this.cleaners.contains(cleaner)) {
            this.cleaners.remove(cleaner);
        }
        this.cleaners.add(cleaner);
        this.ages.put(cleaner, new Integer(0));
        Location cloc = cleaner.getLocation();
        double range = cleaner.getVisionRange();
        ArrayList<Object> nearwastes = new ArrayList<Object>();
        for (int i = 0; i < this.wastes.size(); ++i) {
            LocationObject obj = (LocationObject)this.wastes.get(i);
            if (!obj.getLocation().isNear(cloc, range)) continue;
            nearwastes.add(obj.clone());
        }
        ArrayList<Object> nearwastebins = new ArrayList<Object>();
        for (int i = 0; i < this.wastebins.size(); ++i) {
            LocationObject obj = (LocationObject)this.wastebins.get(i);
            if (!obj.getLocation().isNear(cloc, range)) continue;
            nearwastebins.add(obj.clone());
        }
        ArrayList<Object> nearstations = new ArrayList<Object>();
        for (int i = 0; i < this.stations.size(); ++i) {
            LocationObject obj = (LocationObject)this.stations.get(i);
            if (!obj.getLocation().isNear(cloc, range)) continue;
            nearstations.add(obj.clone());
        }
        ArrayList<Object> nearcleaners = new ArrayList<Object>();
        for (int i = 0; i < this.cleaners.size(); ++i) {
            LocationObject obj = (LocationObject)this.cleaners.get(i);
            if (!obj.getLocation().isNear(cloc, range)) continue;
            nearcleaners.add(obj.clone());
        }
        Vision v = new Vision(nearwastes, nearwastebins, nearstations, nearcleaners, this.getDaytime());
        return v;
    }

    public boolean pickUpWaste(Waste waste) {
        boolean ret = this.wastes.remove(waste);
        return ret;
    }

    public boolean dropWasteInWastebin(Waste waste, Wastebin wastebin) {
        boolean ret = false;
        if (!(wastebin = this.getWastebin(wastebin)).contains(waste) && !wastebin.isFull()) {
            wastebin.addWaste((Waste)waste.clone());
            ret = true;
        }
        return ret;
    }

    protected Wastebin getWastebin(Wastebin wb) {
        Wastebin ret = null;
        for (int i = 0; i < this.wastebins.size() && ret == null; ++i) {
            if (!wb.equals(this.wastebins.get(i))) continue;
            ret = (Wastebin)this.wastebins.get(i);
        }
        return ret;
    }

    public Vision getCompleteVision() {
        return new Vision(this.wastes, this.wastebins, this.stations, this.cleaners, this.getDaytime());
    }

    public boolean getDaytime() {
        return this.daytime;
    }

    public void setDaytime(boolean daytime) {
        this.daytime = daytime;
        this.pcs.firePropertyChange("daytime", null, (Object)new Boolean(daytime));
    }

    public void addCleaner(Cleaner cleaner) {
        this.cleaners.add(cleaner);
        this.pcs.firePropertyChange("cleaners", null, (Object)cleaner);
    }

    public void removeCleaner(Cleaner cleaner) {
        this.cleaners.remove(cleaner);
        this.pcs.firePropertyChange("cleaners", null, (Object)cleaner);
    }

    public void addWaste(Waste waste) {
        this.wastes.add(waste);
        this.pcs.firePropertyChange("wastes", null, (Object)waste);
    }

    public void removeWaste(Waste waste) {
        this.wastes.remove(waste);
        this.pcs.firePropertyChange("wastes", (Object)waste, null);
    }

    public void addWastebin(Wastebin wastebin) {
        this.wastebins.add(wastebin);
        this.pcs.firePropertyChange("wastebins", null, (Object)wastebin);
    }

    public void addChargingStation(Chargingstation station) {
        this.stations.add(station);
        this.pcs.firePropertyChange("chargingstations", null, (Object)station);
    }

    public Waste[] getWastes() {
        return this.wastes.toArray(new Waste[this.wastes.size()]);
    }

    public Wastebin[] getWastebins() {
        return this.wastebins.toArray(new Wastebin[this.wastebins.size()]);
    }

    public Chargingstation[] getChargingstations() {
        return this.stations.toArray(new Chargingstation[this.stations.size()]);
    }

    public Cleaner[] getCleaners() {
        Cleaner[] cls = this.cleaners.toArray(new Cleaner[this.cleaners.size()]);
        for (int i = 0; i < cls.length; ++i) {
            if (!this.ages.containsKey(cls[i])) {
                this.ages.put(cls[i], new Integer(0));
                continue;
            }
            int age = (Integer)this.ages.get(cls[i]);
            if (age > 100) {
                this.removeCleaner(cls[i]);
                this.ages.remove(cls[i]);
                continue;
            }
            this.ages.put(cls[i], new Integer(age + 1));
        }
        return this.cleaners.toArray(new Cleaner[this.cleaners.size()]);
    }

    public Wastebin getWastebin(String name) {
        Wastebin ret = null;
        for (int i = 0; i < this.wastebins.size() && ret == null; ++i) {
            if (!((Wastebin)this.wastebins.get(i)).getName().equals(name)) continue;
            ret = (Wastebin)this.wastebins.get(i);
        }
        return ret;
    }

    public void clear() {
        this.cleaners.clear();
        this.wastes.clear();
        this.wastebins.clear();
        this.stations.clear();
        this.daytime = true;
    }

    public int getAge(Cleaner cleaner) {
        int ret = 0;
        Integer age = (Integer)this.ages.get(cleaner);
        if (age != null) {
            ret = age;
        }
        return ret;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

