/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.booktrading.seller;

import jadex.examples.booktrading.common.NegotiationReport;
import jadex.examples.booktrading.common.Order;
import jadex.runtime.Plan;

public class MakeProposalPlan
extends Plan {
    public void body() {
        Order[] suitableorders = (Order[])this.getParameterSet("suitableorders").getValues();
        if (suitableorders.length > 0) {
            Order order = suitableorders[0];
            double time_span = order.getDeadline().getTime() - order.getStartTime();
            double elapsed_time = System.currentTimeMillis() - order.getStartTime();
            double price_span = order.getLimit() - order.getStartPrice();
            int acceptable_price = (int)(price_span * elapsed_time / time_span) + order.getStartPrice();
            this.getLogger().info(this.getAgentName() + " proposed: " + acceptable_price);
            this.getParameter("proposal").setValue((Object)new Integer(acceptable_price));
            this.getParameter("proposal_info").setValue((Object)order);
            String report = "Made proposal: " + acceptable_price;
            NegotiationReport nr = new NegotiationReport(order, report, System.currentTimeMillis());
            this.getBeliefbase().getBeliefSet("negotiation_reports").addFact((Object)nr);
        }
    }
}

