/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.booktrading.common;

import jadex.util.SimplePropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.Date;

public class Order {
    public static final String OPEN = "open";
    public static final String DONE = "done";
    public static final String FAILED = "failed";
    protected String title;
    protected Date deadline;
    protected int limit;
    protected int startprice;
    protected long starttime;
    protected Integer exeprice;
    protected Date exedate;
    protected boolean buyorder;
    public SimplePropertyChangeSupport pcs;

    public Order(String title, Date deadline, int start, int limit, boolean buyorder) {
        this.title = title;
        this.deadline = deadline;
        this.startprice = start;
        this.limit = limit;
        this.buyorder = buyorder;
        this.starttime = System.currentTimeMillis();
        this.pcs = new SimplePropertyChangeSupport((Object)this);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldtitle = this.title;
        this.title = title;
        this.pcs.firePropertyChange("title", (Object)oldtitle, (Object)title);
    }

    public Date getDeadline() {
        return this.deadline;
    }

    public void setDeadline(Date deadline) {
        Date olddeadline = this.deadline;
        this.deadline = deadline;
        this.pcs.firePropertyChange("deadline", (Object)olddeadline, (Object)deadline);
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        int oldlimit = this.limit;
        this.limit = limit;
        this.pcs.firePropertyChange("limit", oldlimit, limit);
    }

    public int getStartPrice() {
        return this.startprice;
    }

    public void setStartPrice(int startprice) {
        int oldstartprice = this.startprice;
        this.startprice = startprice;
        this.pcs.firePropertyChange("startPrice", oldstartprice, startprice);
    }

    public long getStartTime() {
        return this.starttime;
    }

    public void setStartTime(long starttime) {
        long oldstarttime = this.starttime;
        this.starttime = starttime;
        this.pcs.firePropertyChange("startTime", (Object)new Long(oldstarttime), (Object)new Long(starttime));
    }

    public Integer getExecutionPrice() {
        return this.exeprice;
    }

    public void setExecutionPrice(Integer exeprice) {
        Integer oldexeprice = this.exeprice;
        this.exeprice = exeprice;
        this.pcs.firePropertyChange("executionPrice", (Object)oldexeprice, (Object)exeprice);
    }

    public Date getExecutionDate() {
        return this.exedate;
    }

    public void setExecutionDate(Date exedate) {
        Date oldexedate = this.exedate;
        this.exedate = exedate;
        this.pcs.firePropertyChange("executionDate", (Object)oldexedate, (Object)exedate);
    }

    public boolean isBuyOrder() {
        return this.buyorder;
    }

    public void setBuyOrder(boolean buyorder) {
        boolean oldbuyorder = this.buyorder;
        this.buyorder = buyorder;
        this.pcs.firePropertyChange("buyOrder", (Object)(oldbuyorder ? Boolean.TRUE : Boolean.FALSE), (Object)(buyorder ? Boolean.TRUE : Boolean.FALSE));
    }

    public String getState() {
        String state = FAILED;
        if (this.exedate != null) {
            state = DONE;
        } else if (System.currentTimeMillis() < this.deadline.getTime()) {
            state = OPEN;
        }
        return state;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.isBuyOrder() ? "Buy '" : "Sell '");
        sbuf.append(this.getTitle());
        sbuf.append("'");
        return sbuf.toString();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

