/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.booktrading.common;

import jadex.examples.booktrading.common.Order;
import jadex.runtime.AgentEvent;
import jadex.runtime.IAgentListener;
import jadex.runtime.IBeliefSetListener;
import jadex.runtime.IExpression;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoal;
import jadex.util.SGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class Gui
extends JFrame {
    private String itemlabel;
    private String goalname;
    private String addorderlabel;
    private IExternalAccess agent;
    private List orders = new ArrayList();
    private JTable table;
    private DefaultTableModel detailsdm;
    private AbstractTableModel items = new AbstractTableModel(){

        public int getRowCount() {
            return Gui.this.orders.size();
        }

        public int getColumnCount() {
            return 7;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Title";
                }
                case 1: {
                    return "Start Price";
                }
                case 2: {
                    return "Limit";
                }
                case 3: {
                    return "Deadline";
                }
                case 4: {
                    return "Execution Price";
                }
                case 5: {
                    return "Execution Date";
                }
                case 6: {
                    return "State";
                }
            }
            return "";
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Object getValueAt(int row, int column) {
            Object value = null;
            Order order = (Order)Gui.this.orders.get(row);
            if (column == 0) {
                value = order.getTitle();
            } else if (column == 1) {
                value = new Integer(order.getStartPrice());
            } else if (column == 2) {
                value = new Integer(order.getLimit());
            } else if (column == 3) {
                value = order.getDeadline();
            } else if (column == 4) {
                value = order.getExecutionPrice();
            } else if (column == 5) {
                value = order.getExecutionDate();
            } else if (column == 6) {
                value = order.getState();
            }
            return value;
        }
    };
    private DateFormat dformat = new SimpleDateFormat("yyyy/MM/dd HH:mm");

    public Gui(final IExternalAccess agent, final boolean buy) {
        super((buy ? "Buyer: " : "Seller: ") + agent.getAgentIdentifier().getName());
        this.agent = agent;
        if (buy) {
            this.itemlabel = " Books to buy ";
            this.goalname = "purchase_book";
            this.addorderlabel = "Add new purchase order";
        } else {
            this.itemlabel = " Books to sell ";
            this.goalname = "sell_book";
            this.addorderlabel = "Add new sell order";
        }
        JPanel itempanel = new JPanel(new BorderLayout());
        itempanel.setBorder(new TitledBorder(new EtchedBorder(), this.itemlabel));
        this.table = new JTable(this.items);
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, selected, focus, row, column);
                this.setOpaque(true);
                if (column == 0) {
                    this.setHorizontalAlignment(2);
                } else {
                    this.setHorizontalAlignment(4);
                }
                if (!selected) {
                    Object state = Gui.this.items.getValueAt(row, 6);
                    if ("done".equals(state)) {
                        comp.setBackground(new Color(211, 255, 156));
                    } else if ("failed".equals(state)) {
                        comp.setBackground(new Color(255, 211, 156));
                    } else {
                        comp.setBackground(table.getBackground());
                    }
                }
                if (value instanceof Date) {
                    this.setValue(Gui.this.dformat.format(value));
                }
                return comp;
            }
        });
        this.table.setPreferredScrollableViewportSize(new Dimension(600, 120));
        JScrollPane scroll = new JScrollPane(this.table);
        itempanel.add("Center", scroll);
        this.detailsdm = new DefaultTableModel(new String[]{"Negotiation Details"}, 0);
        JTable details = new JTable(this.detailsdm);
        details.setPreferredScrollableViewportSize(new Dimension(600, 120));
        JPanel dep = new JPanel(new BorderLayout());
        dep.add("Center", new JScrollPane(details));
        JPanel south = new JPanel();
        JButton add = new JButton("Add");
        final JButton remove = new JButton("Remove");
        final JButton edit = new JButton("Edit");
        add.setMinimumSize(remove.getMinimumSize());
        add.setPreferredSize(remove.getPreferredSize());
        edit.setMinimumSize(remove.getMinimumSize());
        edit.setPreferredSize(remove.getPreferredSize());
        south.add(add);
        south.add(remove);
        south.add(edit);
        remove.setEnabled(false);
        edit.setEnabled(false);
        JSplitPane splitter = new JSplitPane(0);
        splitter.add(itempanel);
        splitter.add(dep);
        splitter.setOneTouchExpandable(true);
        this.getContentPane().add("Center", splitter);
        this.getContentPane().add("South", south);
        agent.getBeliefbase().getBeliefSet("orders").addBeliefSetListener(new IBeliefSetListener(){

            public void beliefSetChanged(AgentEvent ae) {
                Gui.this.refresh();
            }

            public void factAdded(AgentEvent ae) {
                Gui.this.refresh();
            }

            public void factRemoved(AgentEvent ae) {
                Gui.this.refresh();
            }
        }, false);
        agent.getBeliefbase().getBeliefSet("negotiation_reports").addBeliefSetListener(new IBeliefSetListener(){

            public void factAdded(AgentEvent ae) {
                Gui.this.refreshDetails();
            }

            public void factRemoved(AgentEvent ae) {
                Gui.this.refreshDetails();
            }

            public void beliefSetChanged(AgentEvent ae) {
            }
        }, false);
        agent.addAgentListener(new IAgentListener(){

            public void agentTerminating(AgentEvent ae) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        5.access$300(this.this$1).setVisible(false);
                    }
                });
            }

            static /* synthetic */ Gui access$300(5 x0) {
                return x0.Gui.this;
            }
        }, false);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Gui.this.refreshDetails();
            }
        });
        final InputDialog dia = new InputDialog(buy);
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                while (dia.requestInput()) {
                    try {
                        String title = dia.title.getText();
                        int limit = Integer.parseInt(dia.limit.getText());
                        int start = Integer.parseInt(dia.start.getText());
                        Date deadline = Gui.this.dformat.parse(dia.deadline.getText());
                        Order order = new Order(title, deadline, start, limit, buy);
                        IGoal purchase = Gui.this.agent.createGoal(Gui.this.goalname);
                        purchase.getParameter("order").setValue((Object)order);
                        Gui.this.agent.dispatchTopLevelGoal(purchase);
                        Gui.this.orders.add(order);
                        Gui.this.items.fireTableDataChanged();
                        break;
                    }
                    catch (NumberFormatException e1) {
                        JOptionPane.showMessageDialog(Gui.this, "Price limit must be integer.", "Input error", 0);
                    }
                    catch (ParseException e1) {
                        JOptionPane.showMessageDialog(Gui.this, "Wrong date format, use YYYY/MM/DD hh:mm.", "Input error", 0);
                    }
                }
            }
        });
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                boolean selected = Gui.this.table.getSelectedRow() >= 0;
                remove.setEnabled(selected);
                edit.setEnabled(selected);
            }
        });
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = Gui.this.table.getSelectedRow();
                if (row >= 0 && row < Gui.this.orders.size()) {
                    Order order = (Order)Gui.this.orders.remove(row);
                    Gui.this.items.fireTableRowsDeleted(row, row);
                    IGoal[] goals = Gui.this.agent.getGoalbase().getGoals(Gui.this.goalname);
                    for (int i = 0; i < goals.length; ++i) {
                        if (!order.equals(goals[i].getParameter("order").getValue())) continue;
                        goals[i].drop();
                        break;
                    }
                }
            }
        });
        final InputDialog edit_dialog = new InputDialog(buy);
        edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = Gui.this.table.getSelectedRow();
                if (row >= 0 && row < Gui.this.orders.size()) {
                    Order order = (Order)Gui.this.orders.get(row);
                    edit_dialog.title.setText(order.getTitle());
                    edit_dialog.limit.setText(Integer.toString(order.getLimit()));
                    edit_dialog.start.setText(Integer.toString(order.getStartPrice()));
                    edit_dialog.deadline.setText(Gui.this.dformat.format(order.getDeadline()));
                    while (edit_dialog.requestInput()) {
                        try {
                            String title = edit_dialog.title.getText();
                            int limit = Integer.parseInt(edit_dialog.limit.getText());
                            int start = Integer.parseInt(edit_dialog.start.getText());
                            Date deadline = Gui.this.dformat.parse(edit_dialog.deadline.getText());
                            order.setTitle(title);
                            order.setLimit(limit);
                            order.setStartPrice(start);
                            order.setDeadline(deadline);
                            Gui.this.items.fireTableDataChanged();
                            IGoal[] goals = Gui.this.agent.getGoalbase().getGoals(Gui.this.goalname);
                            for (int i = 0; i < goals.length; ++i) {
                                if (!order.equals(goals[i].getParameter("order").getValue())) continue;
                                goals[i].drop();
                                break;
                            }
                            IGoal goal = Gui.this.agent.createGoal(Gui.this.goalname);
                            goal.getParameter("order").setValue((Object)order);
                            Gui.this.agent.dispatchTopLevelGoal(goal);
                            break;
                        }
                        catch (NumberFormatException e1) {
                            JOptionPane.showMessageDialog(Gui.this, "Price limit must be integer.", "Input error", 0);
                        }
                        catch (ParseException e1) {
                            JOptionPane.showMessageDialog(Gui.this, "Wrong date format, use YYYY/MM/DD hh:mm.", "Input error", 0);
                        }
                    }
                }
            }
        });
        this.refresh();
        this.pack();
        this.setLocation(SGUI.calculateMiddlePosition((Window)this));
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                agent.killAgent();
            }
        });
    }

    public void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Order[] aorders = (Order[])Gui.this.agent.getBeliefbase().getBeliefSet("orders").getFacts();
                for (int i = 0; i < aorders.length; ++i) {
                    if (Gui.this.orders.contains(aorders[i])) continue;
                    Gui.this.orders.add(aorders[i]);
                }
                Gui.this.items.fireTableDataChanged();
            }
        });
    }

    public void refreshDetails() {
        int sel = this.table.getSelectedRow();
        if (sel != -1) {
            Order order = (Order)this.orders.get(sel);
            IExpression exp = this.agent.getExpressionbase().getExpression("search_reports");
            List res = (List)exp.execute("$order", (Object)order);
            while (this.detailsdm.getRowCount() > 0) {
                this.detailsdm.removeRow(0);
            }
            for (int i = 0; i < res.size(); ++i) {
                this.detailsdm.addRow(new Object[]{res.get(i)});
            }
        }
    }

    private class InputDialog
    extends JDialog {
        private JComboBox orders;
        private JTextField title;
        private JTextField limit;
        private JTextField start;
        private JTextField deadline;
        private boolean aborted;

        InputDialog(boolean buy) {
            super(Gui.this, Gui.this.addorderlabel, true);
            this.orders = new JComboBox();
            this.title = new JTextField(20);
            this.limit = new JTextField(20);
            this.start = new JTextField(20);
            this.deadline = new JTextField(Gui.this.dformat.format(new Date(System.currentTimeMillis() + 300000L)));
            if (buy) {
                this.orders.addItem(new Order("All about agents", new Date(), 100, 120, buy));
                this.orders.addItem(new Order("All about web services", new Date(), 40, 60, buy));
                this.orders.addItem(new Order("Harry Potter", new Date(), 5, 10, buy));
                this.orders.addItem(new Order("Agents in the real world", new Date(), 30, 65, buy));
            } else {
                this.orders.addItem(new Order("All about agents", new Date(), 130, 110, buy));
                this.orders.addItem(new Order("All about web services", new Date(), 50, 30, buy));
                this.orders.addItem(new Order("Harry Potter", new Date(), 15, 9, buy));
                this.orders.addItem(new Order("Agents in the real world", new Date(), 100, 60, buy));
            }
            JPanel center = new JPanel(new GridBagLayout());
            center.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.getContentPane().add("Center", center);
            Dimension labeldim = new JLabel("Preset orders ").getPreferredSize();
            int row = 0;
            GridBagConstraints leftcons = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0);
            GridBagConstraints rightcons = new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0);
            rightcons.gridy = row++;
            leftcons.gridy = rightcons.gridy;
            JLabel label = new JLabel("Preset orders");
            label.setMinimumSize(labeldim);
            label.setPreferredSize(labeldim);
            center.add((Component)label, leftcons);
            center.add((Component)this.orders, rightcons);
            rightcons.gridy = row++;
            leftcons.gridy = rightcons.gridy;
            label = new JLabel("Title");
            label.setMinimumSize(labeldim);
            label.setPreferredSize(labeldim);
            center.add((Component)label, leftcons);
            center.add((Component)this.title, rightcons);
            rightcons.gridy = row++;
            leftcons.gridy = rightcons.gridy;
            label = new JLabel("Start price");
            label.setMinimumSize(labeldim);
            label.setPreferredSize(labeldim);
            center.add((Component)label, leftcons);
            center.add((Component)this.start, rightcons);
            rightcons.gridy = row++;
            leftcons.gridy = rightcons.gridy;
            label = new JLabel("Price limit");
            label.setMinimumSize(labeldim);
            label.setPreferredSize(labeldim);
            center.add((Component)label, leftcons);
            center.add((Component)this.limit, rightcons);
            rightcons.gridy = row++;
            leftcons.gridy = rightcons.gridy;
            label = new JLabel("Deadline");
            label.setMinimumSize(labeldim);
            label.setPreferredSize(labeldim);
            center.add((Component)label, leftcons);
            center.add((Component)this.deadline, rightcons);
            JPanel south = new JPanel();
            this.getContentPane().add("South", south);
            JButton ok = new JButton("Ok");
            JButton cancel = new JButton("Cancel");
            ok.setMinimumSize(cancel.getMinimumSize());
            ok.setPreferredSize(cancel.getPreferredSize());
            south.add(ok);
            south.add(cancel);
            ok.addActionListener(new ActionListener(this){
                private final /* synthetic */ InputDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    InputDialog.access$1202(this.this$1, false);
                    this.this$1.setVisible(false);
                }
            });
            cancel.addActionListener(new ActionListener(this){
                private final /* synthetic */ InputDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.setVisible(false);
                }
            });
            this.orders.addActionListener(new ActionListener(this){
                private final /* synthetic */ InputDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    Order order = (Order)InputDialog.access$1300(this.this$1).getSelectedItem();
                    InputDialog.access$400(this.this$1).setText(order.getTitle());
                    InputDialog.access$500(this.this$1).setText("" + order.getLimit());
                    InputDialog.access$600(this.this$1).setText("" + order.getStartPrice());
                }
            });
        }

        public boolean requestInput() {
            this.deadline.setText(Gui.this.dformat.format(new Date(System.currentTimeMillis() + 300000L)));
            this.aborted = true;
            this.pack();
            this.setLocation(SGUI.calculateMiddlePosition((Window)Gui.this, (Window)this));
            this.setVisible(true);
            return !this.aborted;
        }

        static /* synthetic */ boolean access$1202(InputDialog x0, boolean x1) {
            x0.aborted = x1;
            return x0.aborted;
        }

        static /* synthetic */ JComboBox access$1300(InputDialog x0) {
            return x0.orders;
        }
    }
}

