/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.booktrading.buyer;

import jadex.adapter.fipa.AgentDescription;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.examples.booktrading.common.NegotiationReport;
import jadex.examples.booktrading.common.Order;
import jadex.planlib.NegotiationRecord;
import jadex.planlib.Selector;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;
import java.util.Comparator;
import java.util.Date;

public class PurchaseBookPlan
extends Plan {
    public void body() {
        Order order = (Order)this.getParameter("order").getValue();
        double time_span = order.getDeadline().getTime() - order.getStartTime();
        double elapsed_time = System.currentTimeMillis() - order.getStartTime();
        double price_span = order.getLimit() - order.getStartPrice();
        final int acceptable_price = (int)(price_span * elapsed_time / time_span) + order.getStartPrice();
        IGoal df_search = this.createGoal("df_search");
        df_search.getParameter("description").setValue(this.getPropertybase().getProperty("service_seller"));
        this.dispatchSubgoalAndWait(df_search);
        AgentDescription[] result = (AgentDescription[])df_search.getParameterSet("result").getValues();
        if (result.length == 0) {
            this.fail();
        }
        Object[] sellers = new AgentIdentifier[result.length];
        for (int i = 0; i < result.length; ++i) {
            sellers[i] = result[i].getName();
        }
        IGoal cnp = this.createGoal("cnp_initiate");
        cnp.getParameter("content").setValue((Object)order.getTitle());
        cnp.getParameterSet("receivers").addValues(sellers);
        cnp.getParameter("selector").setValue((Object)new Selector(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Comparable)o2).compareTo(o1);
            }
        }){

            public boolean isAcceptable(Object proposal) {
                return proposal instanceof Integer && (Integer)proposal <= acceptable_price;
            }
        });
        try {
            this.dispatchSubgoalAndWait(cnp);
            NegotiationRecord rec = (NegotiationRecord)cnp.getParameterSet("history").getValues()[0];
            this.generateNegotiationReport(order, rec, acceptable_price);
            order.setExecutionPrice((Integer)cnp.getParameterSet("result").getValues()[0]);
            order.setExecutionDate(new Date());
        }
        catch (GoalFailureException e) {
            NegotiationRecord rec = (NegotiationRecord)cnp.getParameterSet("history").getValues()[0];
            this.generateNegotiationReport(order, rec, acceptable_price);
            this.fail();
        }
    }

    protected void generateNegotiationReport(Order order, NegotiationRecord rec, double acceptable_price) {
        String report = "Accepable price: " + acceptable_price + ", proposals: ";
        Object[] proposals = rec.getProposals();
        for (int i = 0; i < proposals.length; ++i) {
            report = report + proposals[i] + "-" + rec.getAgentIdentifier(proposals[i]).getLocalName();
            if (i + 1 >= proposals.length) continue;
            report = report + ", ";
        }
        NegotiationReport nr = new NegotiationReport(order, report, rec.getStarttime());
        this.getBeliefbase().getBeliefSet("negotiation_reports").addFact((Object)nr);
    }
}

