/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blocksworld;

import jadex.examples.blocksworld.Block;
import jadex.runtime.IFilter;
import jadex.runtime.IGoal;
import jadex.runtime.InternalEventFilter;
import jadex.runtime.Plan;

public class StackBlocksPlan
extends Plan {
    public static final String MODE_NORMAL = "Normal";
    public static final String MODE_SLOW = "Slow";
    public static final String MODE_STEP = "Step";
    protected Block block = (Block)this.getParameter("block").getValue();
    protected Block target = (Block)this.getParameter("target").getValue();
    protected String mode;
    protected boolean quiet;

    public StackBlocksPlan(String mode) {
        this(mode, false);
    }

    public StackBlocksPlan(String mode, boolean quiet) {
        this.mode = mode;
        this.quiet = quiet;
    }

    public void body() {
        IGoal clear = this.createGoal("clear");
        clear.getParameter("block").setValue((Object)this.block);
        this.dispatchSubgoalAndWait(clear);
        clear = this.createGoal("clear");
        clear.getParameter("block").setValue((Object)this.target);
        this.dispatchSubgoalAndWait(clear);
        if (this.mode.equals(MODE_SLOW)) {
            this.waitFor(1000L);
        } else if (this.mode.equals(MODE_STEP)) {
            this.waitFor((IFilter)new InternalEventFilter("step"));
        }
        if (!this.quiet) {
            System.out.println("Moving '" + this.block + "' to '" + this.target + "'");
        }
        this.startAtomic();
        this.block.stackOn(this.target);
        this.endAtomic();
    }
}

