/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blocksworld;

import jadex.examples.blocksworld.Block;
import jadex.examples.blocksworld.Table;
import jadex.runtime.GoalEventFilter;
import jadex.runtime.IFilter;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class EvaluationPlan
extends Plan {
    protected int runs;
    protected int deltagoals;
    protected int maxgoals;

    public EvaluationPlan() {
        this(5, 50, 1000);
    }

    public EvaluationPlan(int runs, int deltagoals, int maxgoals) {
        this.runs = runs;
        this.deltagoals = deltagoals;
        this.maxgoals = maxgoals;
    }

    public void body() {
        try {
            long prev;
            long cur = Long.MAX_VALUE;
            do {
                prev = cur;
                cur = this.evaluate(this.deltagoals, false, false);
                cur += this.evaluate(this.deltagoals, true, false);
                cur += this.evaluate(this.deltagoals, false, true);
                System.out.println("Initialization run took: " + (cur += this.evaluate(this.deltagoals, true, true)));
            } while ((double)prev > (double)cur * 1.1);
            PrintWriter out = new PrintWriter(new FileWriter(new File("evaluation.csv")));
            out.println("# of Goals; No Deliberation / Sequential; No Deliberation / Concurrent; Deliberation / Sequential; Deliberation / Concurrent");
            System.out.println("# of Goals; No Deliberation / Sequential; No Deliberation / Concurrent; Deliberation / Sequential; Deliberation / Concurrent");
            for (int goals = this.deltagoals; goals <= this.maxgoals; goals += this.deltagoals) {
                long noseq = this.evaluate(goals, false, false);
                long nocon = this.evaluate(goals, false, true);
                long deseq = this.evaluate(goals, true, false);
                long decon = this.evaluate(goals, true, true);
                out.println(goals + "; " + noseq + "; " + nocon + "; " + deseq + "; " + decon);
                System.out.println(goals + "; " + noseq + "; " + nocon + "; " + deseq + "; " + decon);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Evaluation finished");
    }

    public long evaluate(int goals, boolean delib, boolean concurrent) {
        long mintime = Long.MAX_VALUE;
        for (int run = 0; run < this.runs; ++run) {
            int i;
            String goalname = delib ? "stack_delib" : "stack";
            Table table = new Table();
            Table bucket = new Table("Bucket", Color.lightGray);
            Block[] blocks = new Block[goals];
            for (int i2 = 0; i2 < blocks.length; ++i2) {
                blocks[i2] = new Block(i2, Color.RED, table);
            }
            long time = System.currentTimeMillis();
            GoalEventFilter filter = new GoalEventFilter(goalname, true);
            this.getWaitqueue().addFilter((IFilter)filter);
            if (concurrent) {
                this.startAtomic();
            }
            IFilter[] filters = new IFilter[blocks.length];
            for (i = 0; i < goals; ++i) {
                IGoal achieve = this.createGoal(goalname);
                achieve.getParameter("block").setValue((Object)blocks[i]);
                achieve.getParameter("target").setValue((Object)bucket);
                if (concurrent) {
                    filters[i] = this.dispatchSubgoal(achieve);
                    continue;
                }
                this.dispatchSubgoalAndWait(achieve);
            }
            if (concurrent) {
                this.endAtomic();
                for (i = 0; i < goals; ++i) {
                    this.waitFor(filters[i]);
                }
            }
            this.getWaitqueue().removeFilter((IFilter)filter);
            time = System.currentTimeMillis() - time;
            mintime = Math.min(time, mintime);
        }
        return mintime * (long)this.deltagoals / (long)goals;
    }
}

