/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blocksworld;

import jadex.examples.blocksworld.Block;
import jadex.examples.blocksworld.Table;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JPanel;

public class BlocksworldPanel
extends JPanel {
    protected static final double XVARIANCE = 0.2;
    protected static final double YVARIANCE = 0.04;
    protected Table table;
    protected PropertyChangeListener pcl;
    protected Map blocks;
    protected int blocksize;
    protected boolean imaginary;

    public BlocksworldPanel(Table table, boolean imaginary) {
        this.table = table;
        this.imaginary = imaginary;
        this.blocksize = 100;
        this.blocks = new WeakHashMap();
        this.pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                BlocksworldPanel.this.invalidate();
                BlocksworldPanel.this.repaint();
                BlocksworldPanel.this.observeNewBlocks();
            }
        };
        table.addPropertyChangeListener(this.pcl);
        this.observeNewBlocks();
    }

    public void setBlockSize(int blocksize) {
        this.blocksize = blocksize;
        this.revalidate();
        this.repaint();
    }

    public int getBlockSize() {
        return this.blocksize;
    }

    public Dimension getPreferredSize() {
        Dimension grid = this.getGridDimension();
        Insets insets = this.getInsets();
        return new Dimension((int)Math.ceil((double)(grid.width * this.blocksize) * 1.2) + insets.left + insets.right + 2 * this.blocksize / 5, grid.height * this.blocksize + insets.top + insets.bottom + this.blocksize / 2);
    }

    public Dimension getGridDimension() {
        Dimension dim = new Dimension(this.table.blocks.size(), 0);
        Block[] baseblocks = this.table.blocks.toArray(new Block[dim.width]);
        for (int x = 0; x < baseblocks.length; ++x) {
            int y = 0;
            Block b = baseblocks[x];
            while (b != null) {
                ++y;
                b = b.upper;
            }
            dim.height = Math.max(dim.height, y);
        }
        return dim;
    }

    protected void observeNewBlocks() {
        Block[] baseblocks = this.table.blocks.toArray(new Block[this.table.blocks.size()]);
        for (int i = 0; i < baseblocks.length; ++i) {
            Block b = baseblocks[i];
            while (b != null) {
                if (this.blocks.get(b) == null) {
                    b.addPropertyChangeListener(this.pcl);
                    this.blocks.put(b, "drin");
                }
                b = b.upper;
            }
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle bounds = this.getBounds();
        Insets insets = this.getInsets();
        bounds.x = insets.left;
        bounds.y = insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        int xvariance = (int)((double)this.blocksize * 0.2);
        int yvariance = (int)((double)this.blocksize * 0.04);
        Dimension grid = this.getGridDimension();
        bounds.x += (bounds.width - grid.width * (this.blocksize + xvariance)) / 2 - this.blocksize / 15;
        bounds.y -= this.blocksize / 5;
        Color color = this.table.getColor();
        if (this.imaginary) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 64);
        }
        g.setColor(color);
        g.fillRect(insets.left, bounds.y + bounds.height - this.blocksize / 2, bounds.width, this.blocksize / 2 - bounds.y + insets.top);
        g.setColor(color.darker());
        g.drawLine(insets.left, bounds.y + bounds.height - this.blocksize / 2, insets.left + bounds.width - 1, bounds.y + bounds.height - this.blocksize / 2);
        Block[] baseblocks = this.table.blocks.toArray(new Block[this.table.blocks.size()]);
        for (int x = 0; x < baseblocks.length; ++x) {
            int y = 0;
            Block b = baseblocks[x];
            while (b != null) {
                this.paintBlock(g, b, bounds.x + x * (this.blocksize + xvariance) + (int)((double)xvariance * b.dx + (double)((int)((double)yvariance * b.dy))), bounds.y + bounds.height - ++y * this.blocksize + (int)((double)yvariance * b.dy));
                b = b.upper;
            }
        }
    }

    protected void paintBlock(Graphics g, Block b, int x, int y) {
        int[] yp;
        int[] xp;
        Color block0 = b.getColor();
        Color block1 = block0.brighter();
        Color block2 = block0.darker();
        Color border1 = block0.darker();
        Color border2 = block0.darker();
        if (this.imaginary) {
            block0 = new Color(block0.getRed(), block0.getGreen(), block0.getBlue(), 32);
            block1 = new Color(block1.getRed(), block1.getGreen(), block1.getBlue(), 32);
            block2 = new Color(block2.getRed(), block2.getGreen(), block2.getBlue(), 32);
            border1 = new Color(border1.getRed(), border1.getGreen(), border1.getBlue(), 128);
            border2 = new Color(border2.getRed(), border2.getGreen(), border2.getBlue(), 48);
            xp = new int[]{x + this.blocksize + this.blocksize / 5 - 1, x + this.blocksize / 5, x, x + this.blocksize - 1};
            yp = new int[]{y + this.blocksize - this.blocksize / 5 - 1, y + this.blocksize - this.blocksize / 5 - 1, y + this.blocksize - 1, y + this.blocksize - 1};
            g.setColor(block2);
            g.fillPolygon(xp, yp, 4);
            g.setColor(border2);
            g.drawPolyline(xp, yp, 3);
            xp = new int[]{x + this.blocksize / 5, x + this.blocksize / 5, x, x};
            yp = new int[]{y + this.blocksize - this.blocksize / 5 - 1, y - this.blocksize / 5, y, y + this.blocksize - 1};
            g.setColor(block1);
            g.fillPolygon(xp, yp, 4);
            g.setColor(border2);
            g.drawPolyline(xp, yp, 2);
            g.setColor(block0);
            g.fillRect(x + this.blocksize / 5, y - this.blocksize / 5, this.blocksize, this.blocksize);
        }
        g.setColor(block0);
        g.fillRect(x, y, this.blocksize, this.blocksize);
        g.setColor(border1);
        g.drawRect(x, y, this.blocksize - 1, this.blocksize - 1);
        xp = new int[]{x + this.blocksize - 1, x + this.blocksize + this.blocksize / 5 - 1, x + this.blocksize / 5, x};
        yp = new int[]{y, y - this.blocksize / 5, y - this.blocksize / 5, y};
        g.setColor(block1);
        g.fillPolygon(xp, yp, 4);
        g.setColor(border1);
        g.drawPolyline(xp, yp, 4);
        xp = new int[]{x + this.blocksize - 1, x + this.blocksize + this.blocksize / 5 - 1, x + this.blocksize + this.blocksize / 5 - 1, x + this.blocksize - 1};
        yp = new int[]{y + this.blocksize - 1, y + this.blocksize - this.blocksize / 5 - 1, y - this.blocksize / 5, y};
        g.setColor(block2);
        g.fillPolygon(xp, yp, 4);
        g.setColor(border1);
        g.drawPolyline(xp, yp, 3);
    }
}

