/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blocksworld;

import jadex.examples.blocksworld.Block;
import jadex.examples.blocksworld.BlockCellRenderer;
import jadex.examples.blocksworld.BlocksListModel;
import jadex.examples.blocksworld.BlocksworldPanel;
import jadex.examples.blocksworld.Table;
import jadex.runtime.AgentEvent;
import jadex.runtime.IAgentListener;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoal;
import jadex.util.SGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BlocksworldGui
extends JFrame {
    public BlocksworldGui(final IExternalAccess agent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BlocksworldGui.this.initGui(agent);
            }
        });
    }

    protected void initGui(final IExternalAccess agent) {
        this.setTitle(agent.getAgentName());
        Block[] blocks = (Block[])agent.getBeliefbase().getBeliefSet("blocks").getFacts();
        JPanel worlds = new JPanel(new GridLayout(1, 2));
        final BlocksworldPanel bwp = new BlocksworldPanel((Table)agent.getBeliefbase().getBelief("table").getFact(), false);
        JScrollPane sp = new JScrollPane(bwp, 22, 32);
        sp.setBorder(new BevelBorder(1));
        JPanel bw = new JPanel(new BorderLayout());
        bw.setBorder(new TitledBorder(new EtchedBorder(1), "Current Blocksworld"));
        bw.add("Center", sp);
        final Table newtable = new Table();
        final BlocksworldPanel bwp2 = new BlocksworldPanel(newtable, true);
        JScrollPane sp2 = new JScrollPane(bwp2, 22, 32);
        sp2.setBorder(new BevelBorder(1));
        JPanel bw2 = new JPanel(new BorderLayout());
        bw2.setBorder(new TitledBorder(new EtchedBorder(1), "Target Configuration"));
        bw2.add("Center", sp2);
        worlds.add(bw2);
        worlds.add(bw);
        this.getContentPane().add("Center", worlds);
        final JSlider zoom = new JSlider(0, 25, 200, bwp.getBlockSize());
        zoom.setBorder(new TitledBorder(new EtchedBorder(1), "Zoom"));
        zoom.setMajorTickSpacing(25);
        zoom.setMinorTickSpacing(5);
        zoom.setPaintTicks(true);
        zoom.setPaintLabels(true);
        zoom.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                bwp.setBlockSize(zoom.getModel().getValue());
                bwp2.setBlockSize(zoom.getModel().getValue());
            }
        });
        final DefaultListModel<Block> newblocks = new DefaultListModel<Block>();
        for (int i = 0; i < blocks.length; ++i) {
            newblocks.addElement(new Block(blocks[i].number, blocks[i].getColor(), null));
        }
        final JList selblocks = new JList(newblocks);
        selblocks.setVisibleRowCount(3);
        selblocks.setCellRenderer(new BlockCellRenderer());
        JScrollPane ssp = new JScrollPane(selblocks);
        ssp.setBorder(new BevelBorder(1));
        final DefaultComboBoxModel<Table> addblocks = new DefaultComboBoxModel<Table>();
        addblocks.addElement(newtable);
        final JComboBox addtarget = new JComboBox(addblocks);
        addtarget.setRenderer(new BlockCellRenderer());
        selblocks.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    Block block = (Block)newblocks.getElementAt(selblocks.locationToIndex(me.getPoint()));
                    Block target = (Block)addtarget.getSelectedItem();
                    block.stackOn(target);
                    newblocks.removeElement(block);
                    if (target != newtable) {
                        addblocks.removeElement(target);
                    }
                    addblocks.addElement(block);
                    addtarget.setSelectedItem(block);
                }
            }
        });
        final JButton clear = new JButton("Clear table");
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                newtable.clear();
                newblocks.removeAllElements();
                Block[] blocks = (Block[])agent.getBeliefbase().getBeliefSet("blocks").getFacts();
                for (int i = 0; i < blocks.length; ++i) {
                    newblocks.addElement(new Block(blocks[i].number, blocks[i].getColor(), null));
                }
                addblocks.removeAllElements();
                addblocks.addElement(newtable);
            }
        });
        JButton goal = new JButton("Create goal");
        goal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                IGoal achieve = agent.getGoalbase().createGoal("configure");
                achieve.getParameter("configuration").setValue((Object)newtable);
                agent.getGoalbase().dispatchTopLevelGoal(achieve);
            }
        });
        JPanel options = new JPanel(new GridBagLayout());
        bw2.add("South", options);
        options.add((Component)new JLabel("Double-click to add blocks"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 2), 0, 0));
        options.add((Component)ssp, new GridBagConstraints(0, 1, 1, 0, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 2), 0, 0));
        options.add((Component)new JLabel("Stack on"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 2, 2), 0, 0));
        options.add(addtarget, new GridBagConstraints(2, 0, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 2, 2, 5), 5, 0));
        options.add((Component)clear, new GridBagConstraints(1, 1, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 2, 5), 0, 0));
        options.add((Component)goal, new GridBagConstraints(1, 2, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 2, 5), 0, 0));
        JPanel bwoptions = new JPanel(new GridBagLayout());
        bw.add("South", bwoptions);
        final JLabel showcol = new JLabel(" color ");
        showcol.setOpaque(true);
        showcol.setBackground(new Color(240, 128, 16));
        final DefaultComboBoxModel<Block> delblocks = new DefaultComboBoxModel<Block>();
        for (int i = 0; i < blocks.length; ++i) {
            delblocks.addElement(blocks[i]);
        }
        final JComboBox delblock = new JComboBox(delblocks);
        delblock.setRenderer(new BlockCellRenderer());
        JButton create = new JButton("create block");
        create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Block block = new Block(showcol.getBackground(), (Block)agent.getBeliefbase().getBelief("table").getFact());
                delblocks.addElement(block);
                newblocks.addElement(new Block(block.number, showcol.getBackground(), null));
                agent.getBeliefbase().getBeliefSet("blocks").addFact((Object)block);
            }
        });
        JButton color = new JButton("choose...");
        color.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Color newcol = JColorChooser.showDialog(showcol, "Choose block color", showcol.getBackground());
                if (newcol != null) {
                    showcol.setBackground(newcol);
                }
            }
        });
        JButton delete = new JButton("delete block");
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Block block = (Block)delblock.getSelectedItem();
                Block upper = block.upper;
                Block lower = block.getLower();
                lower.removeBlock(block);
                if (upper != null) {
                    block.removeBlock(upper);
                    lower.addBlock(upper);
                    upper.setLower(lower);
                }
                delblocks.removeElement(block);
                agent.getBeliefbase().getBeliefSet("blocks").removeFact((Object)block);
                clear.doClick();
            }
        });
        final JComboBox<String> mode = new JComboBox<String>(new String[]{"Normal", "Step", "Slow"});
        mode.setSelectedItem(agent.getBeliefbase().getBelief("mode").getFact());
        final JButton step = new JButton("step");
        step.setEnabled(mode.getSelectedItem().equals("Step"));
        mode.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                step.setEnabled(mode.getSelectedItem().equals("Step"));
                agent.getBeliefbase().getBelief("mode").setFact(mode.getSelectedItem());
            }
        });
        step.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                agent.getEventbase().dispatchInternalEvent(agent.getEventbase().createInternalEvent("step"));
            }
        });
        JList bucket = new JList(new BlocksListModel((Table)agent.getBeliefbase().getBelief("bucket").getFact()));
        bucket.setVisibleRowCount(3);
        bucket.setCellRenderer(new BlockCellRenderer());
        JScrollPane bsp = new JScrollPane(bucket);
        bsp.setBorder(new BevelBorder(1));
        bwoptions.add((Component)create, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 2, 2), 0, 0));
        bwoptions.add((Component)showcol, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 2, 2, 2), 0, 0));
        bwoptions.add((Component)color, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 2, 2, 2), 0, 0));
        bwoptions.add((Component)delete, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 2, 2), 0, 0));
        bwoptions.add(delblock, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 2, 2, 2), 5, 0));
        bwoptions.add((Component)new JLabel("Execution mode"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 2, 2), 0, 0));
        bwoptions.add(mode, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 2, 2, 2), 0, 0));
        bwoptions.add((Component)step, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 2, 2, 2), 0, 0));
        bwoptions.add((Component)new JLabel("Bucket"), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 0, 2), 0, 0));
        bwoptions.add((Component)bsp, new GridBagConstraints(3, 1, 1, 0, 1.0, 1.0, 17, 1, new Insets(0, 2, 2, 2), 0, 0));
        Dimension dim1 = bwoptions.getPreferredSize();
        Dimension dim2 = options.getPreferredSize();
        dim1.height = dim2.height = Math.max(dim1.height, dim2.height);
        bwoptions.setPreferredSize(dim1);
        options.setPreferredSize(dim2);
        this.getContentPane().add("South", zoom);
        this.pack();
        this.setLocation(SGUI.calculateMiddlePosition((Window)this));
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                agent.killAgent();
            }
        });
        agent.addAgentListener(new IAgentListener(){

            public void agentTerminating(AgentEvent ae) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        12.access$000(this.this$1).dispose();
                    }
                });
            }

            static /* synthetic */ BlocksworldGui access$000(12 x0) {
                return x0.BlocksworldGui.this;
            }
        }, false);
    }
}

