/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blocksworld;

import jadex.util.SimplePropertyChangeSupport;
import java.awt.Color;
import java.beans.PropertyChangeListener;

public class Block {
    protected static int counter = 0;
    protected int number;
    protected Color color;
    protected Block lower;
    protected Block upper;
    public SimplePropertyChangeSupport pcs;
    protected double dx;
    protected double dy;

    public Block(Color color, Block lower) {
        this(++counter, color, lower);
    }

    public Block(int number, Color color, Block lower) {
        this.number = number;
        this.color = color;
        this.pcs = new SimplePropertyChangeSupport((Object)this);
        this.stackOn(lower);
    }

    public Color getColor() {
        return this.color;
    }

    public Block getLower() {
        return this.lower;
    }

    public boolean isClear() {
        return this.upper == null;
    }

    public void stackOn(Block lower) {
        if (!this.isClear()) {
            throw new RuntimeException("Can only move clear blocks: " + this);
        }
        if (lower == this) {
            throw new RuntimeException("Cannot move block on itself: " + this);
        }
        if (this.lower != null) {
            this.lower.removeBlock(this);
        }
        if (lower != null) {
            if (!lower.isClear()) {
                throw new RuntimeException("Can only stack on clear blocks: " + lower);
            }
            lower.addBlock(this);
            this.dx = Math.random();
            this.dy = Math.random();
        }
        this.setLower(lower);
    }

    protected void setLower(Block lower) {
        Block old = this.lower;
        this.lower = lower;
        this.pcs.firePropertyChange("lower", (Object)old, (Object)this.lower);
    }

    protected void addBlock(Block block) {
        Block old = this.upper;
        this.upper = block;
        this.pcs.firePropertyChange("upper", (Object)old, (Object)this.upper);
    }

    protected void removeBlock(Block block) {
        this.upper = null;
        this.pcs.firePropertyChange("upper", (Object)block, null);
    }

    public String toString() {
        return "Block " + this.number;
    }

    public boolean equals(Object o) {
        return o instanceof Block && ((Block)o).number == this.number && ((Block)o).getColor().equals(this.getColor());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

