/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blocksworld;

import jadex.examples.blocksworld.Block;
import jadex.examples.blocksworld.Table;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;
import java.util.ArrayList;
import java.util.Random;

public class BenchmarkPlan
extends Plan {
    protected int runs;
    protected int goals;

    public void body() {
        this.runs = (Integer)this.getParameter("runs").getValue();
        this.goals = (Integer)this.getParameter("goals").getValue();
        System.out.println("Performing benchmark (" + this.runs + " runs with " + this.goals + " goals each).");
        long[] times = new long[this.runs];
        long total = 0L;
        for (int run = 0; run <= this.runs; ++run) {
            long time = System.currentTimeMillis();
            Random rand = new Random(12345678L);
            Block[] blocks = (Block[])this.getBeliefbase().getBeliefSet("blocks").getFacts();
            for (int i = 1; i <= this.goals; ++i) {
                ArrayList<Block> newblocks = new ArrayList<Block>();
                for (int j = 0; j < blocks.length; ++j) {
                    newblocks.add(new Block(blocks[j].number, blocks[j].getColor(), null));
                }
                Table table = new Table();
                ArrayList<Block> targets = new ArrayList<Block>();
                targets.add(table);
                while (newblocks.size() > 0) {
                    Block source = (Block)newblocks.remove(rand.nextInt(newblocks.size()));
                    Block target = (Block)targets.get(rand.nextInt(targets.size()));
                    source.stackOn(target);
                    targets.add(source);
                    if (target.isClear()) continue;
                    targets.remove(target);
                }
                IGoal achieve = this.createGoal("configure");
                achieve.getParameter("configuration").setValue((Object)table);
                this.dispatchSubgoalAndWait(achieve);
            }
            if (run != 0) {
                times[run - 1] = System.currentTimeMillis() - time;
                total += times[run - 1];
                System.out.println("Run " + run + " took " + times[run - 1] + " milliseconds.");
                continue;
            }
            System.out.println("Random generator test: " + rand.nextInt(1234));
        }
        System.out.println("Benchmark completed.");
        System.out.println("Total time (millis): " + total);
        System.out.println("Avg. time per run (millis): " + total / (long)this.runs);
        System.out.println("Avg. time per goal (millis): " + total / (long)this.runs / (long)this.goals);
        double deviation = 0.0;
        double avg = (double)total / (double)this.runs;
        for (int i = 0; i < this.runs; ++i) {
            deviation += ((double)times[i] - avg) * ((double)times[i] - avg);
        }
        deviation = Math.sqrt(deviation / (double)this.runs);
        System.out.println("Standard deviation of runs (millis): " + Math.round(deviation));
        this.killAgent();
    }
}

