/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blackjack.player.strategies;

import jadex.examples.blackjack.Card;
import jadex.examples.blackjack.player.strategies.ConstantStrategy;
import jadex.examples.blackjack.player.strategies.IStrategy;
import jadex.examples.blackjack.player.strategies.StochasticTable;
import jadex.util.SReflect;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractStrategy
implements IStrategy {
    public static final String CONSTANT_VERY_CAREFUL = "ConstantVeryCareful";
    public static final String CONSTANT_CAREFUL = "ConstantCareful";
    public static final String CONSTANT_RISKY = "ConstantRisky";
    public static final String CONSTANT_VERY_RISKY = "ConstantVeryRisky";
    public static final String STOCHASTIC_TABLE = "StochasticTable";
    public static final String HUMAN_PLAYER = "HumanPlayer";
    protected String name;
    protected static List strategies = new ArrayList();

    public AbstractStrategy(String name) {
        this.name = name;
    }

    public abstract int makeBet(int var1);

    public abstract boolean drawCard(Card[] var1, Card var2);

    public String getName() {
        return this.name;
    }

    public String toString() {
        return SReflect.getInnerClassName(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof IStrategy && o.getClass().equals(this.getName());
    }

    public static String[] getStrategyNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < strategies.size(); ++i) {
            ret.add(((IStrategy)strategies.get(i)).getName());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static IStrategy getStrategy(String name) {
        IStrategy ret = null;
        for (int i = 0; i < strategies.size() && ret == null; ++i) {
            IStrategy tmp = (IStrategy)strategies.get(i);
            if (!tmp.getName().equals(name)) continue;
            ret = tmp;
        }
        return ret;
    }

    public static IStrategy[] getStrategies() {
        return strategies.toArray(new IStrategy[strategies.size()]);
    }

    static {
        strategies.add(new ConstantStrategy(CONSTANT_VERY_CAREFUL, 10, 15));
        strategies.add(new ConstantStrategy(CONSTANT_CAREFUL, 10, 16));
        strategies.add(new ConstantStrategy(CONSTANT_RISKY, 10, 17));
        strategies.add(new ConstantStrategy(CONSTANT_VERY_RISKY, 10, 18));
        strategies.add(new StochasticTable(STOCHASTIC_TABLE));
    }
}

