/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blackjack.player;

import jadex.adapter.fipa.AgentAction;
import jadex.adapter.fipa.Done;
import jadex.examples.blackjack.Card;
import jadex.examples.blackjack.CardSet;
import jadex.examples.blackjack.GameResult;
import jadex.examples.blackjack.GameState;
import jadex.examples.blackjack.Player;
import jadex.examples.blackjack.RequestBet;
import jadex.examples.blackjack.RequestDraw;
import jadex.examples.blackjack.RequestFinished;
import jadex.examples.blackjack.player.HumanPlayerInterface;
import jadex.runtime.IMessageEvent;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;

public class PlayerPlayGameRoundPlan
extends Plan {
    HumanPlayerInterface hpi = null;

    public PlayerPlayGameRoundPlan() {
        this.getLogger().info("created: " + (Object)((Object)this));
        if (this.getBeliefbase().containsBelief("gui")) {
            this.hpi = (HumanPlayerInterface)this.getBeliefbase().getBelief("gui").getFact();
        }
    }

    public void body() {
        IMessageEvent querybet = (IMessageEvent)this.getInitialEvent();
        RequestBet rb = (RequestBet)querybet.getContent();
        Player me = (Player)this.getBeliefbase().getBelief("myself").getFact();
        me.setState("game started");
        long timeout = ((Number)this.getBeliefbase().getBelief("timeout").getFact()).longValue();
        int mybet = this.determineBet();
        me.makeBet(mybet);
        this.getLogger().info("new account-status=" + me.getAccount() + ", myBet=" + mybet);
        IMessageEvent msg = querybet.createReply("inform_bet");
        rb.setBet(mybet);
        msg.setContent((Object)new Done((AgentAction)rb));
        this.getLogger().info("sending bet to the dealer ... waiting for cardSet");
        this.sendMessage(msg);
        me.setState("playing");
        this.waitForCondition(this.getCondition("start_playing"));
        Card dealercard = ((GameState)this.getBeliefbase().getBelief("gamestate").getFact()).getDealer().getCards()[0];
        while (CardSet.calculateDeckValue(me.getCards()) < 21 && this.shouldDrawCard(dealercard)) {
            this.getLogger().info("player decided to draw one more card");
            RequestDraw rd = new RequestDraw();
            IMessageEvent draw_request = querybet.createReply("request_draw", (Object)rd);
            IMessageEvent ans = this.sendMessageAndWait(draw_request, timeout * 10L);
            Card[] cards = ((RequestDraw)((Done)ans.getContent()).getAction()).getCards();
            me.setCards(cards);
        }
        this.getLogger().info("player decided not to draw more cards");
        me.setState("finished");
        RequestFinished rf = new RequestFinished();
        IMessageEvent finished = querybet.createReply("request_finished", (Object)rf);
        IMessageEvent resultmsg = this.sendMessageAndWait(finished, timeout * 10L);
        GameResult gr = ((RequestFinished)((Done)resultmsg.getContent()).getAction()).getGameresult();
        if (gr.isWon()) {
            me.setAccount(me.getAccount() + gr.getMoney());
            this.getLogger().info("I won " + gr.getMoney());
        } else {
            this.getLogger().info("I lost :-(");
        }
        me.setState("idle");
    }

    public int determineBet() {
        Player me = (Player)this.getBeliefbase().getBelief("myself").getFact();
        int mybet = 10;
        if (this.hpi != null) {
            ((HumanPlayerInterface.HumanPlayerControlPanel)this.hpi.getControlPanel()).enableBid();
            try {
                this.waitForBeliefChange("gui", 5000L);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            mybet = ((HumanPlayerInterface.HumanPlayerControlPanel)this.hpi.getControlPanel()).getBet();
            ((HumanPlayerInterface.HumanPlayerControlPanel)this.hpi.getControlPanel()).disableBid();
        } else {
            mybet = me.getStrategy().makeBet(me.getAccount());
        }
        return mybet;
    }

    public boolean shouldDrawCard(Card dealercard) {
        boolean draw = false;
        Player me = (Player)this.getBeliefbase().getBelief("myself").getFact();
        if (this.hpi != null) {
            ((HumanPlayerInterface.HumanPlayerControlPanel)this.hpi.getControlPanel()).enableDrawCard();
            try {
                this.waitForBeliefChange("gui", 5000L);
                draw = ((HumanPlayerInterface.HumanPlayerControlPanel)this.hpi.getControlPanel()).isDrawCard();
            }
            catch (TimeoutException e) {
                // empty catch block
            }
            ((HumanPlayerInterface.HumanPlayerControlPanel)this.hpi.getControlPanel()).disableDrawCard();
        } else {
            draw = me.getStrategy().drawCard(me.getCards(), dealercard);
        }
        return draw;
    }

    public void failed() {
        this.getException().printStackTrace();
        this.getBeliefbase().getBelief("dealer").setFact(null);
        Player me = (Player)this.getBeliefbase().getBelief("myself").getFact();
        me.setState("idle");
    }
}

