/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blackjack.player;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.fipa.Done;
import jadex.examples.blackjack.Player;
import jadex.examples.blackjack.RequestJoin;
import jadex.runtime.IMessageEvent;
import jadex.runtime.Plan;

public class PlayerJoinGamePlan
extends Plan {
    public PlayerJoinGamePlan() {
        this.getLogger().info("created: " + (Object)((Object)this));
    }

    public void body() {
        AgentIdentifier dealer = (AgentIdentifier)this.getBeliefbase().getBelief("dealer").getFact();
        Player me = (Player)this.getBeliefbase().getBelief("myself").getFact();
        IMessageEvent msg = this.createMessageEvent("request_join");
        msg.getParameterSet("receivers").addValue((Object)dealer);
        RequestJoin rj = new RequestJoin();
        rj.setPlayer(me);
        msg.setContent((Object)rj);
        this.getLogger().info("sending join-message");
        IMessageEvent reply = this.sendMessageAndWait(msg, 10000L);
        if (reply.getContent() instanceof Done) {
            this.getLogger().info("request was accepted, timeout is: " + reply.getContent());
            this.getBeliefbase().getBelief("timeout").setFact((Object)new Integer(((RequestJoin)((Done)reply.getContent()).getAction()).getTimeout()));
            this.getBeliefbase().getBelief("dealer").setFact((Object)dealer);
        }
    }

    public void failed() {
        this.getBeliefbase().getBelief("dealer").setFact(null);
    }
}

