/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blackjack.player;

import jadex.examples.blackjack.GameState;
import jadex.examples.blackjack.Player;
import jadex.examples.blackjack.gui.GUIImageLoader;
import jadex.examples.blackjack.gui.GameStateFrame;
import jadex.examples.blackjack.gui.PlayerPanel;
import jadex.runtime.AgentEvent;
import jadex.runtime.IAgentListener;
import jadex.runtime.IExternalAccess;
import jadex.util.SGUI;
import jadex.util.SimplePropertyChangeSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class HumanPlayerInterface
extends GameStateFrame {
    protected SimplePropertyChangeSupport pcs;

    public HumanPlayerInterface(Player player, GameState gamestate, final IExternalAccess agent) {
        super(gamestate, null);
        this.setControlPanel(new HumanPlayerControlPanel(player, gamestate));
        this.pcs = new SimplePropertyChangeSupport((Object)this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                agent.killAgent();
            }
        });
        agent.addAgentListener(new IAgentListener(){

            public void agentTerminating(AgentEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        2.access$000(this.this$1).dispose();
                    }
                });
            }

            static /* synthetic */ HumanPlayerInterface access$000(2 x0) {
                return x0.HumanPlayerInterface.this;
            }
        }, false);
        this.setTitle("Human player: " + player.getName());
        this.pack();
        this.setLocation(SGUI.calculateMiddlePosition((Window)this));
        this.setVisible(true);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public class HumanPlayerControlPanel
    extends JPanel {
        protected JSpinner betsp;
        protected JButton betbut;
        protected JProgressBar betprogress;
        protected JButton draw;
        protected JButton stop;
        protected JProgressBar drawprogress;
        protected int bet;
        protected boolean drawcard;
        protected Timer timer;

        public HumanPlayerControlPanel(Player player, GameState gamestate) {
            this.setLayout(new BorderLayout());
            this.betsp = new JSpinner(new SpinnerNumberModel(10, 1, 100, 1));
            this.betbut = new JButton(GUIImageLoader.getImage("bet"));
            this.betbut.addActionListener(new ActionListener(this){
                private final /* synthetic */ HumanPlayerControlPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.makeBet();
                }
            });
            this.betbut.setEnabled(false);
            this.betprogress = new JProgressBar(0, 5);
            this.draw = new JButton(GUIImageLoader.getImage("hit"));
            this.draw.addActionListener(new ActionListener(this){
                private final /* synthetic */ HumanPlayerControlPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.setDrawCard(true);
                }
            });
            this.draw.setEnabled(false);
            this.stop = new JButton(GUIImageLoader.getImage("stand"));
            this.stop.addActionListener(new ActionListener(this){
                private final /* synthetic */ HumanPlayerControlPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.setDrawCard(false);
                }
            });
            this.stop.setEnabled(false);
            this.drawprogress = new JProgressBar(0, 5);
            JPanel control = new JPanel(new GridBagLayout());
            control.add((Component)this.betprogress, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
            control.add((Component)this.betsp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            control.add((Component)this.betbut, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            control.add((Component)this.drawprogress, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
            control.add((Component)this.draw, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            control.add((Component)this.stop, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            Dimension d = new Dimension(50, 30);
            this.betsp.setMaximumSize(d);
            this.betsp.setPreferredSize(d);
            this.betbut.setMinimumSize(d);
            this.betbut.setPreferredSize(d);
            this.draw.setMinimumSize(d);
            this.draw.setPreferredSize(d);
            this.stop.setMinimumSize(d);
            this.stop.setPreferredSize(d);
            this.add("Center", new PlayerPanel(player));
            this.add("South", control);
        }

        protected void makeBet() {
            try {
                this.setBet((Integer)this.betsp.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void enableBid() {
            this.betbut.setEnabled(true);
            this.betprogress.setValue(5);
            this.betprogress.setString(this.betprogress.getValue() + " sec left");
            this.betprogress.setStringPainted(true);
            this.timer = new Timer(1000, null);
            ActionListener al = new ActionListener(this){
                private final /* synthetic */ HumanPlayerControlPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    int time = this.this$1.betprogress.getValue() - 1;
                    this.this$1.betprogress.setValue(this.this$1.betprogress.getValue() - 1);
                    this.this$1.betprogress.setString(time + " sec left");
                    if (this.this$1.betprogress.getValue() == 0) {
                        this.this$1.timer.stop();
                        this.this$1.makeBet();
                    }
                }
            };
            this.timer.addActionListener(al);
            this.timer.start();
        }

        public void disableBid() {
            this.betbut.setEnabled(false);
            this.timer.stop();
            this.betprogress.setValue(0);
            this.betprogress.setStringPainted(false);
        }

        public void enableDrawCard() {
            this.draw.setEnabled(true);
            this.stop.setEnabled(true);
            this.drawprogress.setValue(5);
            this.drawprogress.setString(this.drawprogress.getValue() + " sec left");
            this.drawprogress.setStringPainted(true);
            this.timer = new Timer(1000, null);
            ActionListener al = new ActionListener(this){
                private final /* synthetic */ HumanPlayerControlPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    int time = this.this$1.drawprogress.getValue() - 1;
                    this.this$1.drawprogress.setString(time + " sec left");
                    this.this$1.drawprogress.setValue(time);
                    if (this.this$1.drawprogress.getValue() == 0) {
                        this.this$1.timer.stop();
                    }
                }
            };
            this.timer.addActionListener(al);
            this.timer.start();
        }

        public void disableDrawCard() {
            this.draw.setEnabled(false);
            this.stop.setEnabled(false);
            this.timer.stop();
            this.drawprogress.setValue(0);
            this.drawprogress.setStringPainted(false);
        }

        public int getBet() {
            return this.bet;
        }

        public void setBet(int bet) {
            this.bet = bet;
            HumanPlayerInterface.this.pcs.firePropertyChange("new_bet", null, (Object)new Integer(bet));
        }

        public boolean isDrawCard() {
            return this.drawcard;
        }

        public void setDrawCard(boolean drawcard) {
            this.drawcard = drawcard;
            HumanPlayerInterface.this.pcs.firePropertyChange("new_drawcard", null, (Object)new Boolean(drawcard));
        }
    }
}

