/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blackjack.manager;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.examples.blackjack.Player;
import jadex.examples.blackjack.gui.GUIImageLoader;
import jadex.examples.blackjack.player.strategies.AbstractStrategy;
import jadex.runtime.AgentEvent;
import jadex.runtime.BasicAgentIdentifier;
import jadex.runtime.IAgentListener;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoal;
import jadex.tools.common.AgentSelectorDialog;
import jadex.util.SGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.TableModel;

public class ManagerFrame
extends JFrame
implements ActionListener,
WindowListener {
    protected static AgentIdentifier LOCAL_DEALER = new AgentIdentifier("BlackjackDealer", true);
    protected JPanel playerpan;
    protected JPanel dealerpan;
    protected JTextField dealertf;
    protected AgentIdentifier dealeraid;
    protected JButton exitButton;
    protected JLabel localDealerLabel;
    protected JButton localDealerButton;
    protected String localDealerNameString = "";
    protected String localDealerMaxPlayerString = "";
    protected String localDealerPlayerPlayingString = "";
    protected Timer enableTimer;
    protected JTable dealertable;
    protected TableModel dealermodel;
    protected IExternalAccess agent;

    public ManagerFrame(final IExternalAccess access) {
        super("Blackjack Manager");
        ImageIcon icon = GUIImageLoader.getImage("heart_small_m");
        this.setIconImage(icon.getImage());
        this.agent = access;
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.enableTimer = new Timer(2000, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagerFrame.this.localDealerButton.setEnabled(true);
                ManagerFrame.this.enableTimer.stop();
            }
        });
        Container cp = this.getContentPane();
        cp.setBackground(Color.WHITE);
        cp.setLayout(new BorderLayout());
        this.playerpan = new JPanel();
        this.playerpan.setBorder(BorderFactory.createTitledBorder(" Player "));
        this.playerpan.setBackground(Color.WHITE);
        this.dealerpan = new JPanel();
        this.dealerpan.setBorder(BorderFactory.createTitledBorder(" Dealer "));
        this.dealerpan.setBackground(Color.WHITE);
        this.dealeraid = LOCAL_DEALER;
        this.dealertf = new JTextField(20);
        this.dealertf.setEditable(false);
        this.dealertf.setText("" + this.dealeraid);
        JButton dealerbut = new JButton("...");
        dealerbut.setMargin(new Insets(0, 0, 0, 0));
        dealerbut.setToolTipText("Set dealer agent identifier");
        dealerbut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AgentIdentifier tst = new AgentSelectorDialog((Component)ManagerFrame.this, ManagerFrame.this.agent).selectAgent(LOCAL_DEALER);
                if (tst != null) {
                    ManagerFrame.this.dealeraid = tst;
                    ManagerFrame.this.dealertf.setText("" + ManagerFrame.this.dealeraid);
                }
            }
        });
        this.dealerpan.add(this.dealertf);
        this.dealerpan.add(dealerbut);
        JPanel centerpan = new JPanel(new BorderLayout());
        centerpan.add((Component)this.playerpan, "Center");
        centerpan.add((Component)this.dealerpan, "South");
        JPanel buttonpan = new JPanel();
        buttonpan.setBackground(Color.WHITE);
        this.localDealerButton = new JButton("Start local Dealer");
        this.localDealerButton.addActionListener(this);
        this.exitButton = new JButton("Exit Blackjack");
        this.exitButton.addActionListener(this);
        buttonpan.add(this.localDealerButton);
        buttonpan.add(this.exitButton);
        this.agent.addAgentListener(new IAgentListener(){

            public void agentTerminating(AgentEvent ae) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        3.access$000(this.this$1).dispose();
                    }
                });
            }

            static /* synthetic */ ManagerFrame access$000(3 x0) {
                return x0.ManagerFrame.this;
            }
        }, false);
        cp.add((Component)new JLabel(GUIImageLoader.getImage("logo")), "North");
        cp.add((Component)centerpan, "Center");
        cp.add((Component)buttonpan, "South");
        this.setSize(480, 570);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getScreenSize();
        this.setLocation((int)(dim.getWidth() / 2.0 - (double)(this.getWidth() / 2)), (int)(dim.getHeight() / 2.0 - (double)(this.getHeight() / 2)));
        this.setLocation(SGUI.calculateMiddlePosition((Window)this));
        this.setVisible(true);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Player[] players = (Player[])access.getBeliefbase().getBeliefSet("players").getFacts();
                JPanel playerDealerPanel = (JPanel)ManagerFrame.this.getContentPane().getComponent(1);
                JPanel playerPanel = (JPanel)playerDealerPanel.getComponent(0);
                playerPanel.setLayout(new GridLayout(players.length, 1, 0, 0));
                playerPanel.setBackground(Color.WHITE);
                for (int i = 0; i < players.length; ++i) {
                    playerPanel.add(new ManagerPlayerPanel(i + 1, players[i]));
                }
                ManagerFrame.this.getContentPane().add((Component)playerDealerPanel, 1);
                ManagerFrame.this.getContentPane().validate();
            }
        });
    }

    public void setPlayerPlaying(String playerPlaying) {
        this.localDealerPlayerPlayingString = playerPlaying;
    }

    public void setLocalDealerButtonMode(boolean startMode) {
        if (startMode) {
            this.localDealerButton.setForeground(Color.BLACK);
            this.localDealerButton.setText("Start local Dealer");
        } else {
            this.localDealerButton.setForeground(Color.RED);
            this.localDealerButton.setText("Stop local Dealer");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.localDealerButton) {
            if (this.localDealerButton.getText().startsWith("Start")) {
                this.setLocalDealerButtonMode(false);
                this.localDealerButton.setEnabled(false);
                this.enableTimer.start();
                this.startLocalDealer();
            } else {
                this.setLocalDealerButtonMode(true);
                this.stopLocalDealer();
            }
        } else if (e.getSource() == this.exitButton) {
            this.exit();
        }
    }

    protected void exit() {
        Object[] options = new Object[]{"Yes", "No", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, "Kill all local BlackJack-Agents (Player and Dealer) ?", "Close Agents on exit", 1, 3, null, options, options[0]);
        if (n != 2) {
            if (n == 0) {
                this.stopAllAgents();
            } else {
                this.agent.killAgent();
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    public void windowClosing(WindowEvent e) {
        this.exit();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    protected void startLocalDealer() {
        try {
            IGoal start = this.agent.getGoalbase().createGoal("ams_create_agent");
            start.getParameter("type").setValue((Object)"jadex.examples.blackjack.dealer.Dealer");
            start.getParameter("name").setValue((Object)"BlackjackDealer");
            this.agent.dispatchTopLevelGoalAndWait(start);
            this.agent.getLogger().info("local DealerAgent started");
            this.agent.getBeliefbase().getBelief("localDealerAID").setFact(start.getParameter("agentidentifier").getValue());
        }
        catch (Exception e) {
            this.agent.getLogger().warning("DealerAgent could not be created: " + e);
        }
    }

    protected void stopLocalDealer() {
        AgentIdentifier dealer = (AgentIdentifier)this.agent.getBeliefbase().getBelief("localDealerAID").getFact();
        if (dealer != null) {
            IGoal destroy = this.agent.getGoalbase().createGoal("ams_destroy_agent");
            destroy.getParameter("agentidentifier").setValue((Object)dealer);
            this.agent.dispatchTopLevelGoalAndWait(destroy);
            this.agent.getBeliefbase().getBelief("localDealerAID").setFact(null);
        }
    }

    protected void stopAllAgents() {
        try {
            Player[] players = (Player[])this.agent.getBeliefbase().getBeliefSet("players").getFacts();
            for (int i = 0; i < players.length; ++i) {
                if (players[i].getAgentID() == null) continue;
                IGoal destroy = this.agent.getGoalbase().createGoal("ams_destroy_agent");
                destroy.getParameter("agentidentifier").setValue((Object)players[i].getAgentID());
                this.agent.dispatchTopLevelGoalAndWait(destroy);
            }
            this.stopLocalDealer();
            this.agent.killAgent();
        }
        catch (Exception e) {
            this.agent.getLogger().warning("At least one agent could not be stopped: " + e);
        }
    }

    public class ManagerPlayerPanel
    extends JPanel
    implements ActionListener {
        private JButton colorButton;
        private JButton actionButton;
        private JTextField name;
        private JTextField initialAccount;
        private JComboBox strategy;
        private Player player;
        private Timer enableTimer;

        public ManagerPlayerPanel(int id, Player player) {
            this.player = player;
            this.setBackground(Color.WHITE);
            this.name = new JTextField(player.getName(), 4);
            this.name.setToolTipText("Agent's name");
            this.initialAccount = new JTextField("" + player.getAccount(), 4);
            this.initialAccount.setToolTipText("Agent's initial account");
            this.colorButton = new JButton("Color");
            this.colorButton.setBackground(player.getColor());
            this.colorButton.addActionListener(this);
            this.colorButton.setToolTipText("Agent's color");
            DefaultComboBoxModel<String> cModel = new DefaultComboBoxModel<String>(AbstractStrategy.getStrategyNames());
            cModel.addElement("HumanPlayer");
            this.strategy = new JComboBox<String>(cModel);
            this.strategy.setBackground(Color.WHITE);
            this.strategy.setSelectedItem(player.getStrategyName());
            this.strategy.setToolTipText("Agent's Strategy");
            this.actionButton = new JButton("Start");
            this.actionButton.setActionCommand("start");
            this.actionButton.addActionListener(this);
            this.actionButton.setToolTipText("start/stop Agent");
            this.add(new JLabel(id + "."));
            this.add(this.name);
            this.add(this.initialAccount);
            this.add(this.colorButton);
            this.add(this.strategy);
            this.add(this.actionButton);
            this.enableTimer = new Timer(1000, new ActionListener(this){
                private final /* synthetic */ ManagerPlayerPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent evt) {
                    ManagerPlayerPanel.access$100(this.this$1).setEnabled(true);
                    ManagerPlayerPanel.access$200(this.this$1).stop();
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.colorButton) {
                Color newColor = JColorChooser.showDialog(this, "Choose Agent Color", this.colorButton.getBackground());
                if (newColor != null && !newColor.equals(Color.WHITE)) {
                    this.colorButton.setBackground(newColor);
                }
            } else if (e.getSource() == this.actionButton) {
                boolean startPlayerAgent = e.getActionCommand().equals("start");
                this.actionButton.setEnabled(false);
                this.enableTimer.start();
                this.colorButton.setEnabled(!startPlayerAgent);
                this.name.setEnabled(!startPlayerAgent);
                this.initialAccount.setEnabled(!startPlayerAgent);
                this.strategy.setEnabled(!startPlayerAgent);
                if (startPlayerAgent) {
                    this.actionButton.setForeground(Color.RED);
                    this.actionButton.setText("Stop");
                    this.actionButton.setActionCommand("stop");
                    this.player.setState("unregistered");
                    this.player.setName(this.name.getText());
                    this.player.setColor(this.colorButton.getBackground());
                    this.player.setAccount(Integer.parseInt(this.initialAccount.getText()));
                    this.player.setBet(0);
                    this.player.setStrategyName((String)this.strategy.getSelectedItem());
                    this.player.setStrategy(null);
                    this.startPlayer(this.player);
                } else {
                    this.actionButton.setForeground(Color.BLACK);
                    this.actionButton.setText("Start");
                    this.actionButton.setActionCommand("start");
                    this.stopPlayer(this.player);
                }
            }
        }

        protected void startPlayer(Player player) {
            try {
                ManagerFrame.this.agent.getLogger().info("starting playerAgent: " + player.getName());
                IGoal start = ManagerFrame.this.agent.getGoalbase().createGoal("ams_create_agent");
                start.getParameter("type").setValue((Object)"jadex.examples.blackjack.player.Player");
                start.getParameter("name").setValue((Object)player.getName());
                HashMap<String, Player> args = new HashMap<String, Player>();
                args.put("myself", player);
                args.put("dealer", (Player)ManagerFrame.this.dealeraid);
                start.getParameter("arguments").setValue(args);
                ManagerFrame.this.agent.dispatchTopLevelGoalAndWait(start);
                player.setAgentID((BasicAgentIdentifier)start.getParameter("agentidentifier").getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
                ManagerFrame.this.agent.getLogger().warning("PlayerAgent " + player + " could not be created: " + e);
            }
        }

        protected void stopPlayer(Player player) {
            IGoal destroy = ManagerFrame.this.agent.getGoalbase().createGoal("ams_destroy_agent");
            destroy.getParameter("agentidentifier").setValue((Object)player.getAgentID());
            ManagerFrame.this.agent.dispatchTopLevelGoalAndWait(destroy);
            player.setAgentID(null);
        }

        static /* synthetic */ JButton access$100(ManagerPlayerPanel x0) {
            return x0.actionButton;
        }

        static /* synthetic */ Timer access$200(ManagerPlayerPanel x0) {
            return x0.enableTimer;
        }
    }
}

