/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blackjack.gui;

import jadex.examples.blackjack.Dealer;
import jadex.examples.blackjack.GameStatistics;
import jadex.examples.blackjack.Player;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class StatisticGraph
extends JPanel
implements ActionListener {
    private GameStatistics model;
    private JCheckBox showDealer;
    private JCheckBox showPlayerNames;
    private int roundsToShow;
    private int heightToShow;
    private int depthToShow;

    public StatisticGraph(GameStatistics model) {
        super.setBackground(Color.BLACK);
        super.setForeground(Color.WHITE);
        this.model = model;
        this.showDealer = new JCheckBox("show dealer");
        this.showDealer.setSelected(true);
        this.showDealer.setBackground(this.getBackground());
        this.showDealer.setForeground(this.getForeground());
        this.showDealer.addActionListener(this);
        this.showPlayerNames = new JCheckBox("show player-names");
        this.showPlayerNames.setSelected(true);
        this.showPlayerNames.setBackground(this.getBackground());
        this.showPlayerNames.setForeground(this.getForeground());
        this.showPlayerNames.addActionListener(this);
        this.add(this.showDealer);
        this.add(this.showPlayerNames);
        model.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                StatisticGraph.this.repaint();
            }
        });
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.model.isDataAvailable()) {
            this.paintGrid(g);
            this.paintNames(g);
            this.paintLines(g);
        } else {
            g.drawString("Waiting for data ... ", 20, 50);
        }
    }

    private void paintLines(Graphics g) {
        Iterator it = this.model.getPlayers();
        while (it.hasNext()) {
            Player player = (Player)it.next();
            if (player instanceof Dealer && !this.showDealer.isSelected()) continue;
            int[] xCoords = this.model.getXArray(player);
            int[] yCoords = this.model.getYArray(player);
            for (int i = 0; i < xCoords.length; ++i) {
                xCoords[i] = this.calcX(xCoords[i]);
                yCoords[i] = this.calcY(yCoords[i]);
            }
            Color lineColor = player.getColor();
            g.setColor(lineColor);
            g.drawPolyline(xCoords, yCoords, xCoords.length);
        }
    }

    private void paintGrid(Graphics g) {
        this.roundsToShow = this.model.getMaxRound() / 10 * 10 + 10;
        this.heightToShow = this.model.getMaximum() / 100 * 100 + 100;
        this.depthToShow = Math.max(this.model.getMinimum(), 0) / 100 * 100 - 100;
        g.drawLine(this.calcX(0), this.calcY(this.heightToShow), this.calcX(0), this.calcY(this.depthToShow));
        g.drawString("" + this.heightToShow, 0, 15);
        g.drawString("" + this.depthToShow, 0, this.calcY(this.depthToShow));
        g.drawString("100", 0, this.calcY(100));
        g.drawLine(this.calcX(0), this.calcY(0), this.calcX(this.roundsToShow), this.calcY(0));
        g.drawString("0", 10, this.calcY(0) + 4);
        for (int i = 1; i < 10; ++i) {
            int step = this.roundsToShow / 10;
            g.drawString("" + i * step, this.calcX(i * step), this.calcY(0) + 12);
        }
    }

    private void paintNames(Graphics g) {
        if (this.showPlayerNames.isSelected()) {
            Iterator it = this.model.getPlayers();
            int yPos = 0;
            while (it.hasNext()) {
                Player player = (Player)it.next();
                Color lineColor = player.getColor();
                g.setColor(lineColor);
                g.drawString(player.getName(), this.calcX(0) + 8, this.calcY(this.depthToShow) - yPos);
                yPos += 12;
            }
        }
    }

    private int calcX(int xVal) {
        double xRet = ((double)this.getWidth() * 1.0 - 30.0) / ((double)this.roundsToShow * 1.0);
        xRet *= (double)xVal;
        return (int)(xRet += 30.0);
    }

    private int calcY(int yVal) {
        int hei = this.heightToShow / 100;
        int dep = this.depthToShow * -1 / 100;
        int sum = hei + dep;
        int nullPoint = this.getHeight() / sum * hei;
        double yStep = (double)this.getHeight() * 1.0 / (double)(this.heightToShow + this.depthToShow * -1);
        double ret = (double)nullPoint - (double)yVal * yStep;
        return (int)ret;
    }

    public void actionPerformed(ActionEvent e) {
        this.model.setShowDealer(this.showDealer.isSelected());
    }
}

