/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blackjack.gui;

import jadex.examples.blackjack.Card;
import jadex.examples.blackjack.CardSet;
import jadex.examples.blackjack.Player;
import jadex.examples.blackjack.gui.GUIImageLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class PlayerPanel
extends JPanel {
    protected Player player;
    protected JLabel state;
    protected JLabel account;
    protected JPanel cardpanel;
    protected JLabel bet;
    protected JLabel strategy;

    public PlayerPanel(Player player) {
        super(new BorderLayout());
        this.player = player;
        this.setBorder(BorderFactory.createTitledBorder(" Player " + player.getName() + " "));
        this.setBackground(Color.WHITE);
        JPanel stateaccountpanel = new JPanel(new GridLayout(1, 2));
        stateaccountpanel.setBackground(new Color(192, 192, 192));
        this.state = new JLabel("State: " + player.getState());
        this.account = new JLabel("Account: " + player.getAccount());
        stateaccountpanel.add(this.state);
        stateaccountpanel.add(this.account);
        JPanel betstrategypanel = new JPanel();
        betstrategypanel.setBackground(new Color(192, 192, 192));
        this.bet = new JLabel("   Bet: ");
        this.strategy = new JLabel("   " + (player.getStrategyName() != null ? player.getStrategyName() : ""));
        betstrategypanel.add(this.bet);
        betstrategypanel.add(this.strategy);
        if (player.getColor() != null) {
            stateaccountpanel.setBackground(player.getColor());
            betstrategypanel.setBackground(player.getColor());
        }
        this.cardpanel = new JPanel();
        this.cardpanel.setBorder(BorderFactory.createTitledBorder(" Cards "));
        this.cardpanel.setBackground(Color.WHITE);
        this.cardpanel.setLayout(new BoxLayout(this.cardpanel, 0));
        this.add((Component)stateaccountpanel, "North");
        this.add((Component)this.cardpanel, "Center");
        this.add((Component)betstrategypanel, "South");
        this.playerChanged();
        player.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1).playerChanged();
                    }
                });
            }

            static /* synthetic */ PlayerPanel access$000(1 x0) {
                return x0.PlayerPanel.this;
            }
        });
    }

    public void playerChanged() {
        this.state.setText("State: " + this.player.getState());
        this.bet.setText("   Bet: " + this.player.getBet());
        this.account.setText("   Account: " + this.player.getAccount());
        Card[] cards = this.player.getCards();
        this.cardpanel.removeAll();
        this.cardpanel.setLayout(new BoxLayout(this.cardpanel, 0));
        this.cardpanel.add(Box.createRigidArea(new Dimension(10, GUIImageLoader.getCardIconHeight())));
        if (cards.length > 0) {
            for (int i = 0; i < cards.length; ++i) {
                ImageIcon image = GUIImageLoader.getImage(cards[i].getType() + "_" + cards[i].getColor());
                this.cardpanel.add(new JLabel(image));
            }
            int deckValue = CardSet.calculateDeckValue(cards);
            JLabel deckValueLabel = new JLabel(" deck value: " + deckValue + " ");
            if (deckValue > 21) {
                deckValueLabel.setBackground(new Color(255, 192, 128));
                deckValueLabel.setOpaque(true);
            } else if (this.player.getState().equals("finished")) {
                deckValueLabel.setBackground(new Color(192, 255, 128));
                deckValueLabel.setOpaque(true);
            }
            this.cardpanel.add(new JLabel("   "));
            this.cardpanel.add(deckValueLabel);
            this.cardpanel.add(Box.createHorizontalGlue());
        } else {
            this.cardpanel.add(new JLabel("no cards"));
        }
        this.validate();
        this.repaint();
    }

    public Player getPlayer() {
        return this.player;
    }
}

