/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blackjack.gui;

import jadex.examples.blackjack.GameState;
import jadex.examples.blackjack.Player;
import jadex.examples.blackjack.gui.PlayerPanel;
import jadex.util.collection.SCollection;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GameStateFrame
extends JFrame {
    protected PlayersPanel dealerpan;
    protected JPanel controlpanel;
    protected PlayersPanel playerpan;
    protected JPanel top;

    public GameStateFrame(GameState gamestate, JPanel controlpan) {
        this.getContentPane().setLayout(new GridBagLayout());
        this.dealerpan = new PlayersPanel();
        this.dealerpan.setLayout(new GridLayout(1, 1));
        this.playerpan = new PlayersPanel();
        this.playerpan.setLayout(new GridLayout(0, 2));
        this.top = new JPanel(new GridLayout(1, 2));
        this.top.add(this.dealerpan);
        this.setControlPanel(controlpan);
        this.getContentPane().add((Component)this.top, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.playerpan, new GridBagConstraints(0, 1, 1, 1, 3.0, 3.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setGameState(gamestate);
    }

    public void setGameState(final GameState gamestate) {
        if (gamestate != null) {
            gamestate.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    GameStateFrame.this.updatePanel(gamestate);
                }
            });
            this.updatePanel(gamestate);
        }
    }

    protected void updatePanel(GameState gamestate) {
        int i;
        if (this.dealerpan.getPlayers().size() == 0 && gamestate.getDealer() != null) {
            this.dealerpan.addPlayer(gamestate.getDealer());
        } else if (gamestate.getDealer() != null && !this.dealerpan.getPlayers().contains(gamestate.getDealer())) {
            this.dealerpan.replacePlayer((Player)this.dealerpan.getPlayers().get(0), gamestate.getDealer());
        } else if (gamestate.getDealer() == null && this.dealerpan.getPlayers().size() > 0) {
            this.dealerpan.removePlayer((Player)this.dealerpan.getPlayers().get(0));
        }
        List curplayers = this.playerpan.getPlayers();
        Player[] players = gamestate.getPlayers();
        for (i = 0; i < players.length; ++i) {
            if (curplayers.remove(players[i])) continue;
            this.playerpan.addPlayer(players[i]);
        }
        for (i = 0; i < curplayers.size(); ++i) {
            this.playerpan.removePlayer((Player)curplayers.get(i));
        }
    }

    public JPanel getControlPanel() {
        return this.controlpanel;
    }

    public void setControlPanel(JPanel control) {
        if (control != null) {
            this.controlpanel = control;
            this.top.add(control);
            this.pack();
        }
    }

    public class PlayersPanel
    extends JPanel {
        protected ArrayList players = SCollection.createArrayList();

        public List getPlayers() {
            return (List)this.players.clone();
        }

        public void addPlayer(Player player) {
            this.players.add(player);
            SwingUtilities.invokeLater(new Runnable(this, player){
                private final /* synthetic */ Player val$player;
                private final /* synthetic */ PlayersPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$player = val$player;
                }

                public void run() {
                    this.this$1.add(new PlayerPanel(this.val$player));
                    PlayersPanel.access$000(this.this$1).pack();
                    PlayersPanel.access$000(this.this$1).repaint();
                }
            });
        }

        public void removePlayer(Player player) {
            this.players.remove(player);
            SwingUtilities.invokeLater(new Runnable(this, player){
                private final /* synthetic */ Player val$player;
                private final /* synthetic */ PlayersPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$player = val$player;
                }

                public void run() {
                    Component[] panels = this.this$1.getComponents();
                    for (int i = 0; i < panels.length; ++i) {
                        if (!(panels[i] instanceof PlayerPanel) || !((PlayerPanel)panels[i]).getPlayer().equals(this.val$player)) continue;
                        this.this$1.remove(panels[i]);
                        PlayersPanel.access$000(this.this$1).pack();
                        PlayersPanel.access$000(this.this$1).repaint();
                        break;
                    }
                }
            });
        }

        public void replacePlayer(Player oldplayer, Player newplayer) {
            if (!this.players.remove(oldplayer)) {
                throw new RuntimeException("Could not remove player: " + oldplayer);
            }
            this.players.add(newplayer);
            SwingUtilities.invokeLater(new Runnable(this, oldplayer, newplayer){
                private final /* synthetic */ Player val$oldplayer;
                private final /* synthetic */ Player val$newplayer;
                private final /* synthetic */ PlayersPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$oldplayer = val$oldplayer;
                    this.val$newplayer = val$newplayer;
                }

                public void run() {
                    Component[] panels = this.this$1.getComponents();
                    for (int i = 0; i < panels.length; ++i) {
                        if (!(panels[i] instanceof PlayerPanel) || !((PlayerPanel)panels[i]).getPlayer().equals(this.val$oldplayer)) continue;
                        this.this$1.remove(i);
                        this.this$1.add((Component)new PlayerPanel(this.val$newplayer), i);
                        PlayersPanel.access$000(this.this$1).pack();
                        PlayersPanel.access$000(this.this$1).repaint();
                        break;
                    }
                }
            });
        }

        static /* synthetic */ GameStateFrame access$000(PlayersPanel x0) {
            return x0.GameStateFrame.this;
        }
    }
}

