/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blackjack.dealer;

import jadex.examples.blackjack.GameStatistics;
import jadex.examples.blackjack.dealer.DealerFrame;
import jadex.examples.blackjack.gui.GUIImageLoader;
import jadex.examples.blackjack.gui.StatisticGraph;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoal;
import jadex.util.SGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DealerOptionPanel
extends JPanel {
    private static final int MAX_SECONDS = 60;
    protected IExternalAccess agent;
    private JProgressBar progressBar;
    private JSpinner restartWaitSpinner;
    private JSpinner cardWaitSpinner;
    private Timer progressBarTimer;
    private JCheckBox singleStepCheckBox;
    private JButton stepButton;
    private JLabel messageLabel;

    public DealerOptionPanel(final IExternalAccess agent, final DealerFrame frame) {
        super(new BorderLayout());
        this.agent = agent;
        this.setBorder(BorderFactory.createTitledBorder(" Options "));
        this.setBackground(Color.WHITE);
        this.messageLabel = new JLabel("Welcome to Blackjack!");
        JPanel messagePanel = new JPanel();
        messagePanel.setBackground(Color.WHITE);
        messagePanel.add(this.messageLabel);
        this.singleStepCheckBox = new JCheckBox("Single Step");
        this.singleStepCheckBox.setBackground(Color.WHITE);
        this.singleStepCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                agent.getBeliefbase().getBelief("singleStepMode").setFact((Object)new Boolean(DealerOptionPanel.this.singleStepCheckBox.isSelected()));
                if (DealerOptionPanel.this.singleStepCheckBox.isSelected()) {
                    DealerOptionPanel.this.stepButton.setEnabled(true);
                } else {
                    DealerOptionPanel.this.stepButton.doClick();
                    DealerOptionPanel.this.stepButton.setEnabled(false);
                }
            }
        });
        JButton statisticButton = new JButton("statistic");
        statisticButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GameStatistics stats = (GameStatistics)agent.getBeliefbase().getBelief("statistics").getFact();
                JFrame statsgui = new JFrame("Blackjack Statistics");
                statsgui.setIconImage(GUIImageLoader.getImage("statistics").getImage());
                statsgui.getContentPane().add(new StatisticGraph(stats));
                statsgui.setSize(400, 300);
                statsgui.setLocation(SGUI.calculateMiddlePosition((Window)statsgui));
                statsgui.setVisible(true);
                frame.addChildWindow(statsgui);
            }
        });
        this.stepButton = new JButton("step");
        this.stepButton.setEnabled(false);
        this.stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                agent.dispatchInternalEvent(agent.createInternalEvent("step"));
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(Color.WHITE);
        buttonPanel.add(statisticButton);
        buttonPanel.add(this.stepButton);
        buttonPanel.add(this.singleStepCheckBox);
        this.cardWaitSpinner = new JSpinner();
        this.cardWaitSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Integer value = new Integer(Math.max(0, Math.min(60, (Integer)DealerOptionPanel.this.cardWaitSpinner.getValue())));
                DealerOptionPanel.this.cardWaitSpinner.setValue(value);
                agent.getBeliefbase().getBelief("stepdelay").setFact((Object)value);
            }
        });
        this.restartWaitSpinner = new JSpinner();
        this.restartWaitSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value = Math.max(0, Math.min(60, (Integer)DealerOptionPanel.this.restartWaitSpinner.getValue()));
                DealerOptionPanel.this.restartWaitSpinner.setValue(new Integer(value));
                IGoal[] play = agent.getGoalbase().getGoals("play_game");
                if (play.length > 0) {
                    play[0].setRetryDelay((long)(1000 * value));
                }
            }
        });
        JPanel spinnerPanel = new JPanel();
        spinnerPanel.setBackground(Color.WHITE);
        spinnerPanel.add(new JLabel("restart"));
        spinnerPanel.add(this.restartWaitSpinner);
        spinnerPanel.add(new JLabel("sec."));
        spinnerPanel.add(this.cardWaitSpinner);
        spinnerPanel.add(new JLabel("carddraw"));
        this.progressBar = new JProgressBar(0, 3);
        this.progressBar.setValue(0);
        this.progressBar.setBackground(Color.WHITE);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        JPanel progressPanel = new JPanel(new GridLayout(2, 1));
        progressPanel.setBackground(Color.WHITE);
        progressPanel.add(this.progressBar);
        progressPanel.add(spinnerPanel);
        this.add((Component)messagePanel, "North");
        this.add((Component)progressPanel, "Center");
        this.add((Component)buttonPanel, "South");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DealerOptionPanel.this.singleStepCheckBox.setSelected((Boolean)agent.getBeliefbase().getBelief("singleStepMode").getFact());
                DealerOptionPanel.this.cardWaitSpinner.setValue(agent.getBeliefbase().getBelief("stepdelay").getFact());
                IGoal[] play = agent.getGoalbase().getGoals("play_game");
                DealerOptionPanel.this.restartWaitSpinner.setValue(new Integer((int)play[0].getRetryDelay() / 1000));
            }
        });
    }

    public void setIndeterminate(boolean indeterminateMode) {
        this.progressBar.setIndeterminate(indeterminateMode);
    }
}

