/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blackjack.dealer;

import jadex.adapter.fipa.AgentAction;
import jadex.adapter.fipa.Done;
import jadex.examples.blackjack.Card;
import jadex.examples.blackjack.CardSet;
import jadex.examples.blackjack.Dealer;
import jadex.examples.blackjack.GameResult;
import jadex.examples.blackjack.Player;
import jadex.examples.blackjack.RequestBet;
import jadex.examples.blackjack.RequestDraw;
import jadex.examples.blackjack.RequestFinished;
import jadex.runtime.ICondition;
import jadex.runtime.IFilter;
import jadex.runtime.IMessageEvent;
import jadex.runtime.MessageEventFilter;
import jadex.runtime.Plan;

public class DealerGameRoundPlayerPlan
extends Plan {
    protected long timeout = ((Number)this.getBeliefbase().getBelief("playerwaitmillis").getFact()).longValue();
    protected Player player = (Player)this.getParameter("player").getValue();

    public void body() {
        int bet;
        this.getLogger().info("Asking for bet from player: " + this.player);
        RequestBet rb = new RequestBet();
        IMessageEvent msg = this.createMessageEvent("request_bet");
        msg.setContent((Object)rb);
        msg.getParameterSet("receivers").addValue((Object)this.player.getAgentID());
        IMessageEvent betmsg = this.sendMessageAndWait(msg, this.timeout);
        this.getLogger().info("Received bet from player: " + this.player + ", " + betmsg.getContent());
        if (!(betmsg.getContent() instanceof Done)) {
            this.fail();
        }
        if ((bet = ((RequestBet)((Done)betmsg.getContent()).getAction()).getBet()) > this.player.getAccount()) {
            this.startAtomic();
            this.player.setState("unregistered");
            this.getBeliefbase().getBeliefSet("players").removeFact((Object)this.player);
            this.endAtomic();
        }
        this.player.makeBet(bet);
        this.player.setState("playing");
        this.drawCard();
        this.drawCard();
        MessageEventFilter fil = new MessageEventFilter(null);
        fil.addValue("conversation-id", betmsg.getParameter("conversation-id").getValue());
        this.getWaitqueue().addFilter((IFilter)fil);
        this.getLogger().info("Waiting for dealer card: " + this.player);
        this.waitForCondition(this.getCondition("dealer_card"), this.timeout * 10L);
        this.getLogger().info("Informing player about dealer card: " + this.player);
        Dealer me = (Dealer)this.getBeliefbase().getBelief("myself").getFact();
        IMessageEvent answer = (IMessageEvent)this.waitFor((IFilter)fil, this.timeout);
        this.getWaitqueue().removeFilter((IFilter)fil);
        while (answer.getContent() instanceof RequestDraw) {
            this.drawCard();
            RequestDraw rd = (RequestDraw)answer.getContent();
            rd.setCards(this.player.getCards());
            Done done = new Done((AgentAction)rd);
            IMessageEvent mdone = answer.createReply("inform_action_done", (Object)done);
            answer = this.sendMessageAndWait(mdone, this.timeout);
            this.getLogger().info("Player wants to draw a card: " + this.player);
        }
        this.getLogger().info("Player is finished: " + this.player);
        this.player.setState("finished");
        this.getLogger().info("Waiting for dealer to finish: " + this.player);
        this.waitForCondition(this.getCondition("dealer_finished"), this.timeout * 10L);
        GameResult gr = new GameResult();
        int moneywon = this.player.getMoneyWon(me.getCards());
        if (moneywon > 0) {
            gr.setWon(true);
            gr.setMoney(moneywon);
            this.player.setAccount(this.player.getAccount() + moneywon);
        } else {
            gr.setWon(false);
        }
        RequestFinished rf = (RequestFinished)answer.getContent();
        rf.setGameresult(gr);
        Done done = new Done((AgentAction)rf);
        IMessageEvent result = answer.createReply("inform_action_done", (Object)done);
        this.sendMessage(result);
        this.getLogger().info("Player result" + this.player + "-" + result.getContent());
        if (((Boolean)this.getBeliefbase().getBelief("singleStepMode").getFact()).booleanValue()) {
            this.waitForInternalEvent("step");
        } else {
            this.waitFor(1000 * ((Number)this.getBeliefbase().getBelief("stepdelay").getFact()).intValue());
        }
    }

    public void failed() {
        this.getLogger().info("Player failure :" + this.player);
        this.player.setState("unregistered");
        this.getBeliefbase().getBeliefSet("players").removeFact((Object)this.player);
    }

    public void passed() {
        this.getLogger().info("Game completed :" + this.player);
        this.player.setState("idle");
    }

    public void aborted() {
        this.getLogger().info("Game aborted :" + this.player);
        this.player.setState("idle");
    }

    protected void drawCard() {
        this.getLogger().info("Waiting for players turn: " + this.player);
        ICondition turn = this.getCondition("players_turn");
        turn.setParameter("$player", (Object)this.player);
        this.waitForCondition(turn, this.timeout * 10L);
        if (((Boolean)this.getBeliefbase().getBelief("singleStepMode").getFact()).booleanValue()) {
            this.waitForInternalEvent("step");
        } else {
            this.waitFor(1000 * ((Number)this.getBeliefbase().getBelief("stepdelay").getFact()).intValue());
        }
        CardSet cardset = (CardSet)this.getBeliefbase().getBelief("cardset").getFact();
        Card card = cardset.drawCard();
        this.player.addCard(card);
    }
}

