/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blackjack.dealer;

import jadex.examples.blackjack.Card;
import jadex.examples.blackjack.CardSet;
import jadex.examples.blackjack.Dealer;
import jadex.examples.blackjack.GameStatistics;
import jadex.examples.blackjack.Player;
import jadex.runtime.ICondition;
import jadex.runtime.IGoal;
import jadex.runtime.Plan;
import jadex.util.SUtil;

public class DealerGameRoundMasterPlan
extends Plan {
    public void body() {
        int i;
        this.getLogger().info("Starting new game.");
        long timeout = (Long)this.getBeliefbase().getBelief("playerwaitmillis").getFact();
        CardSet cardset = new CardSet();
        this.getBeliefbase().getBelief("cardset").setFact((Object)cardset);
        Dealer me = (Dealer)this.getBeliefbase().getBelief("myself").getFact();
        me.setState("game started");
        Player[] players = (Player[])this.getBeliefbase().getBeliefSet("players").getFacts();
        IGoal[] goals = new IGoal[players.length];
        for (int i2 = 0; i2 < players.length; ++i2) {
            players[i2].setState("game started");
            goals[i2] = this.createGoal("play_with_player");
            goals[i2].getParameter("player").setValue((Object)players[i2]);
            this.getWaitqueue().addSubgoal(goals[i2]);
            this.dispatchSubgoal(goals[i2]);
            this.getLogger().info("Playing with player: " + players[i2]);
        }
        me.setState("playing");
        while (CardSet.calculateDeckValue(me.getCards()) <= 16) {
            this.getLogger().info("Now waiting for dealer's turn.");
            ICondition turn = this.getCondition("dealers_turn");
            this.waitForCondition(turn, timeout * 10L);
            this.getLogger().info("Dealer's turn. Players: " + SUtil.arrayToString((Object)players));
            if (((Boolean)this.getBeliefbase().getBelief("singleStepMode").getFact()).booleanValue()) {
                this.waitForInternalEvent("step");
            } else {
                this.waitFor(1000 * ((Number)this.getBeliefbase().getBelief("stepdelay").getFact()).intValue());
            }
            Card dealerCard = cardset.drawCard();
            me.addCard(dealerCard);
            this.getLogger().info("Dealer draws a new card, it's " + dealerCard + " deck-value=" + CardSet.calculateDeckValue(me.getCards()));
        }
        this.getLogger().info("Dealer finished drawing cards");
        int newaccount = me.getAccount();
        for (i = 0; i < players.length; ++i) {
            if (players[i].getState().equals("idle")) continue;
            newaccount += players[i].getBet() - players[i].getMoneyWon(me.getCards());
        }
        me.setAccount(newaccount);
        me.setState("finished");
        if (((Boolean)this.getBeliefbase().getBelief("singleStepMode").getFact()).booleanValue()) {
            this.waitForInternalEvent("step");
        } else {
            this.waitFor(1000 * ((Number)this.getBeliefbase().getBelief("stepdelay").getFact()).intValue());
        }
        for (i = 0; i < players.length; ++i) {
            this.waitForSubgoal(goals[i]);
        }
        ((GameStatistics)this.getBeliefbase().getBelief("statistics").getFact()).addGameRound(me, players);
        me.setState("idle");
    }

    public void failed() {
        System.out.println(":-( " + this.getName());
        Dealer me = (Dealer)this.getBeliefbase().getBelief("myself").getFact();
        this.getLogger().info("Dealer failure :" + this.getBeliefbase().getBelief("myself").getFact());
        me.setState("idle");
    }
}

