/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blackjack;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.examples.blackjack.Card;
import jadex.examples.blackjack.CardSet;
import jadex.examples.blackjack.player.strategies.AbstractStrategy;
import jadex.examples.blackjack.player.strategies.IStrategy;
import jadex.runtime.BasicAgentIdentifier;
import jadex.util.SUtil;
import jadex.util.SimplePropertyChangeSupport;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class Player {
    public static final String STATE_UNREGISTERED = "unregistered";
    public static final String STATE_IDLE = "idle";
    public static final String STATE_GAME_STARTED = "game started";
    public static final String STATE_PLAYING = "playing";
    public static final String STATE_FINISHED = "finished";
    protected String name;
    protected int account;
    protected Color color;
    protected int colorvalue;
    protected String strategyname;
    protected IStrategy strategy;
    protected BasicAgentIdentifier aid;
    protected String state;
    protected int bet;
    protected boolean drawcard;
    protected List cards;
    protected int games;
    public SimplePropertyChangeSupport pcs;

    public Player() {
        this(null, 0, null, null);
    }

    public Player(String name, int account, Color color, String strategyname) {
        this(null, name, account, color, strategyname);
    }

    public Player(AgentIdentifier aid, String name, int account, Color color, String strategyname) {
        this.aid = aid;
        this.name = name;
        this.account = account;
        this.setColor(color);
        this.strategyname = strategyname;
        this.state = STATE_UNREGISTERED;
        this.pcs = new SimplePropertyChangeSupport((Object)this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAccount() {
        return this.account;
    }

    public void setAccount(int account) {
        this.account = account;
    }

    public Color getColor() {
        if (this.color == null) {
            this.color = new Color(this.colorvalue);
        }
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (color != null) {
            this.colorvalue = color.getRGB();
        }
    }

    public int getColorValue() {
        return this.colorvalue;
    }

    public void setColorValue(int colorvalue) {
        this.colorvalue = colorvalue;
    }

    public IStrategy getStrategy() {
        if (this.strategy == null && this.strategyname != null) {
            this.strategy = AbstractStrategy.getStrategy(this.strategyname);
        }
        return this.strategy;
    }

    public void setStrategy(IStrategy strategy) {
        this.strategy = strategy;
    }

    public String getStrategyName() {
        return this.strategyname;
    }

    public void setStrategyName(String strategyname) {
        this.strategyname = strategyname;
    }

    public BasicAgentIdentifier getAgentID() {
        return this.aid;
    }

    public void setAgentID(BasicAgentIdentifier aid) {
        this.aid = aid;
    }

    public void addCard(Card card) {
        if (this.cards == null) {
            this.cards = new ArrayList();
        }
        this.cards.add(card);
        this.pcs.firePropertyChange("new_card", null, (Object)card);
    }

    public Card[] getCards() {
        return this.cards == null ? new Card[]{} : this.cards.toArray(new Card[this.cards.size()]);
    }

    public void setCards(Card[] cards) {
        this.cards = SUtil.arrayToList((Object)cards);
        this.pcs.firePropertyChange("new_cards", null, (Object)cards);
    }

    public Card getCard(int idx) {
        return (Card)this.cards.get(idx);
    }

    public void setCard(int idx, Card card) {
        this.cards.add(idx, card);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
        if (state.equals(STATE_GAME_STARTED)) {
            ++this.games;
            this.cards = null;
            this.bet = 0;
        }
        if (state.equals(STATE_IDLE)) {
            this.cards = null;
            this.bet = 0;
        }
        this.pcs.firePropertyChange("new_state", null, (Object)state);
    }

    public int getBet() {
        return this.bet;
    }

    public void setBet(int bet) {
        this.bet = bet;
        this.pcs.firePropertyChange("new_bet", null, (Object)new Integer(bet));
    }

    public void makeBet(int bet) {
        if (bet > this.account) {
            throw new RuntimeException("Insufficient cover for bet " + bet + ": " + this);
        }
        this.account -= bet;
        this.bet = bet;
        this.pcs.firePropertyChange("new_bet", null, (Object)new Integer(bet));
    }

    public int getGameCount() {
        return this.games;
    }

    public int getMoneyWon(Card[] dealercards) {
        int dealerval = CardSet.calculateDeckValue(dealercards);
        int playerval = CardSet.calculateDeckValue(this.getCards());
        int moneywon = playerval <= 21 && (playerval >= dealerval || dealerval > 21) ? (playerval == dealerval ? this.bet : this.bet * 2) : 0;
        return moneywon;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Player && this.name.equals(((Player)o).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Player(name=" + this.name + ", state=" + this.state + ", cards=" + this.cards + ", money=" + this.account + ")";
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

