/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blackjack;

import jadex.examples.blackjack.Dealer;
import jadex.examples.blackjack.Player;
import jadex.util.SimplePropertyChangeSupport;
import jadex.util.Tuple;
import jadex.util.collection.MultiCollection;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;

public class GameStatistics {
    private MultiCollection playerModels = new MultiCollection();
    private int maxRound = 0;
    private int maximum = 0;
    private int minimum = 0;
    private boolean showDealer = true;
    public SimplePropertyChangeSupport pcs = new SimplePropertyChangeSupport((Object)this);

    public void setShowDealer(boolean show) {
        this.showDealer = show;
    }

    public void addGameRound(Dealer dealer, Player[] players) {
        this.playerModels.put((Object)dealer, (Object)new Tuple((Object)new Integer(dealer.getGameCount()), (Object)new Integer(dealer.getAccount())));
        for (int i = 0; i < players.length; ++i) {
            this.playerModels.put((Object)players[i], (Object)new Tuple((Object)new Integer(dealer.getGameCount()), (Object)new Integer(players[i].getAccount())));
        }
        this.maxRound = this.playerModels.getCollection((Object)dealer).size();
        this.maximum = 0;
        this.minimum = 0;
        Iterator it = this.playerModels.keySet().iterator();
        while (it.hasNext()) {
            Player player = (Player)it.next();
            if (player instanceof Dealer && !this.showDealer) continue;
            List playerData = (List)this.playerModels.getCollection((Object)player);
            for (int i = 0; i < playerData.size(); ++i) {
                Tuple tup = (Tuple)playerData.get(i);
                int val = (Integer)tup.get(1);
                if (val > this.maximum) {
                    this.maximum = val;
                }
                if (val >= this.minimum) continue;
                this.minimum = val;
            }
        }
        this.pcs.firePropertyChange("new_data", null, (Object)"data");
    }

    public Iterator getPlayers() {
        return this.playerModels.keySet().iterator();
    }

    public boolean isDataAvailable() {
        return !this.playerModels.isEmpty();
    }

    public int[] getXArray(Player player) {
        List coors = (List)this.playerModels.getCollection((Object)player);
        int[] retArray = new int[coors.size()];
        for (int i = 0; i < coors.size(); ++i) {
            Tuple dummy = (Tuple)coors.get(i);
            retArray[i] = (Integer)dummy.get(0);
        }
        return retArray;
    }

    public int[] getYArray(Player player) {
        List coors = (List)this.playerModels.getCollection((Object)player);
        int[] retArray = new int[coors.size()];
        for (int i = 0; i < coors.size(); ++i) {
            Tuple dummy = (Tuple)coors.get(i);
            retArray[i] = (Integer)dummy.get(1);
        }
        return retArray;
    }

    public int getMaxRound() {
        return this.maxRound;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

