/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.blackjack;

import jadex.examples.blackjack.Player;
import jadex.util.SimplePropertyChangeSupport;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

public class GameState
implements BeanInfo {
    protected Player dealer;
    protected List players = new ArrayList();
    public SimplePropertyChangeSupport pcs = new SimplePropertyChangeSupport((Object)this);
    private PropertyDescriptor[] pds = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GameState() {
        this(null, null);
    }

    public GameState(Player dealer, Player[] players) {
        if (dealer != null) {
            this.setDealer(dealer);
        }
        if (players != null && players.length > 0) {
            this.setPlayers(players);
        }
    }

    public Player getDealer() {
        return this.dealer;
    }

    public void setDealer(Player dealer) {
        this.dealer = dealer;
        this.pcs.firePropertyChange("dealer", null, (Object)dealer);
    }

    public void updateDealer(Player dealer) {
        this.dealer.setAccount(dealer.getAccount());
        this.dealer.setCards(dealer.getCards());
        this.dealer.setColorValue(dealer.getColorValue());
        this.dealer.setStrategyName(dealer.getStrategyName());
        this.dealer.setState(dealer.getState());
        this.pcs.firePropertyChange("dealer", null, (Object)dealer);
    }

    public Player[] getPlayers() {
        return this.players.toArray(new Player[this.players.size()]);
    }

    public void setPlayers(Player[] players) {
        this.players.clear();
        for (int i = 0; i < players.length; ++i) {
            this.players.add(players[i]);
        }
        this.pcs.firePropertyChange("players", null, (Object)players);
    }

    public Player getPlayer(int idx) {
        return (Player)this.players.get(idx);
    }

    public void setPlayer(int idx, Player player) {
        this.players.set(idx, player);
        this.pcs.firePropertyChange("players", null, (Object)this.players);
    }

    public void addPlayer(Player player) {
        this.players.add(player);
        this.pcs.firePropertyChange("players", null, (Object)this.players);
    }

    public boolean removePlayer(Player player) {
        boolean ret = this.players.remove(player);
        this.pcs.firePropertyChange("players", null, (Object)this.players);
        return ret;
    }

    public void updateOrAddPlayer(Player player) {
        boolean updated = false;
        for (int i = 0; i < this.players.size() && !updated; ++i) {
            if (this.players.get(i) == player) {
                updated = true;
                continue;
            }
            if (!this.players.get(i).equals(player)) continue;
            Player orig = (Player)this.players.get(i);
            orig.setCards(player.getCards());
            orig.setAccount(player.getAccount());
            orig.setColorValue(player.getColorValue());
            orig.setStrategyName(player.getStrategyName());
            orig.setState(player.getState());
            orig.setBet(player.getBet());
            updated = true;
            this.pcs.firePropertyChange("players", null, (Object)this.players);
        }
        if (!updated) {
            this.addPlayer(player);
        }
    }

    public Player getPlayer(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        Player ret = null;
        for (int i = 0; i < this.players.size() && ret == null; ++i) {
            Player tst = (Player)this.players.get(i);
            if (!name.equals(tst.getName())) continue;
            ret = tst;
        }
        return ret;
    }

    public BeanDescriptor getBeanDescriptor() {
        return null;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        if (this.pds == null) {
            try {
                this.pds = new PropertyDescriptor[]{new PropertyDescriptor("dealer", this.getClass(), "getDealer", "setDealer"), new IndexedPropertyDescriptor("players", this.getClass(), "getPlayers", "setPlayers", "getPlayer", "setPlayer")};
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.pds;
    }

    public int getDefaultPropertyIndex() {
        return -1;
    }

    public EventSetDescriptor[] getEventSetDescriptors() {
        return null;
    }

    public int getDefaultEventIndex() {
        return -1;
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return null;
    }

    public BeanInfo[] getAdditionalBeanInfo() {
        return null;
    }

    public Image getIcon(int iconKind) {
        return null;
    }

    public Image loadImage(final String resourceName) {
        try {
            final Class<?> c = this.getClass();
            ImageProducer ip = (ImageProducer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL url = c.getResource(resourceName);
                    if (url == null) {
                        return null;
                    }
                    try {
                        return url.getContent();
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                }
            });
            if (ip == null) {
                return null;
            }
            Toolkit tk = Toolkit.getDefaultToolkit();
            return tk.createImage(ip);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public String toString() {
        return "GameState()";
    }

    static {
        $assertionsDisabled = !GameState.class.desiredAssertionStatus();
    }
}

