/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.util.Stack;
import org.jibx.runtime.IXMLWriter;

public abstract class XMLWriterNamespaceBase
implements IXMLWriter {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    protected String[] m_uris;
    protected String[] m_prefixes;
    private int m_nestingDepth;
    private Stack m_namespaceStack;
    private int m_namespaceDepth;
    private String[][] m_extensionUris;
    private String[][] m_extensionPrefixes;

    public XMLWriterNamespaceBase(String[] uris) {
        this.m_uris = uris;
        this.m_prefixes = new String[uris.length];
        this.m_prefixes[0] = "";
        this.m_prefixes[1] = "xml";
        this.m_namespaceStack = new Stack();
        this.m_namespaceDepth = -1;
    }

    protected abstract void defineNamespace(int var1, String var2) throws IOException;

    protected abstract void undefineNamespace(int var1);

    private void setNamespacePrefix(int index, String prefix) {
        if (index < this.m_prefixes.length) {
            this.m_prefixes[index] = prefix;
        } else if (this.m_extensionUris != null) {
            index -= this.m_prefixes.length;
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                int length = this.m_extensionUris[i].length;
                if (index < length) {
                    this.m_extensionPrefixes[i][index] = prefix;
                    break;
                }
                index -= length;
            }
        }
    }

    public int[] openNamespaces(int[] nums, String[] prefs) throws IOException {
        int count = 0;
        for (int i = 0; i < nums.length; ++i) {
            String newpref = prefs[i];
            String oldpref = this.getNamespacePrefix(nums[i]);
            boolean use = false;
            if (!(newpref.equals(oldpref) || "".equals(newpref) && oldpref != null)) {
                use = true;
                for (int j = 0; j < i; ++j) {
                    if (nums[i] != nums[j]) continue;
                    if (prefs[i] == null) {
                        nums[i] = -1;
                        continue;
                    }
                    use = false;
                    break;
                }
            }
            if (use) {
                ++count;
                continue;
            }
            nums[i] = -1;
        }
        int[] deltas = EMPTY_INT_ARRAY;
        if (count > 0) {
            String[] priors = new String[count];
            if (count == nums.length) {
                deltas = nums;
                for (int i = 0; i < count; ++i) {
                    int slot = deltas[i];
                    priors[i] = this.getNamespacePrefix(slot);
                    this.setNamespacePrefix(slot, prefs[i]);
                    this.defineNamespace(slot, prefs[i]);
                }
            } else {
                int fill = 0;
                deltas = new int[count];
                for (int i = 0; i < nums.length; ++i) {
                    int slot = nums[i];
                    if (slot < 0) continue;
                    deltas[fill] = slot;
                    priors[fill++] = this.getNamespacePrefix(slot);
                    this.setNamespacePrefix(slot, prefs[i]);
                    this.defineNamespace(slot, prefs[i]);
                }
            }
            this.m_namespaceStack.push(new DeclarationInfo(this.m_nestingDepth, deltas, priors));
            this.m_namespaceDepth = this.m_nestingDepth;
        }
        return deltas;
    }

    private void closeNamespaces() {
        DeclarationInfo info = (DeclarationInfo)this.m_namespaceStack.pop();
        int[] deltas = info.m_deltas;
        String[] priors = info.m_priors;
        for (int i = 0; i < deltas.length; ++i) {
            int index = deltas[i];
            this.undefineNamespace(index);
            if (index < this.m_prefixes.length) {
                this.m_prefixes[index] = priors[i];
                continue;
            }
            if (this.m_extensionUris == null) continue;
            index -= this.m_prefixes.length;
            for (int j = 0; j < this.m_extensionUris.length; ++j) {
                int length = this.m_extensionUris[j].length;
                if (index < length) {
                    this.m_extensionPrefixes[j][index] = priors[i];
                    continue;
                }
                index -= length;
            }
        }
        this.m_namespaceDepth = this.m_namespaceStack.empty() ? -1 : ((DeclarationInfo)this.m_namespaceStack.peek()).m_depth;
    }

    public final int getNestingDepth() {
        return this.m_nestingDepth;
    }

    public final int getNamespaceCount() {
        int count = this.m_uris.length;
        if (this.m_extensionUris != null) {
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                count += this.m_extensionUris[i].length;
            }
        }
        return count;
    }

    protected void incrementNesting() {
        ++this.m_nestingDepth;
    }

    protected void decrementNesting() {
        --this.m_nestingDepth;
        if (this.m_nestingDepth >= 0) {
            while (this.m_nestingDepth == this.m_namespaceDepth) {
                this.closeNamespaces();
            }
        }
    }

    public void reset() {
        this.m_nestingDepth = 0;
        this.m_namespaceDepth = -1;
        this.m_namespaceStack.clear();
        this.m_extensionUris = null;
        this.m_extensionPrefixes = null;
    }

    public final String[] getNamespaces() {
        return this.m_uris;
    }

    public final String getNamespaceUri(int index) {
        if (index < this.m_uris.length) {
            return this.m_uris[index];
        }
        if (this.m_extensionUris != null) {
            index -= this.m_uris.length;
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                int length = this.m_extensionUris[i].length;
                if (index < length) {
                    return this.m_extensionUris[i][index];
                }
                index -= length;
            }
        }
        return null;
    }

    public final String getNamespacePrefix(int index) {
        if (index < this.m_prefixes.length) {
            return this.m_prefixes[index];
        }
        if (this.m_extensionUris != null) {
            index -= this.m_prefixes.length;
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                int length = this.m_extensionUris[i].length;
                if (index < length) {
                    return this.m_extensionPrefixes[i][index];
                }
                index -= length;
            }
        }
        return null;
    }

    public final int getPrefixIndex(String prefix) {
        int i;
        if (this.m_extensionPrefixes != null) {
            for (i = this.m_extensionPrefixes.length - 1; i >= 0; --i) {
                String[] prefixes = this.m_extensionPrefixes[i];
                for (int j = prefixes.length - 1; j >= 0; --j) {
                    if (!prefix.equals(prefixes[j])) continue;
                    int index = j + this.m_prefixes.length;
                    for (int k = i - 1; k >= 0; --k) {
                        index += this.m_extensionPrefixes[k].length;
                    }
                    return index;
                }
            }
        }
        for (i = this.m_prefixes.length - 1; i >= 0; --i) {
            if (!prefix.equals(this.m_prefixes[i])) continue;
            return i;
        }
        return -1;
    }

    protected static String[][] growArray(String[][] base, String[] items) {
        if (base == null) {
            return new String[][]{items};
        }
        int length = base.length;
        String[][] grow = new String[length + 1][];
        System.arraycopy(base, 0, grow, 0, length);
        grow[length] = items;
        return grow;
    }

    protected static String[][] shrinkArray(String[][] base) {
        int length = base.length;
        if (length == 1) {
            return null;
        }
        String[][] shrink = new String[length - 1][];
        System.arraycopy(base, 0, shrink, 0, length - 1);
        return shrink;
    }

    public void pushExtensionNamespaces(String[] uris) {
        this.m_extensionUris = XMLWriterNamespaceBase.growArray(this.m_extensionUris, uris);
        this.m_extensionPrefixes = XMLWriterNamespaceBase.growArray(this.m_extensionPrefixes, new String[uris.length]);
    }

    public void popExtensionNamespaces() {
        this.m_extensionUris = XMLWriterNamespaceBase.shrinkArray(this.m_extensionUris);
        this.m_extensionPrefixes = XMLWriterNamespaceBase.shrinkArray(this.m_extensionPrefixes);
    }

    public final String[][] getExtensionNamespaces() {
        return this.m_extensionUris;
    }

    private static class DeclarationInfo {
        public final int m_depth;
        public final int[] m_deltas;
        public final String[] m_priors;

        public DeclarationInfo(int depth, int[] deltas, String[] priors) {
            this.m_depth = depth;
            this.m_deltas = deltas;
            this.m_priors = priors;
        }
    }
}

