/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer.ui;

import com.touchgraph.graphlayout.Edge;
import jadex.tools.common.GuiProperties;
import jadex.tools.tracer.TracerController;
import jadex.tools.tracer.nodes.TAgent;
import jadex.tools.tracer.nodes.TNode;
import jadex.tools.tracer.nodes.TTop;
import jadex.tools.tracer.ui.AgentFilterPanel;
import jadex.tools.tracer.ui.GraphPanel;
import jadex.tools.tracer.ui.TEdge;
import jadex.tools.tracer.ui.TraceTable;
import jadex.tools.tracer.ui.TraceTableModel;
import jadex.tools.tracer.ui.TraceTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public final class TracerUI
extends JSplitPane
implements TreeSelectionListener {
    protected final TracerController ctrl;
    protected final TraceTable table;
    protected final TraceTableModel table_model;
    protected final TraceTree tree;
    protected final TNode root;
    protected final GraphPanel graph;
    protected AgentFilterPanel afp;
    protected TAgent selectedAgent;
    private JCheckBoxMenuItem autoscroll;
    private JCheckBoxMenuItem ignoreAtFirst;
    protected static final MenuListener MENU_ACTIVATOR = new MenuListener(){

        public void menuCanceled(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuSelected(MenuEvent e) {
            Component[] me = ((JMenu)e.getSource()).getPopupMenu().getComponents();
            int i = me.length;
            while (i-- > 0) {
                JMenuItem mi;
                if (!(me[i] instanceof JMenuItem) || (mi = (JMenuItem)me[i]).getAction() == null) continue;
                mi.setEnabled(mi.getAction().isEnabled());
            }
        }
    };
    protected static final PopupMenuListener PMENU_ACTIVATOR = new PopupMenuListener(){

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            Component[] me = ((JPopupMenu)e.getSource()).getComponents();
            int i = me.length;
            while (i-- > 0) {
                JMenuItem mi;
                if (!(me[i] instanceof JMenuItem) || (mi = (JMenuItem)me[i]).getAction() == null) continue;
                mi.setEnabled(mi.getAction().isEnabled());
            }
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }
    };
    protected JSplitPane tableSplit;

    public TracerUI(final TracerController ctrl) {
        super(1);
        this.ctrl = ctrl;
        this.root = new TTop();
        this.tree = new TraceTree(this.root, this);
        this.table_model = new TraceTableModel();
        this.table = new TraceTable(this.table_model, this);
        this.graph = new GraphPanel(this);
        GuiProperties.setupHelp(this.graph, "tracer.graph");
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        GuiProperties.setupHelp(this.tree, "tracer.tree");
        this.setSize(800, 600);
        this.add(new JScrollPane(this.tree));
        this.tableSplit = new JSplitPane(0);
        this.tableSplit.setOneTouchExpandable(true);
        JScrollPane sp = new JScrollPane(this.table);
        GuiProperties.setupHelp(sp, "tracer.table");
        JPanel north = new JPanel(new BorderLayout());
        north.add((Component)sp, "Center");
        this.afp = new AgentFilterPanel(ctrl.getPrototype());
        JButton clear = new JButton("Clear");
        clear.setToolTipText("Clear the list of traces");
        JButton apply = new JButton("Apply");
        apply.setToolTipText("Apply current settings to all traced agents");
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ctrl.removeTraces(TracerUI.this.table_model.getAllTraces());
            }
        });
        apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TAgent[] agents = ctrl.getAgents();
                for (int i = 0; i < agents.length; ++i) {
                    boolean ignored = agents[i].isIgnored();
                    agents[i].copyFilters(ctrl.getPrototype());
                    agents[i].setIgnored(ignored);
                    ctrl.enforceNodesLimit(agents[i]);
                }
            }
        });
        JPanel settings = new JPanel(new GridBagLayout());
        settings.setBorder(new TitledBorder(new EtchedBorder(1), " Tracing Settings "));
        settings.add((Component)this.afp, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        settings.add((Component)clear, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 14, 0, new Insets(2, 4, 2, 2), 0, 0));
        settings.add((Component)apply, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 14, 0, new Insets(2, 2, 2, 4), 0, 0));
        JScrollPane scrollsettings = new JScrollPane(settings);
        scrollsettings.setBorder(null);
        north.add((Component)scrollsettings, "East");
        this.tableSplit.add(north);
        this.tableSplit.add(this.graph);
        this.add(this.tableSplit);
        this.setOneTouchExpandable(true);
        this.setDividerLocation(200);
        this.tableSplit.setDividerLocation(300);
    }

    public JMenuBar createMenuBar() {
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("Agent");
        GuiProperties.setupHelp(menu, "tracer.menu_agent");
        menu.add(new JMenuItem(new AbstractAction("Observe"){

            public void actionPerformed(ActionEvent e) {
                TracerUI.this.ctrl.ignoreAgent(TracerUI.this.getSelectedAgent(), false);
            }

            public boolean isEnabled() {
                return TracerUI.this.getSelectedAgent() != null && !TracerUI.this.getSelectedAgent().getAID().equals(TracerUI.this.ctrl.getAID());
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Observe all"){

            public void actionPerformed(ActionEvent e) {
                TracerUI.this.ctrl.ignoreAll(false);
            }
        }));
        menu.addSeparator();
        menu.add(new JMenuItem(new AbstractAction("Ignore"){

            public void actionPerformed(ActionEvent e) {
                TracerUI.this.ctrl.ignoreAgent(TracerUI.this.getSelectedAgent(), true);
            }

            public boolean isEnabled() {
                return TracerUI.this.getSelectedAgent() != null;
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Ignore all"){

            public void actionPerformed(ActionEvent e) {
                TracerUI.this.ctrl.ignoreAll(true);
            }
        }));
        this.ignoreAtFirst = new JCheckBoxMenuItem(new AbstractAction("Ignore At First"){

            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem cb = (JCheckBoxMenuItem)e.getSource();
                TracerUI.this.ctrl.getPrototype().setIgnored(cb.isSelected());
            }
        });
        this.ignoreAtFirst.setSelected(this.ctrl.getPrototype().isIgnored());
        menu.add(this.ignoreAtFirst);
        menu.addSeparator();
        menu.add(new JMenuItem(new AbstractAction("Show in graph"){

            public void actionPerformed(ActionEvent e) {
                TracerUI.this.graph.showTrace(TracerUI.this.getSelectedAgent(), true);
            }

            public boolean isEnabled() {
                return TracerUI.this.getSelectedAgent() != null;
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Hide from graph"){

            public void actionPerformed(ActionEvent e) {
                TracerUI.this.graph.showEffects(TracerUI.this.getSelectedAgent(), false);
                TracerUI.this.graph.showTrace(TracerUI.this.getSelectedAgent(), false);
            }

            public boolean isEnabled() {
                return TracerUI.this.getSelectedAgent() != null;
            }
        }));
        menu.addSeparator();
        menu.add(new JMenuItem(new AbstractAction("Show in table"){

            public void actionPerformed(ActionEvent e) {
                TAgent node = TracerUI.this.getSelectedAgent();
                if (node != null) {
                    TracerUI.this.table.addTrace(node);
                    TracerUI.this.table.addEffects(node, true);
                }
            }

            public boolean isEnabled() {
                return TracerUI.this.getSelectedAgent() != null;
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Hide from table"){

            public void actionPerformed(ActionEvent e) {
                TAgent node = TracerUI.this.getSelectedAgent();
                if (node != null) {
                    TracerUI.this.table.addEffects(node, false);
                    TracerUI.this.table.removeTrace(node);
                }
            }

            public boolean isEnabled() {
                return TracerUI.this.getSelectedAgent() != null;
            }
        }));
        menu.addSeparator();
        menu.add(new JMenuItem(new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent e) {
                TracerUI.this.ctrl.removeAgent(TracerUI.this.getSelectedAgent());
            }

            public boolean isEnabled() {
                return TracerUI.this.getSelectedAgent() != null;
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Delete dead agents"){

            public void actionPerformed(ActionEvent e) {
                TracerUI.this.ctrl.removeDeathAgents();
            }
        }));
        menu.addSeparator();
        menu.add(this.tree.getFilterMenu());
        menu.add(this.getAgentFilterMenu("Default filter ...", new AgentFilterModel(){

            public TAgent getNode() {
                return TracerUI.this.ctrl.getPrototype();
            }
        }));
        menu.addMenuListener(MENU_ACTIVATOR);
        bar.add(menu);
        menu = new JMenu("Table");
        GuiProperties.setupHelp(menu, "tracer.menu_table");
        menu.add(new JMenuItem(new AbstractAction("Select causes"){

            public void actionPerformed(ActionEvent e) {
                TracerUI.this.table.selectCauses();
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Select effects"){

            public void actionPerformed(ActionEvent e) {
                TracerUI.this.table.selectEffects();
            }
        }));
        menu.addSeparator();
        menu.add(new JMenuItem(new AbstractAction("Show in graph"){

            public void actionPerformed(ActionEvent e) {
                TracerUI.this.graph.showTraces(TracerUI.this.table.getSelected(), true);
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Hide in graph"){

            public void actionPerformed(ActionEvent e) {
                TracerUI.this.graph.showTraces(TracerUI.this.table.getSelected(), false);
            }
        }));
        menu.addSeparator();
        menu.add(new JMenuItem(new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent e) {
                TracerUI.this.table.removeSelected();
            }
        }));
        menu.addSeparator();
        menu.add(new JMenuItem(new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent e) {
                TracerUI.this.ctrl.removeTraces(TracerUI.this.table.getSelected());
            }
        }));
        menu.addSeparator();
        this.autoscroll = new JCheckBoxMenuItem(new AbstractAction("Scroll"){

            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem cb = (JCheckBoxMenuItem)e.getSource();
                TracerUI.this.table.setAutoScroll(cb.isSelected());
            }
        });
        this.autoscroll.setSelected(this.table.isAutoScroll());
        menu.add(this.autoscroll);
        bar.add(menu);
        menu = new JMenu("Graph");
        GuiProperties.setupHelp(menu, "tracer.menu_graph");
        this.graph.fillPopupMenu(menu.getPopupMenu());
        bar.add(menu);
        return bar;
    }

    JMenuItem getAgentFilterMenu(final String title, final AgentFilterModel im) {
        JMenuItem nlimit = new JMenuItem(title);
        nlimit.setAction(new AbstractAction(title){

            public boolean isEnabled() {
                return im.getNode() != null;
            }

            public void actionPerformed(ActionEvent e) {
                if (im.getNode() != null) {
                    JFrame w = new JFrame(title);
                    w.addWindowFocusListener(new WindowFocusListener(this, w){
                        private final /* synthetic */ JFrame val$w;
                        private final /* synthetic */ 23 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$w = val$w;
                        }

                        public void windowGainedFocus(WindowEvent e) {
                        }

                        public void windowLostFocus(WindowEvent e) {
                            this.val$w.setVisible(false);
                        }
                    });
                    JPanel content = new JPanel(new BorderLayout());
                    TracerUI.this.afp = new AgentFilterPanel(im.getNode());
                    content.add(TracerUI.this.afp);
                    content.setBorder(new TitledBorder(new EtchedBorder(1), " Tracing Settings "));
                    w.getContentPane().add(content);
                    w.pack();
                    GuiProperties.setupHelp(w, "tracer.agent_filter");
                    w.setLocationRelativeTo(TracerUI.this);
                    w.setVisible(true);
                }
            }
        });
        return nlimit;
    }

    public void addNode(TNode tn) {
        if (tn.getCauses().equals("top")) {
            tn.addParent(this.root);
        } else {
            this.table.addTrace(tn);
        }
        this.graph.showTrace(tn);
    }

    public void addEdge(TNode from, TNode to) {
        this.graph.tgPanel.addEdge((Edge)new TEdge(from, to));
    }

    public void movedNode(TAgent parent, TNode node, int oldIndex) {
        if (oldIndex >= 0) {
            this.tree.model.nodesWereRemoved(parent, new int[]{oldIndex}, new Object[]{node});
        }
    }

    public void removeNode(TAgent agent) {
        this.hideNode(agent);
        agent.removeParent(this.root);
        this.tree.model.nodeStructureChanged(this.root);
    }

    public void hideNode(TNode node) {
        if (this.table.remove(node)) {
            this.table_model.fireTableDataChanged();
        }
        this.graph.showTrace(node, false);
        this.graph.showEffects(node, false);
    }

    protected TAgent getSelectedAgent() {
        TNode n;
        if (this.selectedAgent == null && this.graph != null && (n = this.graph.getSelected()) instanceof TAgent) {
            this.selectedAgent = (TAgent)n;
            return this.selectedAgent;
        }
        return this.selectedAgent;
    }

    public void valueChanged(TreeSelectionEvent e) {
        TNode node = (TNode)this.tree.getLastSelectedPathComponent();
        this.selectedAgent = node instanceof TAgent ? (TAgent)node : null;
    }

    public void getProperties(Properties ps) {
        ps.setProperty("trace.table_autoscroll", "" + this.table.isAutoScroll());
        ps.setProperty("split.divider", "" + this.getDividerLocation());
        ps.setProperty("tablesplit.divider", "" + this.tableSplit.getDividerLocation());
    }

    public void setProperties(Properties ps) {
        this.table.setAutoScroll("true".equalsIgnoreCase(ps.getProperty("trace.table_autoscroll", "false")));
        if (this.autoscroll != null) {
            this.autoscroll.setSelected(this.table.isAutoScroll());
        }
        if (this.ignoreAtFirst != null) {
            this.ignoreAtFirst.setSelected(this.ctrl.getPrototype().isIgnored());
        }
        this.setDividerLocation(Integer.parseInt(ps.getProperty("split.divider", "200")));
        this.tableSplit.setDividerLocation(Integer.parseInt(ps.getProperty("tablesplit.divider", "300")));
        this.afp.reset();
    }

    public Frame getMainFrame() {
        Container c = this.getParent();
        while (!(c instanceof Frame)) {
            c = c.getParent();
        }
        return (Frame)c;
    }

    public void resetDefaultFilter() {
        this.afp.reset();
    }

    static interface AgentFilterModel {
        public TAgent getNode();
    }

    abstract class AgentFilterCB
    extends JCheckBox {
        AgentFilterCB(String text) {
            super(text);
            this.setAction(new AbstractAction(this, text){
                private final /* synthetic */ AgentFilterCB this$1;
                {
                    this.this$1 = this$1;
                    super(x0);
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.set(!this.this$1.get());
                }
            });
            this.setModel(new DefaultButtonModel(this){
                private final /* synthetic */ AgentFilterCB this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isSelected() {
                    return this.this$1.get();
                }
            });
        }

        abstract void set(boolean var1);

        abstract boolean get();
    }
}

