/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer.ui;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.tools.tracer.nodes.TAgent;
import jadex.tools.tracer.nodes.TNode;
import jadex.tools.tracer.nodes.TNodeListener;
import jadex.tools.tracer.ui.TracerUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.DefaultButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TraceTree
extends JTree
implements MouseListener,
TNodeListener {
    protected final DefaultTreeModel model;
    protected final JPopupMenu popup;
    protected final TracerUI tracerUI;

    protected TraceTree(TNode root, TracerUI ui) {
        super(new DefaultTreeModel(root));
        root.addListener(this);
        this.model = (DefaultTreeModel)this.getModel();
        this.setRootVisible(false);
        this.setCellRenderer(new TraceCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.tracerUI = ui;
        this.popup = new JPopupMenu();
        this.addMenuItems(this.popup);
        this.addMouseListener(this);
    }

    protected void addMenuItems(JPopupMenu menu) {
        menu.add(new AgentNodeButton("Observe Agent"){

            void set(TAgent a, boolean flag) {
                TraceTree.this.tracerUI.ctrl.ignoreAgent(a, !flag);
            }

            boolean get(TAgent a) {
                return !a.isIgnored();
            }
        });
        menu.add(this.getFilterMenu());
        menu.addSeparator();
        menu.add(new JMenuItem(new AbstractAction("Show in graph"){

            public void actionPerformed(ActionEvent e) {
                TNode node = (TNode)TraceTree.this.getLastSelectedPathComponent();
                if (node != null) {
                    TraceTree.this.tracerUI.graph.showTrace(node, true);
                    TraceTree.this.tracerUI.graph.showEffects(node, true);
                }
            }

            public boolean isEnabled() {
                return TraceTree.this.getLastSelectedPathComponent() != null;
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Hide from graph"){

            public void actionPerformed(ActionEvent e) {
                TNode node = (TNode)TraceTree.this.getLastSelectedPathComponent();
                if (node != null) {
                    TraceTree.this.tracerUI.graph.showEffects(node, false);
                    TraceTree.this.tracerUI.graph.showTrace(node, false);
                }
            }

            public boolean isEnabled() {
                return TraceTree.this.getLastSelectedPathComponent() != null;
            }
        }));
        menu.addSeparator();
        menu.add(new JMenuItem(new AbstractAction("Show in table"){

            public void actionPerformed(ActionEvent e) {
                TNode node = (TNode)TraceTree.this.getLastSelectedPathComponent();
                if (node != null) {
                    TraceTree.this.tracerUI.table.addTrace(node);
                    TraceTree.this.tracerUI.table.addEffects(node, true);
                }
            }

            public boolean isEnabled() {
                return TraceTree.this.getLastSelectedPathComponent() != null;
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Hide from table"){

            public void actionPerformed(ActionEvent e) {
                TNode node = (TNode)TraceTree.this.getLastSelectedPathComponent();
                if (node != null) {
                    TraceTree.this.tracerUI.table.addEffects(node, false);
                    TraceTree.this.tracerUI.table.removeTrace(node);
                }
            }

            public boolean isEnabled() {
                return TraceTree.this.getLastSelectedPathComponent() != null;
            }
        }));
        menu.addSeparator();
        menu.add(new JMenuItem(new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent e) {
                TNode node = (TNode)TraceTree.this.getLastSelectedPathComponent();
                if (node != null) {
                    TraceTree.this.tracerUI.ctrl.removeTrace(node);
                }
            }

            public boolean isEnabled() {
                return TraceTree.this.getLastSelectedPathComponent() != null;
            }
        }));
    }

    public JMenuItem getFilterMenu() {
        return this.tracerUI.getAgentFilterMenu("Filter", new TracerUI.AgentFilterModel(){

            public TAgent getNode() {
                Object node = TraceTree.this.getLastSelectedPathComponent();
                if (node instanceof TAgent) {
                    return (TAgent)node;
                }
                return null;
            }
        });
    }

    protected void showPopUp(int x, int y) {
        TreePath sel = this.getClosestPathForLocation(x, y);
        if (sel != null) {
            this.setSelectionPath(sel);
        }
        Component[] me = this.popup.getComponents();
        int i = me.length;
        while (i-- > 0) {
            if (!(me[i] instanceof JMenuItem)) continue;
            JMenuItem mi = (JMenuItem)me[i];
            if (mi.getAction() != null) {
                mi.setEnabled(mi.getAction().isEnabled());
                continue;
            }
            mi.setEnabled(mi.isEnabled());
        }
        this.popup.show(this, x, y);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopUp(e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopUp(e.getX(), e.getY());
        }
    }

    public void nodeChanged(TNode caller) {
        this.model.nodeChanged(caller);
    }

    public void nodeDeleted(TNode caller) {
        caller.removeListener(this);
    }

    public void childAdded(TNode caller, TNode node) {
        int ci = caller.childIndex(node);
        if (ci >= 0) {
            this.model.nodesWereInserted(caller, new int[]{ci});
        }
        if (caller.isRoot()) {
            this.expandPath(new TreePath(caller));
        }
        node.addListener(this);
    }

    public void parentAdded(TNode caller, TNode node) {
    }

    public void childRemoved(TNode caller, TNode node, int ci) {
        if (ci >= 0) {
            this.model.nodesWereRemoved(caller, new int[]{ci}, new Object[]{node});
        }
    }

    public void parentRemoved(TNode caller, TNode node, int index) {
    }

    class TraceCellRenderer
    extends DefaultTreeCellRenderer {
        TraceCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TNode tn = (TNode)value;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (tn.isRoot()) {
                this.setText("");
            } else {
                this.setIcon(tn.getIcon());
                this.setText(tn.getName());
                this.setToolTipText(tn.getToolTip());
            }
            return this;
        }
    }

    abstract class AgentNodeButton
    extends JCheckBoxMenuItem {
        AgentNodeButton(String text) {
            super(text);
            this.setAction(new AbstractAction(this, text){
                private final /* synthetic */ AgentNodeButton this$1;
                {
                    this.this$1 = this$1;
                    super(x0);
                }

                public void actionPerformed(ActionEvent e) {
                    Object node = AgentNodeButton.access$000(this.this$1).getLastSelectedPathComponent();
                    if (node instanceof TAgent) {
                        TAgent a;
                        this.this$1.set(a, !this.this$1.get(a = (TAgent)node));
                        if (!a.isIgnored()) {
                            AgentNodeButton.access$000((AgentNodeButton)this.this$1).tracerUI.ctrl.ignoreAgent(a, false);
                        }
                    }
                }
            });
            this.setModel(new DefaultButtonModel(this){
                private final /* synthetic */ AgentNodeButton this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isSelected() {
                    Object node = AgentNodeButton.access$000(this.this$1).getLastSelectedPathComponent();
                    return node instanceof TAgent && this.this$1.get((TAgent)node);
                }

                public boolean isEnabled() {
                    Object node = AgentNodeButton.access$000(this.this$1).getLastSelectedPathComponent();
                    if (node instanceof TAgent) {
                        AgentIdentifier aid = ((TAgent)node).getAID();
                        return !aid.equals(AgentNodeButton.access$000((AgentNodeButton)this.this$1).tracerUI.ctrl.getAID());
                    }
                    return false;
                }
            });
        }

        abstract void set(TAgent var1, boolean var2);

        abstract boolean get(TAgent var1);

        static /* synthetic */ TraceTree access$000(AgentNodeButton x0) {
            return x0.TraceTree.this;
        }
    }
}

