/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer.ui;

import jadex.tools.tracer.nodes.TNode;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class TraceTableModel
extends AbstractTableModel {
    public static final int SEQ = 0;
    public static final int AGENT = 1;
    public static final int NAME = 2;
    public static final int VALUE = 3;
    public static final int CAUSE = 4;
    public static final int TIME = 5;
    private final List traces = new Vector();

    protected TraceTableModel() {
    }

    public int getRowCount() {
        return this.traces.size();
    }

    public int getColumnCount() {
        return 6;
    }

    public String getColumnName(int c) {
        switch (c) {
            case 0: {
                return "#";
            }
            case 1: {
                return "Agent";
            }
            case 2: {
                return "Name";
            }
            case 3: {
                return "Content";
            }
            case 4: {
                return "Cause";
            }
            case 5: {
                return "Time";
            }
        }
        return "?!";
    }

    public synchronized Object getValueAt(int r, int c) {
        if (r >= 0 && r < this.traces.size()) {
            return (TNode)this.traces.get(r);
        }
        return null;
    }

    public Class getColumnClass(int c) {
        return String.class;
    }

    public synchronized TNode[] getTraces(int[] rows) {
        int i = rows.length;
        TNode[] ts = new TNode[i];
        while (i-- > 0) {
            int s = rows[i];
            if (s < 0 || s >= this.traces.size()) continue;
            ts[i] = (TNode)this.traces.get(rows[i]);
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(TNode node) {
        int row;
        boolean fire = false;
        TraceTableModel traceTableModel = this;
        synchronized (traceTableModel) {
            row = this.traces.indexOf(node);
            if (row >= 0) {
                this.traces.remove(node);
                fire = true;
            }
        }
        if (fire) {
            this.fireTableRowsDeleted(row, row);
        }
        return fire;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(TNode node) {
        int row;
        boolean fire = false;
        TraceTableModel traceTableModel = this;
        synchronized (traceTableModel) {
            if (!this.traces.contains(node)) {
                row = this.traces.size();
                this.traces.add(node);
                fire = true;
            } else {
                row = -1;
            }
        }
        if (fire) {
            this.fireTableRowsInserted(row, row);
        }
        return fire;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRows(int[] sel) {
        TraceTableModel traceTableModel = this;
        synchronized (traceTableModel) {
            int i = sel.length;
            while (i-- > 0) {
                this.traces.remove(sel[i]);
            }
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TNode[] getAllTraces() {
        TraceTableModel traceTableModel = this;
        synchronized (traceTableModel) {
            return this.traces.toArray(new TNode[this.traces.size()]);
        }
    }

    public synchronized TNode get(int i) {
        if (i >= 0 && i < this.traces.size()) {
            return (TNode)this.traces.get(i);
        }
        return null;
    }

    public int indexOf(TNode effect) {
        return this.traces.indexOf(effect);
    }
}

