/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer.ui;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.tools.tracer.nodes.TAbstractC;
import jadex.tools.tracer.nodes.TBelief;
import jadex.tools.tracer.nodes.TNode;
import jadex.tools.tracer.nodes.TNodeListener;
import jadex.tools.tracer.ui.LookAndFeel;
import jadex.tools.tracer.ui.TraceTableModel;
import jadex.tools.tracer.ui.TracerUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class TraceTable
extends JTable
implements MouseListener,
TNodeListener {
    protected final JPopupMenu popup;
    protected final TracerUI ui;
    protected boolean autoScroll = true;
    protected final TraceTableModel model;

    public TraceTable(TraceTableModel model, TracerUI ui) {
        super(model);
        this.model = model;
        this.ui = ui;
        this.setDefaultRenderer(String.class, new TraceTableRenderer());
        TableColumnModel cm = this.getColumnModel();
        Dimension d = new Dimension(420, 100);
        this.setMinimumSize(d);
        this.setPreferredScrollableViewportSize(d);
        cm.getColumn(0).setPreferredWidth(10);
        cm.getColumn(1).setPreferredWidth(50);
        cm.getColumn(2).setPreferredWidth(40);
        cm.getColumn(3).setPreferredWidth(200);
        cm.getColumn(4).setPreferredWidth(80);
        cm.getColumn(5).setPreferredWidth(40);
        this.setSelectionBackground(LookAndFeel.SELECT_COLOR);
        this.popup = new JPopupMenu();
        this.addMenuItems(this.popup);
        this.addMouseListener(this);
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    protected void addMenuItems(JPopupMenu menu) {
        menu.add(new JMenuItem(new AbstractAction("Select causes"){

            public void actionPerformed(ActionEvent e) {
                TraceTable.this.selectCauses();
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Select effects"){

            public void actionPerformed(ActionEvent e) {
                TraceTable.this.selectEffects();
            }
        }));
        menu.addSeparator();
        menu.add(new JMenuItem(new AbstractAction("Show in graph"){

            public void actionPerformed(ActionEvent e) {
                TraceTable.this.ui.graph.showTraces(TraceTable.this.getSelected(), true);
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Hide from graph"){

            public void actionPerformed(ActionEvent e) {
                TraceTable.this.ui.graph.showTraces(TraceTable.this.getSelected(), false);
            }
        }));
        menu.addSeparator();
        menu.add(new JMenuItem(new AbstractAction("Remove from table"){

            public void actionPerformed(ActionEvent e) {
                TraceTable.this.removeSelected();
            }
        }));
        menu.addSeparator();
        menu.add(new JMenuItem(new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent e) {
                TraceTable.this.ui.ctrl.removeTraces(TraceTable.this.getSelected());
            }
        }));
    }

    public boolean remove(TNode node) {
        return this.model.remove(node);
    }

    public TNode[] getSelected() {
        return this.model.getTraces(this.getSelectedRows());
    }

    public void removeSelected() {
        this.model.removeRows(this.getSelectedRows());
    }

    public synchronized void selectEffects() {
        int[] sel = this.getSelectedRows();
        int i = sel.length;
        while (i-- > 0) {
            TNode tn = this.model.get(sel[i]);
            if (tn == null) continue;
            TNode[] ch = tn.getChildren();
            int chI = ch.length;
            while (chI-- > 0) {
                TNode effect = ch[chI];
                int j = this.model.indexOf(effect);
                if (j < 0) continue;
                this.addRowSelectionInterval(j, j);
            }
        }
    }

    public synchronized void selectCauses() {
        int[] sel = this.getSelectedRows();
        int i = sel.length;
        while (i-- > 0) {
            TNode tn = this.model.get(sel[i]);
            if (tn == null) continue;
            TNode[] ps = tn.getParents();
            int pi = ps.length;
            while (pi-- > 0) {
                TNode cause = ps[pi];
                int j = this.model.indexOf(cause);
                if (j < 0) continue;
                this.addRowSelectionInterval(j, j);
            }
        }
    }

    public boolean addTrace(TNode node) {
        if (node.isRoot() || node.isAgent() || node instanceof TBelief) {
            return false;
        }
        if (this.model.add(node)) {
            node.addListener(this);
            return true;
        }
        return false;
    }

    public void removeTrace(TNode node) {
        this.model.remove(node);
        node.removeListener(this);
    }

    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (this.autoScroll) {
            JViewport viewport = (JViewport)this.getParent();
            Rectangle cellRect = this.getCellRect(this.dataModel.getRowCount() - 1, -1, true);
            Rectangle viewRect = viewport.getViewRect();
            cellRect.setLocation(cellRect.x - viewRect.x, cellRect.y - viewRect.y);
            cellRect.x = 0;
            viewport.scrollRectToVisible(cellRect);
        }
    }

    public void addEffects(TNode node, boolean b) {
        if (b) {
            int end = this.dataModel.getRowCount();
            this.showEffectsRec(node);
            ((TraceTableModel)this.dataModel).fireTableRowsInserted(end, this.dataModel.getRowCount() - 1);
        } else {
            this.removeEffectsRec(node);
            ((TraceTableModel)this.dataModel).fireTableDataChanged();
        }
    }

    private void removeEffectsRec(TNode node) {
        TNode[] effects = node.getChildren();
        int i = effects.length;
        while (i-- > 0) {
            TNode eff = effects[i];
            if (!this.model.remove(eff)) continue;
            this.removeEffectsRec(eff);
        }
    }

    private void showEffectsRec(TNode node) {
        TNode[] effects = node.getChildren();
        int i = effects.length;
        while (i-- > 0) {
            TNode eff = effects[i];
            if (!this.addTrace(eff)) continue;
            this.showEffectsRec(eff);
        }
    }

    private void showPopUp(int x, int y) {
        this.popup.show(this, x, y);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopUp(e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopUp(e.getX(), e.getY());
        }
    }

    public void childAdded(TNode caller, TNode node) {
    }

    public void parentAdded(TNode caller, TNode node) {
    }

    public void nodeChanged(TNode caller) {
    }

    public void nodeDeleted(TNode caller) {
        this.removeTrace(caller);
    }

    public void childRemoved(TNode caller, TNode node, int index) {
    }

    public void parentRemoved(TNode caller, TNode node, int index) {
    }

    class TraceTableRenderer
    extends DefaultTableCellRenderer {
        TraceTableRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int r, int c) {
            super.getTableCellRendererComponent(table, value, selected, hasFocus, r, c);
            TNode tn = (TNode)value;
            this.setIcon(null);
            this.setHorizontalAlignment(2);
            if (tn != null) {
                switch (c) {
                    case 0: {
                        this.setHorizontalAlignment(4);
                        this.setToolTipText(tn.getToolTip());
                        this.setText(Long.toString(tn.getSeq()));
                        break;
                    }
                    case 1: {
                        AgentIdentifier aid = tn.getAID();
                        this.setText(aid != null ? aid.getName() : "na");
                        this.setToolTipText(this.getText());
                        break;
                    }
                    case 2: {
                        this.setIcon(tn.getIcon());
                        this.setToolTipText(tn.getTraceType() + ": " + tn.getName());
                        this.setText(tn.getName());
                        break;
                    }
                    case 3: {
                        if (tn instanceof TAbstractC) {
                            this.setText(tn.trace.getValue());
                            this.setToolTipText(((TAbstractC)tn).getMsg());
                            break;
                        }
                        if (tn.trace == null) break;
                        this.setText(tn.trace.getValue());
                        this.setToolTipText(this.getText());
                        break;
                    }
                    case 4: {
                        this.setText(tn.getCauses());
                        this.setToolTipText(this.getText());
                        break;
                    }
                    case 5: {
                        this.setText(tn.getTime());
                        this.setToolTipText(this.getText());
                    }
                }
            }
            return this;
        }
    }
}

