/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer.ui;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPanel;
import jadex.tools.tracer.nodes.TRead;
import jadex.tools.tracer.ui.LookAndFeel;
import java.awt.Color;
import java.awt.Graphics;

public class TEdge
extends Edge {
    protected final int[] tX = new int[3];
    protected final int[] tY = new int[3];
    static final Color BRIGHTER_COLOR = LookAndFeel.EDGE_COLOR.brighter();

    public TEdge(Node f, Node t, int len) {
        super(f, t, len);
    }

    public TEdge(Node f, Node t) {
        super(f, t);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Edge) {
            Edge e = (Edge)obj;
            return e.from == this.from && e.to == this.to;
        }
        return false;
    }

    public void paintArrow(Graphics g, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double d = Math.sqrt(dx * dx + dy * dy) / 2.3;
        if (d > 1.0) {
            this.tX[0] = (int)(x1 + (dy /= d));
            this.tY[0] = (int)(y1 - (dx /= d));
            this.tX[1] = (int)(x1 - dy);
            this.tY[1] = (int)(y1 + dx);
            this.tX[2] = (int)x2;
            this.tY[2] = (int)y2;
            g.fillPolygon(this.tX, this.tY, 3);
            g.setColor(BRIGHTER_COLOR);
            g.drawLine(this.tX[0], this.tY[0], this.tX[2], this.tY[2]);
            g.drawLine(this.tX[1], this.tY[1], this.tX[2], this.tY[2]);
        }
    }

    public void paint(Graphics g, TGPanel tgPanel) {
        if (this.intersects(tgPanel.getSize())) {
            if (tgPanel.getMouseOverE() == this) {
                g.setColor(LookAndFeel.EDGE_SELECT_COLOR);
            } else {
                g.setColor(LookAndFeel.EDGE_COLOR);
            }
            if (this.to instanceof TRead) {
                this.paintArrow(g, this.to.drawx, this.to.drawy, this.from.drawx, this.from.drawy);
            } else {
                this.paintArrow(g, this.from.drawx, this.from.drawy, this.to.drawx, this.to.drawy);
            }
        }
    }

    public String toString() {
        return "Edge(" + this.from + ", " + this.to + ")";
    }
}

