/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer.ui;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.DragNodeUI;
import com.touchgraph.graphlayout.interaction.LocalityScroll;
import com.touchgraph.graphlayout.interaction.TGAbstractClickUI;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import jadex.tools.tracer.ui.GraphPanel;
import jadex.util.SGUI;
import jadex.util.SUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class NavigateUI
extends MouseAdapter {
    protected final GraphPanel gPanel;
    protected final TGPanel tgPanel;
    TGAbstractDragUI hvDragUI;
    TGAbstractDragUI rotateDragUI;
    TGAbstractClickUI hvScrollToCenterUI;
    DragNodeUI dragNodeUI;
    LocalityScroll localityScroll;
    JPopupMenu nodePopup;
    JPopupMenu edgePopup;
    Node popupNode;
    Edge popupEdge;

    public NavigateUI(GraphPanel gPanel) {
        this.gPanel = gPanel;
        this.tgPanel = gPanel.tgPanel;
        this.localityScroll = gPanel.localityScroll;
        this.hvDragUI = gPanel.hvScroll.getHVDragUI();
        this.rotateDragUI = gPanel.rotateScroll.getRotateDragUI();
        this.hvScrollToCenterUI = gPanel.hvScroll.getHVScrollToCenterUI();
        this.dragNodeUI = new DragNodeUI(this.tgPanel);
        this.setUpNodePopup();
        this.setUpEdgePopup();
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.triggerPopup(e);
        } else {
            Node mouseOverN = this.tgPanel.getMouseOverN();
            if (e.getModifiers() == 16) {
                if (mouseOverN == null) {
                    this.hvDragUI.activate(e);
                } else {
                    this.dragNodeUI.activate(e);
                }
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        Node mouseOverN = this.tgPanel.getMouseOverN();
        if (e.getModifiers() == 16 && mouseOverN != null) {
            this.tgPanel.setSelect(mouseOverN);
            try {
                this.tgPanel.setLocale(mouseOverN, this.localityScroll.getLocalityRadius());
            }
            catch (TGException ex) {
                String failed = SUtil.wrapText((String)("Error setting locale\n\n" + ex.getMessage()));
                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this.tgPanel), failed, "Locale Error", 0);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.triggerPopup(e);
        }
    }

    private void triggerPopup(MouseEvent e) {
        this.popupNode = this.tgPanel.getMouseOverN();
        this.popupEdge = this.tgPanel.getMouseOverE();
        if (this.popupNode != null) {
            this.tgPanel.setMaintainMouseOver(true);
            this.tgPanel.setSelect(this.popupNode);
            this.nodePopup.show(e.getComponent(), e.getX(), e.getY());
        } else if (this.popupEdge != null) {
            this.tgPanel.setMaintainMouseOver(true);
            this.edgePopup.show(e.getComponent(), e.getX(), e.getY());
        } else {
            this.gPanel.glPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void setUpNodePopup() {
        JPopupMenu menu = new JPopupMenu();
        this.gPanel.fillPopupMenu(menu);
        menu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                NavigateUI.this.tgPanel.setMaintainMouseOver(false);
                NavigateUI.this.tgPanel.setMouseOverN(null);
                NavigateUI.this.tgPanel.repaint();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        this.nodePopup = menu;
    }

    private void setUpEdgePopup() {
        this.edgePopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Hide Edge");
        ActionListener hideAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (NavigateUI.this.popupEdge != null) {
                    NavigateUI.this.tgPanel.hideEdge(NavigateUI.this.popupEdge);
                }
            }
        };
        menuItem.addActionListener(hideAction);
        this.edgePopup.add(menuItem);
        this.edgePopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                NavigateUI.this.tgPanel.setMaintainMouseOver(false);
                NavigateUI.this.tgPanel.setMouseOverE(null);
                NavigateUI.this.tgPanel.repaint();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
    }
}

