/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer.ui;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.GraphListener;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGAbstractLens;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGLensSet;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.graphelements.TGForEachEdge;
import com.touchgraph.graphlayout.graphelements.TGForEachNode;
import com.touchgraph.graphlayout.interaction.HVScroll;
import com.touchgraph.graphlayout.interaction.LocalityScroll;
import com.touchgraph.graphlayout.interaction.RotateScroll;
import com.touchgraph.graphlayout.interaction.ZoomScroll;
import jadex.tools.common.SelectAction;
import jadex.tools.tracer.nodes.TAbstractC;
import jadex.tools.tracer.nodes.TAction;
import jadex.tools.tracer.nodes.TBelief;
import jadex.tools.tracer.nodes.TBeliefAccess;
import jadex.tools.tracer.nodes.TNode;
import jadex.tools.tracer.nodes.TNodeListener;
import jadex.tools.tracer.nodes.TSend;
import jadex.tools.tracer.ui.NavigateUI;
import jadex.tools.tracer.ui.TEdge;
import jadex.tools.tracer.ui.TracerUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.ToolTipManager;

public class GraphPanel
extends JPanel
implements MouseWheelListener,
TNodeListener {
    public static final String zoomLabel = "Zoom";
    public static final String rotateLabel = "Rotate";
    public static final String localityLabel = "Locality";
    public HVScroll hvScroll;
    public ZoomScroll zoomScroll;
    public RotateScroll rotateScroll;
    public LocalityScroll localityScroll;
    protected JScrollBar currentSB;
    public JPopupMenu glPopup;
    public Map scrollBarHash;
    protected TGPanel tgPanel;
    protected TGLensSet tgLensSet;
    protected final TracerUI ui;
    protected SelectAction JOIN_BELIEFS = new SelectAction("Join Beliefs"){

        public void flagChanged(boolean flag) {
            GraphPanel.this.join_beliefs(flag);
        }
    };
    protected SelectAction JOIN_MESSAGES = new SelectAction("Join Messages"){

        public void flagChanged(boolean flag) {
            GraphPanel.this.join_messages(flag);
        }
    };
    protected SelectAction LABEL_VIEW = new SelectAction("Labels"){

        public void flagChanged(boolean flag) {
            GraphPanel.this.tgPanel.repaint();
        }
    };

    public GraphPanel(TracerUI ui) {
        this.ui = ui;
        this.scrollBarHash = new Hashtable();
        this.tgLensSet = new TGLensSet();
        this.tgPanel = new TTGPanel();
        this.hvScroll = new HVScroll(this.tgPanel, this.tgLensSet);
        this.zoomScroll = new ZoomScroll(this.tgPanel);
        this.rotateScroll = new RotateScroll(this.tgPanel);
        this.localityScroll = new LocalityScroll(this.tgPanel);
        this.localityScroll.setLocalityRadius(10);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.tgPanel);
        this.buildPanel();
        this.tgLensSet.addLens((TGAbstractLens)this.hvScroll.getLens());
        this.tgLensSet.addLens((TGAbstractLens)this.zoomScroll.getLens());
        this.tgLensSet.addLens((TGAbstractLens)this.rotateScroll.getLens());
        this.tgLensSet.addLens((TGAbstractLens)this.tgPanel.getAdjustOriginLens());
        this.tgPanel.setLensSet(this.tgLensSet);
        this.tgPanel.addMouseListener((MouseListener)new NavigateUI(this));
        this.tgPanel.addMouseWheelListener((MouseWheelListener)this);
        this.setVisible(true);
    }

    public void buildPanel() {
        final JScrollBar horizontalSB = this.hvScroll.getHorizontalSB();
        final JScrollBar verticalSB = this.hvScroll.getVerticalSB();
        JScrollBar zoomSB = this.zoomScroll.getZoomSB();
        JScrollBar rotateSB = this.rotateScroll.getRotateSB();
        JScrollBar localitySB = this.localityScroll.getLocalitySB();
        this.setLayout(new BorderLayout());
        JPanel scrollPanel = new JPanel();
        scrollPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        final JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 1;
        c.weightx = 1.0;
        this.scrollBarHash.put(zoomLabel, zoomSB);
        this.scrollBarHash.put(rotateLabel, rotateSB);
        this.scrollBarHash.put(localityLabel, localitySB);
        JPanel scrollselect = this.scrollSelectPanel(new String[]{zoomLabel, rotateLabel, localityLabel});
        topPanel.add((Component)scrollselect, c);
        this.add((Component)topPanel, "North");
        c.fill = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        scrollPanel.add((Component)this.tgPanel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        scrollPanel.add((Component)verticalSB, c);
        c.gridx = 0;
        c.gridy = 2;
        scrollPanel.add((Component)horizontalSB, c);
        this.add((Component)scrollPanel, "Center");
        this.glPopup = new JPopupMenu();
        this.fillPopupMenu(this.glPopup);
        this.glPopup.addSeparator();
        this.glPopup.add(new JMenuItem(new AbstractAction("Toggle Controls"){
            boolean controlsVisible;
            {
                super(x0);
                this.controlsVisible = true;
            }

            public void actionPerformed(ActionEvent e) {
                this.controlsVisible = !this.controlsVisible;
                horizontalSB.setVisible(this.controlsVisible);
                verticalSB.setVisible(this.controlsVisible);
                topPanel.setVisible(this.controlsVisible);
            }
        }));
    }

    public void fillPopupMenu(JPopupMenu menu) {
        JMenu submenu = new JMenu("Show");
        submenu.add(new JMenuItem(new AbstractAction("Actions"){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.showActions(true);
            }
        }));
        submenu.add(new JMenuItem(new AbstractAction("Beliefs"){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.showBeliefs(true);
            }
        }));
        submenu.add(new JMenuItem(new AbstractAction("Messages"){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.showMessages(true);
            }
        }));
        submenu.addSeparator();
        submenu.add(new JMenuItem(new AbstractAction("Trace causes"){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.showCauses(true);
            }

            public boolean isEnabled() {
                return GraphPanel.this.getSelected() != null;
            }
        }));
        submenu.add(new JMenuItem(new AbstractAction("Trace effects"){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.showEffects(true);
            }

            public boolean isEnabled() {
                return GraphPanel.this.getSelected() != null;
            }
        }));
        submenu.addMenuListener(TracerUI.MENU_ACTIVATOR);
        menu.add(submenu);
        submenu = new JMenu("Hide");
        submenu.add(new JMenuItem(new AbstractAction("Actions"){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.showActions(false);
            }
        }));
        submenu.add(new JMenuItem(new AbstractAction("Beliefs"){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.showBeliefs(false);
            }
        }));
        submenu.add(new JMenuItem(new AbstractAction("Send Events"){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.showMessages(false);
            }
        }));
        submenu.addSeparator();
        submenu.add(new JMenuItem(new AbstractAction("Trace"){

            public void actionPerformed(ActionEvent e) {
                TNode n = GraphPanel.this.getSelected();
                GraphPanel.this.showEffects(n, false);
                GraphPanel.this.showTrace(n, false);
            }

            public boolean isEnabled() {
                return GraphPanel.this.getSelected() != null;
            }
        }));
        submenu.add(new JMenuItem(new AbstractAction("Trace causes"){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.showCauses(false);
            }

            public boolean isEnabled() {
                return GraphPanel.this.getSelected() != null;
            }
        }));
        submenu.add(new JMenuItem(new AbstractAction("Trace effects"){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.showEffects(false);
            }

            public boolean isEnabled() {
                return GraphPanel.this.getSelected() != null;
            }
        }));
        submenu.addMenuListener(TracerUI.MENU_ACTIVATOR);
        menu.add(submenu);
        menu.addSeparator();
        menu.add(new JMenuItem(new AbstractAction("Expand"){

            public void actionPerformed(ActionEvent e) {
                TNode n = GraphPanel.this.getSelected();
                if (n != null) {
                    GraphPanel.this.tgPanel.expandNode((Node)n);
                }
            }

            public boolean isEnabled() {
                return GraphPanel.this.getSelected() != null;
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Collapse"){

            public void actionPerformed(ActionEvent e) {
                TNode n = GraphPanel.this.getSelected();
                if (n != null) {
                    GraphPanel.this.tgPanel.collapseNode((Node)n);
                }
            }

            public boolean isEnabled() {
                return GraphPanel.this.getSelected() != null;
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent e) {
                TNode n = GraphPanel.this.getSelected();
                if (n != null) {
                    GraphPanel.this.ui.ctrl.removeTrace(n);
                }
            }

            public boolean isEnabled() {
                return GraphPanel.this.getSelected() != null;
            }
        }));
        menu.addSeparator();
        menu.add(this.JOIN_BELIEFS.getCBItem());
        menu.add(this.JOIN_MESSAGES.getCBItem());
        menu.addSeparator();
        menu.add(this.LABEL_VIEW.getCBItem());
        menu.addPopupMenuListener(TracerUI.PMENU_ACTIVATOR);
    }

    protected JPanel scrollSelectPanel(String[] scrollBarNames) {
        final JComboBox<String> scrollCombo = new JComboBox<String>(scrollBarNames);
        scrollCombo.setPreferredSize(new Dimension(80, 20));
        scrollCombo.setSelectedIndex(0);
        this.currentSB = (JScrollBar)this.scrollBarHash.get(scrollBarNames[0]);
        scrollCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JScrollBar selectedSB = (JScrollBar)GraphPanel.this.scrollBarHash.get(scrollCombo.getSelectedItem());
                if (GraphPanel.this.currentSB != null) {
                    GraphPanel.this.currentSB.setVisible(false);
                }
                if (selectedSB != null) {
                    selectedSB.setVisible(true);
                }
                GraphPanel.this.currentSB = selectedSB;
            }
        });
        JPanel sbp = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        sbp.add(scrollCombo, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 10, 0, 17);
        c.fill = 2;
        for (int i = 0; i < scrollBarNames.length; ++i) {
            JScrollBar sb = (JScrollBar)this.scrollBarHash.get(scrollBarNames[i]);
            if (sb == null) continue;
            if (i != 0) {
                sb.setVisible(false);
            }
            sbp.add((Component)sb, c);
        }
        return sbp;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.currentSB.setValue(this.currentSB.getValue() - e.getWheelRotation());
    }

    public TNode getSelected() {
        return (TNode)this.tgPanel.getSelect();
    }

    private void addNode(TNode n) {
        if (this.JOIN_BELIEFS.isSelected()) {
            if (n instanceof TBeliefAccess) {
                TBeliefAccess ba = (TBeliefAccess)n;
                this.addNode(ba.getBeliefNode());
                return;
            }
        } else if (n instanceof TBelief) {
            this.showTraces(n.getChildren());
            return;
        }
        try {
            this.tgPanel.addNode((Node)n);
            Iterator it = n.parents();
            while (it.hasNext()) {
                TNode parent = (TNode)it.next();
                if (!parent.isVisible() || parent instanceof TBelief) continue;
                TEdge e = new TEdge(parent, n);
                this.tgPanel.addEdge((Edge)e);
            }
            if (!(n instanceof TBelief)) {
                Enumeration elems = n.children();
                while (elems.hasMoreElements()) {
                    TNode child = (TNode)elems.nextElement();
                    if (!child.isVisible()) continue;
                    TEdge e = new TEdge(n, child);
                    this.tgPanel.addEdge((Edge)e);
                }
            }
            n.addListener(this);
            if (this.JOIN_MESSAGES.isSelected() && n.isCommunication()) {
                List al = this.ui.ctrl.getComms(n.getName());
                if (al != null && al.size() > 0) {
                    if (n instanceof TSend) {
                        int i = al.size();
                        while (i-- > 1) {
                            TNode rcv = (TNode)al.get(i);
                            if (n == rcv || !rcv.isVisible()) continue;
                            this.tgPanel.addEdge((Edge)new TEdge(n, rcv, TEdge.DEFAULT_LENGTH * 3));
                        }
                    } else {
                        TNode tn = (TNode)al.get(0);
                        if (tn instanceof TSend && tn.isVisible()) {
                            this.tgPanel.addEdge((Edge)new TEdge(tn, n, TEdge.DEFAULT_LENGTH * 3));
                        }
                    }
                }
            } else if (this.JOIN_BELIEFS.isSelected() && n instanceof TBelief) {
                TBelief bel = (TBelief)n;
                TNode[] bs = bel.getChildren();
                int bi = bs.length;
                while (bi-- > 0) {
                    TNode[] ps = bs[bi].getParents();
                    int pi = ps.length;
                    while (pi-- > 0) {
                        TNode p = ps[pi];
                        if (!p.isVisible()) continue;
                        TEdge edge = new TEdge(p, bel);
                        this.tgPanel.addEdge((Edge)edge);
                    }
                }
            }
        }
        catch (TGException tGException) {
            // empty catch block
        }
    }

    public void showTrace(TNode tn) {
        if (tn.hasVisibleParents()) {
            this.addNode(tn);
        }
    }

    private void showTraces(TNode[] ns) {
        int i = ns.length;
        while (i-- > 0) {
            this.showTrace(ns[i]);
        }
    }

    public void showTrace(TNode node, boolean b) {
        if (node == null || node.getName() == "top") {
            return;
        }
        if (b) {
            this.addNode(node);
        } else {
            node.removeListener(this);
            node.setVisible(false);
            this.tgPanel.deleteNode((Node)node);
        }
    }

    protected void showTraces(TNode[] nodes, boolean b) {
        int i = nodes.length;
        while (i-- > 0) {
            this.showTrace(nodes[i], b);
        }
    }

    protected void showEffects(TNode tn, boolean b) {
        if (tn == null) {
            return;
        }
        TNode[] cs = tn.getChildren();
        int ci = cs.length;
        while (ci-- > 0) {
            TNode n = cs[ci];
            if (b && !this.JOIN_BELIEFS.isSelected() && n instanceof TBelief) continue;
            this.showTrace(n, b);
            this.showEffects(n, b);
        }
    }

    protected void showEffects(boolean b) {
        this.showEffects((TNode)this.tgPanel.getSelect(), b);
    }

    protected void showCauses(TNode tn, boolean b) {
        if (tn == null) {
            return;
        }
        TNode[] ps = tn.getParents();
        int pi = ps.length;
        while (pi-- > 0) {
            TNode n = ps[pi];
            this.showTrace(n, b);
            if (b) {
                this.showCauses(n, true);
                continue;
            }
            this.showTraces(n.getChildren(), false);
        }
    }

    protected void showCauses(boolean b) {
        this.showCauses((TNode)this.tgPanel.getSelect(), b);
    }

    protected void join_beliefs(boolean flag) {
        Iterator it = this.tgPanel.getAllNodes();
        if (it != null) {
            ArrayList nodes = new ArrayList(this.tgPanel.getNodeCount());
            while (it.hasNext()) {
                Object o = it.next();
                if ((!flag || !(o instanceof TBeliefAccess)) && (flag || !(o instanceof TBelief))) continue;
                nodes.add(o);
            }
            int i = nodes.size();
            while (i-- > 0) {
                Object o = nodes.get(i);
                if (flag) {
                    TBeliefAccess ba = (TBeliefAccess)o;
                    this.showTrace(ba.getBeliefNode(), true);
                    this.showTrace(ba, false);
                    continue;
                }
                TBelief bel = (TBelief)o;
                this.showTrace(bel, false);
                this.showTraces(bel.getChildren());
            }
        }
    }

    protected void join_messages(boolean flag) {
        String[] cms = this.ui.ctrl.getComms();
        int i = cms.length;
        while (i-- > 0) {
            TNode n;
            Object[] c = this.ui.ctrl.getComms(cms[i]).toArray();
            if (c == null || c.length <= 0 || !(n = (TNode)c[0]).isVisible() || !(n instanceof TSend)) continue;
            int j = c.length;
            while (j-- > 1) {
                TNode rcv = (TNode)c[j];
                if (!rcv.isVisible()) continue;
                if (flag) {
                    this.tgPanel.addEdge((Edge)new TEdge(n, rcv, TEdge.DEFAULT_LENGTH * 3));
                    continue;
                }
                this.tgPanel.deleteEdge((Edge)new TEdge(n, rcv));
            }
        }
    }

    protected void connectCauses(TBelief bel, List causes) {
        if (!bel.isVisible()) {
            return;
        }
        Iterator it = causes.iterator();
        while (it.hasNext()) {
            TNode n = (TNode)it.next();
            if (!n.isVisible()) continue;
            this.tgPanel.addEdge((Edge)new TEdge(n, bel, TEdge.DEFAULT_LENGTH * 3));
        }
    }

    protected void connectEffects(TBelief bel, List effects) {
        if (!bel.isVisible()) {
            return;
        }
        Iterator it = effects.iterator();
        while (it.hasNext()) {
            TNode n = (TNode)it.next();
            if (!n.isVisible()) continue;
            this.tgPanel.addEdge((Edge)new TEdge(bel, n, TEdge.DEFAULT_LENGTH * 3));
        }
    }

    public void childAdded(TNode caller, TNode node) {
        if (caller.isVisible() && node.isVisible()) {
            this.tgPanel.addEdge((Edge)new TEdge(caller, node));
        }
    }

    public void parentAdded(TNode caller, TNode node) {
        if (caller.isVisible() && node.isVisible()) {
            this.tgPanel.addEdge((Edge)new TEdge(node, caller));
        }
    }

    public void childRemoved(TNode caller, TNode node, int index) {
        this.tgPanel.deleteEdge((Edge)new TEdge(caller, node));
    }

    public void parentRemoved(TNode caller, TNode node, int index) {
        this.tgPanel.deleteEdge((Edge)new TEdge(node, caller));
    }

    public void nodeChanged(TNode caller) {
    }

    public void nodeDeleted(TNode caller) {
        this.showTrace(caller, false);
    }

    public void showActions(boolean b) {
        if (b) {
            this.showNodes(TAction.class);
        } else {
            this.hideNodes(TAction.class);
        }
    }

    public void showBeliefs(boolean b) {
        if (b) {
            if (this.JOIN_BELIEFS.isSelected()) {
                this.showNodes(TBelief.class);
            } else {
                this.showNodes(TBeliefAccess.class);
            }
        } else {
            this.hideNodes(TBeliefAccess.class);
            this.hideNodes(TBelief.class);
        }
    }

    public void showMessages(boolean b) {
        if (b) {
            this.showNodes(TAbstractC.class);
        } else {
            this.hideNodes(TSend.class);
        }
    }

    private void showNodes(Class clazz) {
        Iterator it = this.tgPanel.getAllNodes();
        if (it != null) {
            ArrayList nodes = new ArrayList(this.tgPanel.getNodeCount());
            while (it.hasNext()) {
                Object o = it.next();
                nodes.add(o);
            }
            int i = nodes.size();
            while (i-- > 0) {
                TNode n = (TNode)nodes.get(i);
                TNode[] ps = n.getParents();
                int pi = ps.length;
                while (pi-- > 0) {
                    TNode p = ps[pi];
                    if (p.isVisible() || !clazz.isInstance(p)) continue;
                    this.showTrace(p, true);
                }
                TNode[] cs = n.getChildren();
                int ci = cs.length;
                while (ci-- > 0) {
                    TNode c = cs[ci];
                    if (c.isVisible() || !clazz.isInstance(c)) continue;
                    this.showTrace(c, true);
                }
            }
        }
    }

    private void hideNodes(Class clazz) {
        Iterator it = this.tgPanel.getAllNodes();
        if (it != null) {
            ArrayList nodes = new ArrayList(this.tgPanel.getNodeCount());
            while (it.hasNext()) {
                Object o = it.next();
                if (!clazz.isInstance(o)) continue;
                nodes.add(o);
            }
            int i = nodes.size();
            while (i-- > 0) {
                this.showTrace((TNode)nodes.get(i), false);
            }
        }
    }

    class TTGPanel
    extends TGPanel {
        protected final Vector graphListeners = new Vector();
        protected Graphics offgraphics;
        protected Image offscreen;
        protected Dimension offscreensize;
        protected final TGForEachNode paintNodes = new TGForEachNode(this){
            private final /* synthetic */ TTGPanel this$1;
            {
                this.this$1 = this$1;
            }

            public void forEachNode(Node n) {
                if (TTGPanel.access$000((TTGPanel)this.this$1).LABEL_VIEW.isSelected()) {
                    n.paint(this.this$1.offgraphics, (TGPanel)this.this$1);
                } else {
                    ((TNode)n).paintIcon(this.this$1.offgraphics);
                }
            }
        };
        protected final TGForEachEdge paintEdges = new TGForEachEdge(this){
            private final /* synthetic */ TTGPanel this$1;
            {
                this.this$1 = this$1;
            }

            public void forEachEdge(Edge edge) {
                edge.paint(this.this$1.offgraphics, (TGPanel)this.this$1);
            }
        };

        TTGPanel() {
        }

        public String getToolTipText(MouseEvent event) {
            TNode mouseOver = (TNode)this.getMouseOverN();
            if (mouseOver != null) {
                return mouseOver.getToolTip();
            }
            return super.getToolTipText(event);
        }

        public synchronized void update(Graphics g) {
            Dimension d = this.getSize();
            if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
                this.offscreen = this.createImage(d.width, d.height);
                this.offscreensize = d;
                this.offgraphics = this.offscreen.getGraphics();
                this.processGraphMove();
                this.findMouseOver();
            }
            this.offgraphics.setColor(BACK_COLOR);
            this.offgraphics.fillRect(0, 0, d.width, d.height);
            this.getGES().forAllEdges(this.paintEdges);
            this.getGES().forAllNodes(this.paintNodes);
            if (this.mouseOverE != null) {
                this.mouseOverE.paint(this.offgraphics, (TGPanel)this);
                this.paintNodes.forEachNode(this.mouseOverE.from);
                this.paintNodes.forEachNode(this.mouseOverE.to);
            }
            if (this.select != null) {
                this.select.paint(this.offgraphics, (TGPanel)this);
            }
            if (this.mouseOverN != null && this.mouseOverN != this.select) {
                this.paintNodes.forEachNode(this.mouseOverN);
            }
            this.paintComponents(this.offgraphics);
            g.drawImage(this.offscreen, 0, 0, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repaintAfterMove() {
            GraphListener[] ls = null;
            TTGPanel tTGPanel = this;
            synchronized (tTGPanel) {
                this.processGraphMove();
                this.findMouseOver();
                if (this.graphListeners != null) {
                    ls = this.graphListeners.toArray(new GraphListener[this.graphListeners.size()]);
                }
            }
            if (ls != null) {
                for (int i = 0; i < ls.length; ++i) {
                    ls[i].graphMoved();
                }
            }
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireResetEvent() {
            GraphListener[] ls = null;
            TTGPanel tTGPanel = this;
            synchronized (tTGPanel) {
                if (this.graphListeners != null) {
                    ls = this.graphListeners.toArray(new GraphListener[this.graphListeners.size()]);
                }
            }
            if (ls != null) {
                for (int i = 0; i < ls.length; ++i) {
                    ls[i].graphReset();
                }
            }
        }

        public void addGraphListener(GraphListener gl) {
            this.graphListeners.addElement(gl);
            super.addGraphListener(gl);
        }

        public void removeGraphListener(GraphListener gl) {
            this.graphListeners.removeElement(gl);
            super.removeGraphListener(gl);
        }

        static /* synthetic */ GraphPanel access$000(TTGPanel x0) {
            return x0.GraphPanel.this;
        }
    }
}

