/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer.ui;

import jadex.tools.ontology.Tracing;
import jadex.tools.tracer.nodes.TAgent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AgentFilterPanel
extends JPanel {
    protected TAgent agent;
    protected JCheckBox breads;
    protected JCheckBox bwrites;
    protected JCheckBox goals;
    protected JCheckBox plans;
    protected JCheckBox messages;
    protected JCheckBox events;
    protected JCheckBox actions;
    protected JComboBox nodelimit;

    public AgentFilterPanel(final TAgent agent) {
        this.agent = agent;
        Tracing tracing = agent.getTracing();
        this.breads = new JCheckBox("Trace Belief Reads", tracing.isBeliefReads());
        this.bwrites = new JCheckBox("Trace Belief Writes", tracing.isBeliefWrites());
        this.goals = new JCheckBox("Trace Goals", tracing.isGoals());
        this.plans = new JCheckBox("Trace Plans", tracing.isPlans());
        this.messages = new JCheckBox("Trace Messages", tracing.isMessages());
        this.events = new JCheckBox("Trace Internal Events", tracing.isEvents());
        this.actions = new JCheckBox("Trace Actions", tracing.isActions());
        this.breads.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                agent.getTracing().setBeliefReads(AgentFilterPanel.this.breads.isSelected());
            }
        });
        this.bwrites.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                agent.getTracing().setBeliefWrites(AgentFilterPanel.this.bwrites.isSelected());
            }
        });
        this.goals.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                agent.getTracing().setGoals(AgentFilterPanel.this.goals.isSelected());
            }
        });
        this.plans.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                agent.getTracing().setPlans(AgentFilterPanel.this.plans.isSelected());
            }
        });
        this.messages.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                agent.getTracing().setMessages(AgentFilterPanel.this.messages.isSelected());
            }
        });
        this.events.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                agent.getTracing().setEvents(AgentFilterPanel.this.events.isSelected());
            }
        });
        this.actions.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                agent.getTracing().setActions(AgentFilterPanel.this.actions.isSelected());
            }
        });
        this.nodelimit = new JComboBox<String>(new String[]{"10", "100", "250", "unlimited"});
        this.nodelimit.setPreferredSize(new Dimension(new JTextField((int)6).getPreferredSize().width, this.nodelimit.getPreferredSize().height));
        this.nodelimit.setSelectedItem(agent.getEnforceNodeLimit() ? "" + agent.getNodesLimt() : "unlimited");
        this.nodelimit.setEditable(true);
        this.nodelimit.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (AgentFilterPanel.this.nodelimit.getSelectedItem().equals("unlimited")) {
                    agent.setEnforceNodeLimit(false);
                } else {
                    try {
                        agent.setNodesLimit(Integer.parseInt((String)AgentFilterPanel.this.nodelimit.getSelectedItem()));
                        agent.setEnforceNodeLimit(true);
                    }
                    catch (NumberFormatException ex) {
                        AgentFilterPanel.this.nodelimit.setSelectedItem(agent.getEnforceNodeLimit() ? "" + agent.getNodesLimt() : "unlimited");
                    }
                }
            }
        });
        this.setLayout(new GridBagLayout());
        int row = 0;
        int col = 0;
        this.add((Component)this.breads, new GridBagConstraints(col, row++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.bwrites, new GridBagConstraints(col, row++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.goals, new GridBagConstraints(col, row++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.plans, new GridBagConstraints(col, row++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.messages, new GridBagConstraints(col, row++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.events, new GridBagConstraints(col, row++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.actions, new GridBagConstraints(col, row++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel("Nodes Limit"), new GridBagConstraints(col, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 2), 0, 0));
        this.add((Component)this.nodelimit, new GridBagConstraints(col + 1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
    }

    public void reset() {
        this.breads.setSelected(this.agent.getTracing().isBeliefReads());
        this.bwrites.setSelected(this.agent.getTracing().isBeliefWrites());
        this.goals.setSelected(this.agent.getTracing().isGoals());
        this.plans.setSelected(this.agent.getTracing().isPlans());
        this.messages.setSelected(this.agent.getTracing().isMessages());
        this.events.setSelected(this.agent.getTracing().isEvents());
        this.actions.setSelected(this.agent.getTracing().isActions());
        this.nodelimit.setSelectedItem(this.agent.getEnforceNodeLimit() ? "" + this.agent.getNodesLimt() : "unlimited");
    }
}

