/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer.nodes;

import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPanel;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.tools.ontology.OTrace;
import jadex.tools.tracer.nodes.TNodeListener;
import jadex.tools.tracer.ui.LookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;

public abstract class TNode
extends Node
implements TreeNode {
    public static final String TOP = "top";
    public final OTrace trace;
    protected final String causes;
    protected final String[] carray;
    protected final AgentIdentifier aid;
    protected final long seq;
    protected final String time;
    protected final Date date;
    protected final String name;
    protected final Color darkColor;
    protected final List listeners;
    protected String tooltip;
    protected final Vector children = new Vector();
    protected final List parents = new Vector();

    public TNode() {
        this(null, TOP, null);
    }

    public TNode(AgentIdentifier aid) {
        this(aid, aid.getName(), TOP);
    }

    public TNode(AgentIdentifier aid, String id, String cause) {
        super(id);
        this.setType(this.getType());
        this.setBackColor(this.getBackColor());
        this.seq = 0L;
        this.date = new Date(System.currentTimeMillis());
        this.time = LookAndFeel.TIME.format(this.date);
        this.aid = aid;
        this.trace = null;
        this.carray = new String[]{cause};
        this.causes = cause;
        this.name = id;
        this.darkColor = this.getColor().darker().darker();
        if (id.length() > 100) {
            this.setLabel(id.substring(0, 100));
        }
        this.listeners = new Vector();
    }

    public TNode(AgentIdentifier aid, OTrace trace) {
        super(Double.toString(Math.random()));
        this.setLabel(trace.getName());
        this.setType(this.getType());
        this.setBackColor(this.getBackColor());
        this.aid = aid;
        this.seq = Long.decode(trace.getSeq());
        long millis = Long.decode(trace.getTime());
        this.date = new Date(millis);
        this.time = LookAndFeel.TIME.format(this.date);
        this.trace = trace;
        this.causes = trace.getCause();
        this.carray = TNode.getCausesArray(this.causes);
        this.name = trace.getName();
        this.darkColor = this.getColor().darker().darker();
        if (this.name.length() > 100) {
            this.setLabel(this.name.substring(0, 100));
        }
        this.tooltip = this.getToolTip();
        this.listeners = new Vector();
    }

    protected static String[] getCausesArray(String causes) {
        ArrayList<String> cs = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(causes, ",");
        while (st.hasMoreTokens()) {
            String cause = st.nextToken().trim();
            if (cause.length() <= 0) continue;
            cs.add(cause);
        }
        return cs.toArray(new String[cs.size()]);
    }

    public String getCauses() {
        return this.causes;
    }

    public String getTime() {
        return this.time;
    }

    public AgentIdentifier getAID() {
        return this.aid;
    }

    public String getName() {
        return this.name;
    }

    public abstract ImageIcon getIcon();

    public abstract Color getColor();

    public abstract String getTraceType();

    public boolean isBeliefAccess() {
        return false;
    }

    public boolean isCommunication() {
        return false;
    }

    public void setLabel(String lbl) {
        if (lbl.length() > 100) {
            super.setLabel(lbl.substring(1, 100).trim());
        } else {
            super.setLabel(lbl.trim());
        }
    }

    public Color getBackColor() {
        return this.getColor();
    }

    public void paintIcon(Graphics g) {
        Image img = this.getIcon().getImage();
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        int x = (int)(this.drawx - (double)(w / 2));
        int y = (int)(this.drawy - (double)(h / 2));
        g.drawImage(img, x, y, null);
    }

    public void paint(Graphics g, TGPanel tgPanel) {
        if (!this.intersects(tgPanel.getSize())) {
            return;
        }
        g.setFont(this.font);
        this.fontMetrics = g.getFontMetrics();
        int ix = (int)this.drawx;
        int iy = (int)this.drawy;
        int h = this.getHeight() + 1;
        int w = this.getWidth() + 1;
        int h2 = h / 2;
        int w2 = w / 2;
        int r = h2 + 1;
        if (this == tgPanel.getSelect()) {
            g.setColor(LookAndFeel.SELECT_COLOR);
        } else {
            g.setColor(LookAndFeel.GRAPH_COLOR);
        }
        this.fillFigure(g, ix - w2, iy - h2, w, h, r);
        if (this == tgPanel.getDragNode()) {
            g.setColor(LookAndFeel.DRAG_COLOR);
        } else if (this == tgPanel.getMouseOverN()) {
            g.setColor(LookAndFeel.HIGHLIGHT);
        } else {
            g.setColor(this.getColor());
        }
        this.drawFigure(g, ix - w2, iy - h2, w, h, r);
        g.setColor(this.darkColor);
        g.drawString(this.lbl, ix - this.fontMetrics.stringWidth(this.lbl) / 2 + 1, iy + this.fontMetrics.getDescent() + 3);
    }

    protected void fillFigure(Graphics g, int x, int y, int w, int h, int r) {
        g.fillRoundRect(x, y, w, h, r, r);
    }

    protected void drawFigure(Graphics g, int x, int y, int w, int h, int r) {
        g.drawRoundRect(x, y, w, h, r, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TNode[] getChildren() {
        Vector vector = this.children;
        synchronized (vector) {
            return this.children.toArray(new TNode[this.children.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TNode[] getParents() {
        List list = this.parents;
        synchronized (list) {
            return this.parents.toArray(new TNode[this.parents.size()]);
        }
    }

    public Enumeration children() {
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    public TreeNode getParent() {
        if (this.parents.isEmpty()) {
            return null;
        }
        return (TreeNode)this.parents.get(0);
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public String getToolTip() {
        if (this.tooltip == null) {
            StringBuffer buf = new StringBuffer();
            if (this.trace != null) {
                buf.append("<HTML><TABLE>");
                TNode.appendLine(buf, this.getTraceType().toUpperCase(), this.name);
                TNode.appendLine(buf, "Value", this.trace.getValue());
                this.appendRest(buf);
                buf.append("</TABLE></HTML>");
            } else {
                buf.append(TOP);
            }
            return buf.toString();
        }
        return this.tooltip;
    }

    protected void appendRest(StringBuffer buf) {
        if (this.aid != null) {
            TNode.appendLine(buf, "Agent", this.aid.getName());
        }
        TNode.appendLine(buf, "Seq", this.trace.getSeq());
        TNode.appendLine(buf, "Causes", this.causes);
        TNode.appendLine(buf, "Date", this.date.toString());
        TNode.appendLine(buf, "Thread", this.trace.getThread());
        this.appendStack(buf, 10);
    }

    protected static void appendLine(StringBuffer buf, String name, String value) {
        buf.append("<TR><TD><B>");
        buf.append(name);
        buf.append("</B></TD><TD>=</TD><TD>");
        TNode.escape(buf, value, false);
        buf.append("</TD></TR>");
    }

    protected static void escape(StringBuffer buf, String value, boolean qt) {
        if (value == null) {
            return;
        }
        char[] chrs = value.toCharArray();
        block7: for (int i = 0; i < chrs.length; ++i) {
            switch (chrs[i]) {
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                case ' ': {
                    buf.append("&nbsp;");
                    continue block7;
                }
                case '\n': {
                    if (qt) {
                        buf.append("<br>");
                        continue block7;
                    }
                }
                default: {
                    buf.append(chrs[i]);
                }
            }
        }
    }

    protected void appendStack(StringBuffer buffer, int max) {
        StringBuffer buf = new StringBuffer();
        buf.append("<TR valign=\"top\"><TD><B>Stack</B></TD><TD>=</TD><TD><TABLE>");
        int lines = 0;
        String[] se = this.trace.getStack();
        for (int i = 0; i < se.length && lines < max; ++i) {
            boolean black;
            String line = se[i];
            boolean bl = black = !line.startsWith("java.") && !line.startsWith("jade.") && !line.startsWith("jadex.") && !line.startsWith("sun.reflect.") && !line.startsWith("javax.") || line.startsWith("jadex.examples.");
            if (!black && lines <= 0) continue;
            buf.append("<TR><TD>");
            if (!black) {
                buf.append("<I>");
            }
            buf.append(line);
            ++lines;
            if (!black) {
                buf.append("</I>");
            }
            buf.append("<TD></TR>");
        }
        buf.append("</TABLE></TD></TR>");
        if (lines > 0) {
            buffer.append(buf);
        }
    }

    protected synchronized boolean addChild(TNode child) {
        if (child == null || child == this) {
            return false;
        }
        if (this.hasGrandparent(child)) {
            return false;
        }
        if (!this.children.contains(child)) {
            this.children.add(child);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeChild(TNode node) {
        int ci;
        TNode tNode = this;
        synchronized (tNode) {
            ci = this.children.indexOf(node);
            if (ci >= 0) {
                this.children.remove(ci);
            }
        }
        return ci;
    }

    private boolean hasGrandchild(TNode child) {
        if (this.children.contains(child)) {
            return true;
        }
        TNode[] cs = this.getChildren();
        int i = cs.length;
        while (i-- > 0) {
            TNode node = cs[i];
            if (!node.hasGrandchild(child)) continue;
            return true;
        }
        return false;
    }

    public int childIndex(TNode node) {
        return this.children.indexOf(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addParent(TNode node) {
        if (node == null || node == this) {
            return false;
        }
        if (this.hasGrandparent(node)) {
            return false;
        }
        if (this.hasGrandchild(node)) {
            return false;
        }
        this.removeGrandparentsOf(node);
        boolean fire = false;
        TNode tNode = this;
        synchronized (tNode) {
            if (node.addChild(this)) {
                this.parents.add(node);
                this.setLocation(node.getLocation());
                fire = true;
            }
        }
        if (fire) {
            this.fireParentAdded(node);
            node.fireChildAdded(this);
        }
        return fire;
    }

    protected void removeGrandparentsOf(TNode node) {
        TNode[] ps = this.getParents();
        int i = ps.length;
        while (i-- > 0) {
            TNode p = ps[i];
            if (!node.hasGrandparent(p)) continue;
            this.removeParent(p);
        }
    }

    public boolean hasGrandparent(TNode parent) {
        if (this.parents.contains(parent)) {
            return true;
        }
        TNode[] ps = this.getParents();
        int i = ps.length;
        while (i-- > 0) {
            TNode node = ps[i];
            if (!node.hasGrandparent(parent)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParent(TNode node) {
        int ci;
        int pi;
        boolean fire = false;
        TNode tNode = this;
        synchronized (tNode) {
            pi = this.parents.indexOf(node);
            if (pi >= 0) {
                ci = node.removeChild(this);
                if (ci >= 0) {
                    this.parents.remove(pi);
                    fire = true;
                }
            } else {
                ci = -1;
            }
        }
        if (fire) {
            this.fireParentRemoved(node, pi);
            node.fireChildRemoved(this, ci);
        }
    }

    public boolean hasParents() {
        return !this.parents.isEmpty();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Iterator parents() {
        return this.parents.iterator();
    }

    public String toString() {
        return this.lbl;
    }

    public long getSeq() {
        return this.seq;
    }

    public String[] getCausesArray() {
        return this.carray;
    }

    public boolean hasCause(String cause) {
        if (this.carray != null) {
            int i = this.carray.length;
            while (i-- > 0) {
                if (this.carray[i] == null || !this.carray[i].equals(cause)) continue;
                return true;
            }
        }
        return false;
    }

    public void addListener(TNodeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeListener(TNodeListener l) {
        this.listeners.remove(l);
    }

    public void fireChildAdded(TNode node) {
        int i = this.listeners.size();
        while (i-- > 0) {
            TNodeListener l = this.getListener(i);
            l.childAdded(this, node);
        }
    }

    public void fireChildRemoved(TNode node, int ci) {
        int i = this.listeners.size();
        while (i-- > 0) {
            TNodeListener l = this.getListener(i);
            if (l == null) continue;
            l.childRemoved(this, node, ci);
        }
    }

    public void fireParentAdded(TNode node) {
        int i = this.listeners.size();
        while (i-- > 0) {
            TNodeListener l = this.getListener(i);
            if (l == null) continue;
            l.childAdded(this, node);
        }
    }

    public void fireParentRemoved(TNode node, int pi) {
        int i = this.listeners.size();
        while (i-- > 0) {
            TNodeListener l = this.getListener(i);
            if (l == null) continue;
            l.parentRemoved(this, node, pi);
        }
    }

    public void fireNodeChanged() {
        int i = this.listeners.size();
        while (i-- > 0) {
            TNodeListener l = this.getListener(i);
            if (l == null) continue;
            l.nodeChanged(this);
        }
    }

    public void deleted() {
        int i = this.listeners.size();
        while (i-- > 0) {
            TNodeListener l = this.getListener(i);
            if (l == null) continue;
            l.nodeDeleted(this);
        }
    }

    private TNodeListener getListener(int i) {
        try {
            return (TNodeListener)this.listeners.get(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasVisibleParents() {
        TNode[] ps = this.getParents();
        int i = ps.length;
        while (i-- > 0) {
            if (!ps[i].isVisible()) continue;
            return true;
        }
        return false;
    }

    public boolean hasVisibleChildren() {
        TNode[] cs = this.getChildren();
        int i = cs.length;
        while (i-- > 0) {
            if (!cs[i].isVisible()) continue;
            return true;
        }
        return false;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isAgent() {
        return false;
    }
}

