/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer.nodes;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.tools.tracer.nodes.TBeliefAccess;
import jadex.tools.tracer.nodes.TNode;
import jadex.tools.tracer.ui.LookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.ImageIcon;

public class TBelief
extends TNode {
    public TBelief(AgentIdentifier aid, String id) {
        super(aid, id, aid.getName());
    }

    public ImageIcon getIcon() {
        return LookAndFeel.BELIEF_ICON;
    }

    public Color getColor() {
        return LookAndFeel.BELIEF_COLOR;
    }

    public String getTraceType() {
        return "Belief";
    }

    protected boolean addChild(TNode child) {
        if (child instanceof TBeliefAccess && super.addChild(child)) {
            ((TBeliefAccess)child).belief_node = this;
            this.tooltip = null;
            return true;
        }
        return false;
    }

    public String getToolTip() {
        if (this.tooltip == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("<HTML><TABLE>");
            TBelief.appendLine(buf, this.getTraceType().toUpperCase(), this.name);
            int i = this.getChildCount();
            int limes = i - 10;
            int n = limes = limes >= 0 ? limes : 0;
            while (i-- > limes) {
                TNode node = (TNode)this.getChildAt(i);
                TBelief.appendLine(buf, node.getTraceType(), node.date.toString());
            }
            buf.append("</TABLE></HTML>");
            this.tooltip = buf.toString();
            return this.tooltip;
        }
        return this.tooltip;
    }

    protected void drawFigure(Graphics g, int x, int y, int w, int h, int r) {
        g.drawOval(x, y, w, h);
    }

    protected void fillFigure(Graphics g, int x, int y, int w, int h, int r) {
        g.fillOval(x, y, w, h);
    }
}

