/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer.nodes;

import com.touchgraph.graphlayout.TGPanel;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.tools.ontology.Tracing;
import jadex.tools.tracer.nodes.TBeliefAccess;
import jadex.tools.tracer.nodes.TNode;
import jadex.tools.tracer.nodes.TNodeListener;
import jadex.tools.tracer.ui.LookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;

public class TAgent
extends TNode
implements TNodeListener {
    protected final String hap;
    protected final String local;
    protected boolean alive;
    protected boolean ignored;
    protected final Map id2node;
    protected final List traces;
    protected final Map beliefs;
    private boolean enforceNodeLimit;
    private int nodes_limit;
    private Tracing tracing = new Tracing();

    public TAgent(AgentIdentifier aid) {
        super(aid);
        String[] addrs = aid.getAddresses();
        if (addrs.length > 0) {
            String addr = addrs[0];
            int dp = addr.indexOf(64);
            if (dp > 0) {
                this.local = addr.substring(0, dp);
                this.hap = addr.substring(dp + 1);
            } else {
                this.local = aid.getName();
                this.hap = "";
            }
        } else {
            this.local = aid.getName();
            this.hap = "";
        }
        this.alive = true;
        this.ignored = false;
        this.id2node = new HashMap();
        this.traces = new Vector();
        this.beliefs = new HashMap();
    }

    public void copyFilters(TAgent proto) {
        this.enforceNodeLimit = proto.enforceNodeLimit;
        this.nodes_limit = proto.nodes_limit;
        this.ignored = proto.ignored;
        this.tracing = new Tracing(proto.tracing);
    }

    public ImageIcon getIcon() {
        if (!this.alive) {
            return LookAndFeel.DAGENT_ICON;
        }
        if (this.ignored) {
            return LookAndFeel.IGNORED_AGENT_ICON;
        }
        if (this.tracing.isTracing()) {
            return LookAndFeel.WATCHED_AGENT_ICON;
        }
        return LookAndFeel.AGENT_ICON;
    }

    public Color getColor() {
        if (!this.alive) {
            return LookAndFeel.DAGENT_COLOR;
        }
        if (this.ignored) {
            return LookAndFeel.IGNORED_AGENT_COLOR;
        }
        if (this.tracing.isTracing()) {
            return LookAndFeel.WATCHED_AGENT_COLOR;
        }
        return LookAndFeel.AGENT_COLOR;
    }

    public String getTraceType() {
        return "Agent";
    }

    public String getToolTip() {
        if (this.tooltip == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("<HTML><TABLE>");
            TAgent.appendLine(buf, this.getTraceType().toUpperCase(), this.name);
            TAgent.appendLine(buf, "date", this.date.toString());
            buf.append("</TABLE></HTML>");
            return buf.toString();
        }
        return this.tooltip;
    }

    public void paint(Graphics g, TGPanel tgPanel) {
        if (!this.intersects(tgPanel.getSize())) {
            return;
        }
        g.setFont(this.font);
        this.fontMetrics = g.getFontMetrics();
        int ix = (int)this.drawx;
        int iy = (int)this.drawy;
        int h = this.getHeight();
        int w = this.getWidth();
        int h2 = h / 2;
        int w2 = w / 2;
        if (this == tgPanel.getSelect()) {
            g.setColor(LookAndFeel.SELECT_COLOR);
        } else {
            g.setColor(LookAndFeel.GRAPH_COLOR);
        }
        g.fillRect(ix - w2, iy - h2, w, h);
        if (this == tgPanel.getDragNode()) {
            g.setColor(LookAndFeel.DRAG_COLOR);
        } else if (this == tgPanel.getMouseOverN()) {
            g.setColor(LookAndFeel.HIGHLIGHT);
        } else {
            g.setColor(this.getColor());
        }
        g.drawRect(ix - w2, iy - h2, w, h);
        g.setColor(this.darkColor);
        g.drawString(this.local, ix - w2 + 3, iy - h2 / 2 + this.fontMetrics.getDescent() + 3);
        g.drawString(this.hap, ix - w2 + 3, iy + h2 / 2 + this.fontMetrics.getDescent() + 3);
    }

    public int getHeight() {
        if (this.fontMetrics != null) {
            return this.fontMetrics.getHeight() * 2 + 6;
        }
        return 6;
    }

    public int getWidth() {
        if (this.fontMetrics != null && this.local != null) {
            int w2;
            int w1 = this.fontMetrics.stringWidth(this.local);
            int w = w1 > (w2 = this.fontMetrics.stringWidth(this.hap)) ? w1 : w2;
            return w + 12;
        }
        return 10;
    }

    public void setIgnored(boolean flag) {
        if (this.ignored != flag) {
            this.ignored = flag;
            this.fireNodeChanged();
        }
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setAlive(boolean flag) {
        if (this.alive != flag) {
            this.alive = flag;
            this.fireNodeChanged();
        }
    }

    public synchronized boolean addTrace(TNode tn) {
        if (this.tracing.isTracing(tn.trace)) {
            if (!(tn instanceof TBeliefAccess)) {
                if (this.id2node.containsKey(tn.getName())) {
                    return false;
                }
                this.id2node.put(tn.getName(), tn);
            }
            this.traces.add(tn);
            tn.addListener(this);
            tn.drawx = this.drawx + 5.0 - Math.random() * 10.0;
            tn.drawy = this.drawy + 5.0 - Math.random() * 10.0;
            return true;
        }
        return false;
    }

    public Map getBeliefs() {
        return this.beliefs;
    }

    public TNode getTrace(String id) {
        return (TNode)this.id2node.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TNode[] getTraces() {
        TNode[] ret;
        List list = this.traces;
        synchronized (list) {
            ret = this.traces.toArray(new TNode[this.traces.size()]);
        }
        return ret;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public boolean isAgent() {
        return true;
    }

    public void childAdded(TNode caller, TNode node) {
    }

    public void parentAdded(TNode caller, TNode node) {
    }

    public void childRemoved(TNode caller, TNode node, int index) {
    }

    public void parentRemoved(TNode caller, TNode node, int index) {
    }

    public void nodeChanged(TNode caller) {
    }

    public void nodeDeleted(TNode caller) {
        this.id2node.remove(caller.getName());
        this.traces.remove(caller);
        caller.removeListener(this);
    }

    public void setEnforceNodeLimit(boolean b) {
        this.enforceNodeLimit = b;
    }

    public void setNodesLimit(int i) {
        this.nodes_limit = i;
    }

    public boolean getEnforceNodeLimit() {
        return this.enforceNodeLimit;
    }

    public int getNodesLimt() {
        return this.nodes_limit;
    }

    public Tracing getTracing() {
        return this.tracing;
    }

    public void setTracing(Tracing tracing) {
        this.tracing = new Tracing(tracing);
    }
}

